//%attributes = {}
//******************************************************************************
//
//Method: SDA_ClipboardOps(Operation;PtrToTextVar;{false})->status
//
//Written by  Tod Gentille on 10/11/97
//
//Purpose: Perform a non-destructive copy, cut, or paste, using the passed paramet
//
//$1 - text -the operation to perform (i.e. cut, copy, paste)
//$2 - ptr to  var to be used by clipboard operations
//$3 - boolean optional paramter to indicate whether calling proc wants us to wait
//after doing the op to give the posted key a chance to be processed.
//if not passed always assume that the wait should happen Only affects
//the paste operation since cut an copy now don't use a timed wait technique
//$0 - boolean - true if everything works

//NOTE: This method is an exception to the naming convention. The method that 
//handles the cliboard popup on the palette is called SDA_Clipboards. This 
//was done to make upgrading user developed routines easier. 
//See end of method for mod history
//
//NOTE: This method is coupled to <>lSDA_DecideByContents. This was necessary to 
//make the parameters consistent with earlier versions and to add the ability
//to support both text and pictures in the new versions
//******************************************************************************
C_TEXT:C284($1; $tOperation)
C_POINTER:C301($2; $pVarForOperation)
C_BOOLEAN:C305($3; $bTimedWait)
C_BOOLEAN:C305($0)
C_BOOLEAN:C305($bDoGet; $bGo)  //used to specify that text must be retrieved from clipboard
C_TEXT:C284($tSaveClip)

C_TEXT:C284($tTEST_CLIPBOARD_CHANGE)
$tTEST_CLIPBOARD_CHANGE:="%SDAWaiting"  //some text we never expect to actually find in the clipboard
C_TEXT:C284($tSaveClip)
C_PICTURE:C286($u_Picture)
C_TEXT:C284($tOrigClipboardDataType)  //tracks whether clipboard currently has text or picture data

//These clipboard arrays are only used here and in SDA_ClipboardSaveContents
//and SDA_ClipboardLoadContents
ARRAY TEXT:C222(<>atSDA_Clipboard; 5)
ARRAY PICTURE:C279(<>axSDA_Clipboard; 5)
ARRAY TEXT:C222(<>atSDA_ClipboardType; 5)

SDA_util_65Fix

$tOperation:=$1
$pVarForOperation:=$2

If (Count parameters:C259>2)
	$bTimedWait:=$3
Else 
	$bTimedWait:=True:C214
End if 

$bGo:=True:C214

If (SDA_util_ProcessCheck#0)  //Make sure the design environment has the frontmost window
	
	Case of   //save clipboard now so we can restore it before exiting
			
		: (Pasteboard data size:C400(Text data:K20:2)>0)
			$tSaveClip:=Get text from pasteboard:C524
			$tOrigClipboardDataType:=Text data:K20:2
			
		: (Pasteboard data size:C400(Picture data:K20:3)>0)
			GET PICTURE FROM PASTEBOARD:C522($u_Picture)
			$tOrigClipboardDataType:=Picture data:K20:3
			
		Else 
			$tOrigClipboardDataType:=<>SDA_INVALID_CLIP_DATA
	End case 
	
	Case of   //-------------------- Perform the passed operation in the Design environment
			
		: ($tOperation=<>SDA_CUT)
			SET TEXT TO PASTEBOARD:C523($tTEST_CLIPBOARD_CHANGE)
			SDA_util_PostKey(<>SDA_ASCII_CUT_KEY; Command key mask:K16:1; False:C215)  //don't do a timed wait
			$bGo:=SDA_util_PostWaitChange($tTEST_CLIPBOARD_CHANGE)  //wait for clipboard contents to change
			$bDoGet:=True:C214
			
		: ($tOperation=<>SDA_COPY)
			SET TEXT TO PASTEBOARD:C523($tTEST_CLIPBOARD_CHANGE)  //Load clipboard with test text
			SDA_util_PostKey(<>SDA_ASCII_COPY_KEY; Command key mask:K16:1; False:C215)  //don't do a timed wait
			$bGo:=SDA_util_PostWaitChange($tTEST_CLIPBOARD_CHANGE)  //wait for clipboard contents to change
			$bDoGet:=True:C214
			
		: ($tOperation=<>SDA_PASTE)
			//if we are using the SDA clipboard then find out if they have text or picts      
			If ($pVarForOperation=(-><>lSDA_DecideByContents))
				If (<>atSDA_ClipboardType{<>lSDA_DecideByContents}=Picture data:K20:3)
					$pVarForOperation:=-><>axSDA_Clipboard{<>lSDA_DecideByContents}
				Else   //assume text, if clipboard has no data yet nothing will happen
					$pVarForOperation:=-><>atSDA_Clipboard{<>lSDA_DecideByContents}
				End if 
			End if 
			
			//call the special paste method that supports both picts and text    
			$bGo:=SDA_ClipboardPaste($pVarForOperation; $bTimedWait)
			$bDoGet:=False:C215
			
		Else   //no recognized operation
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "SDA_ClipboardOps "; $1)
			$bGo:=False:C215
	End case 
	
	If ($bGo)
		
		If ($bDoGet)  // the operation requires that we get what is now on the clipboard
			//put the results in the passed  variable, do it in a way that supports text and 
			//pictures
			If ($pVarForOperation=(-><>lSDA_DecideByContents))  //when using SDA clipboards this variable is passed
				//as a way of letting us know we have to figure out whether to retrieve text or pi
				//this was done this way to make SDA_clipboardOps compatible with previous version
				//it is NOT a recommended coding technique.
				Case of 
					: (Pasteboard data size:C400(Text data:K20:2)>0)
						$pVarForOperation:=-><>atSDA_Clipboard{<>lSDA_DecideByContents}
						<>atSDA_ClipboardType{<>lSDA_DecideByContents}:=Text data:K20:2
					: (Pasteboard data size:C400(Picture data:K20:3)>0)
						$pVarForOperation:=-><>axSDA_Clipboard{<>lSDA_DecideByContents}
						<>atSDA_ClipboardType{<>lSDA_DecideByContents}:=Picture data:K20:3
					Else 
						$bGo:=False:C215
				End case 
			End if 
			
			If ($bGo)
				$bGo:=SDA_ClipboardGet($pVarForOperation)
				
			End if 
			
		End if 
		
	End if 
	
	//Restore the original clibboard  
	If (<>bPreserveClipboard)
		Case of   //Restore the original clibboard
				
			: ($tOrigClipboardDataType=Text data:K20:2)
				SET TEXT TO PASTEBOARD:C523($tSaveClip)
				
			: ($tOrigClipboardDataType=Picture data:K20:3)
				SET PICTURE TO PASTEBOARD:C521($u_Picture)
			Else 
				//no need to display error since it might just have been an empty clipboard       
		End case 
		
	End if 
	
Else   //design environment is not frontmost process
	$bGo:=False:C215
	BEEP:C151
End if 

$0:=$bGo

//
//-------------------------------------------------------------------------------
//NOTE: This procedure preserves the current contents of the clipboard.
//Copyright 1997 Syncor Systems, Inc.
//Modified by Tod Gentille on 4/20/98 SDA Version 2.0
//now returns a status. Copy and Cut use a new technique to determine
//if they have been processed -see SDA_PostWaitforClipboardChange
//optional 3rd param to skip wait during paste operation
//Modified by Tod Gentille on 9/25/1998 with input from Ken Ishimoto
//preserve clipboard even if it has picture data
//-------------------------------------------------------------------------------
