//%attributes = {}
//******************************************************************************
//Method: SDA_CommentAdd
//Written by  Tod Gentille on 9/24/1998
//
//Purpose: Add the comment char to every line in the passed selection 
//$1 pointer to array of source lines
//$2 pointer to array of destination lines
//$0 - return text variable of concatenated destination lines
//
//Copyright 1998 Syncor Systems, Inc.
//Modified 6/5/2000 Tod Gentille
//******************************************************************************
C_POINTER:C301($1; $paSourceLines)
C_POINTER:C301($2; $paDestinationLines)
C_TEXT:C284($0)

C_LONGINT:C283($iArraySize; $iDestIdx; $i; $iLineLength; $iNumLines; $iStart)
C_TEXT:C284($tPartialLine)
C_TEXT:C284($tCurrentLine)
_O_C_STRING:C293(1; $tPrefixChar)
C_LONGINT:C283($j; $MAX_LINE_LENGTH)
_O_C_STRING:C293(1; $CR)

$paSourceLines:=$1
$paDestinationLines:=$2

$iArraySize:=Size of array:C274($paSourceLines->)
ARRAY TEXT:C222($paDestinationLines->; $iArraysize)
$iDestIdx:=0

//----- Define the local constants -----
$MAX_LINE_LENGTH:=78  //80 is the max, but leave room for a comment and a continuation character
$CR:=Char:C90(Carriage return:K15:38)

For ($i; 1; $iArraySize)
	
	//Get each line, if it is too long to fit, break it into as many lines as required
	//with a continuation character on all lines after the first one      
	$iDestIdx:=$iDestidx+1
	$tCurrentLine:=$paSourceLines->{$i}
	$iLineLength:=Length:C16($tCurrentLine)
	
	If ($iLineLength>$MAX_LINE_LENGTH)  //----- Is it too long for one line
		$iNumLines:=Int:C8(($iLineLength-1)/$MAX_LINE_LENGTH)  //only need to add lines for the EXTRA lines
		//Modified teg 6/5/2000 2nd param in insert should be $iDestIdx not $i
		INSERT IN ARRAY:C227($paDestinationLines->; $iDestidx; $iNumLines)
		
		$iStart:=1
		$tPrefixChar:=""  //no continuation character for the first line
		For ($j; 1; $iNumLines)
			$tPartialLine:="`"+$tPrefixChar+Substring:C12($tCurrentLine; $iStart; $MAX_LINE_LENGTH)+$CR
			
			$paDestinationLines->{$iDestidx}:=$tPartialLine
			$iDestIdx:=$iDestIdx+1
			$iStart:=$iStart+$MAX_LINE_LENGTH
			$tPrefixChar:=<>SDA_COMMENT_CONTINUATION_CHAR
		End for 
		
		//Get any portion left over e      
		$tPartialLine:="`"+$tPrefixChar+Substring:C12($tCurrentLine; $iStart; $MAX_LINE_LENGTH)
		$paDestinationLines->{$iDestidx}:=$tPartialLine
		
	Else   //----it fits on one line, just assign it to the array
		$paDestinationLines->{$iDestIdx}:="`"+$tCurrentLine
	End if 
	
End for 

//Now put the array elements back together as a single text var
$0:=""
For ($i; 1; $iDestIdx)
	$0:=$0+$paDestinationLines->{$i}
End for 
