//%attributes = {}
//******************************************************************************
//Method: SDA_ImportOps
//
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Handle all the import operations
//
//Copyright 1997 Syncor Systems, Inc.
//`Modified by Tod Gentille on 9/25/1998 to support import button as popup menu
//******************************************************************************

C_TIME:C306(<>hSDA_DocRef)
C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)

$pPopupMenu:=$1

$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup
$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item

If ($iSelItem>0)
	
	Case of 
			
		: ($tChoice="Import File")
			<>hSDA_DocRef:=Open document:C264(""; "SDAM")  //put up the open dialog
			
			If (OK=1)
				SDA_ImportOne(<>hSDA_DocRef)
				
			Else   //the document didn't open
				BEEP:C151
			End if 
			
		: ($tChoice="Import Folder")  //---------- 
			
			If (<>bSDA_FilepackIsHere)
				SDA_ImportMany
				
			Else 
				SDA_util_BugAlert(<>SDA_REQUIRES_FILEPACK; "Method: SDA_ImportOps")
			End if 
			
		: (SDA_ImportOps_y($tChoice))  //Your added operations should be put in this method
			
		Else 
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "Method: SDA_ExportOps"; $tChoice)
			
	End case 
	
End if 
