//%attributes = {}
//******************************************************************************
//
//Method: SDA_PaletteMinMaxToggle
//
//Written by  Tod Gentille on 11/29/97
//
//Purpose: Minimize or Maximze the palette, depending on its current size
//
//Copyright 1997 Syncor Systems, Inc.
//
//NOTE - this procedure relys upon the IP vars, <>lSDA_PaletteWidth and 
//<>lSDA_PaletteHeight and <>lSDA_PaletteWinRef which were set up in SDA_FloatWin
//It also uses <>SDA_PaletteSize to track which version of the palette is currently
//displayed
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/12/99
//Reason: Added a Windows NT height & width adjustment factor to account for the
// different way in which WinNT & the Mac handle the main application window.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 4/26/00
//Reason: Added a test of 4D version since window resizing was repaired by ACI/4D
// sometime during the version 6.5 development cycle.
//******************************************************************************
C_LONGINT:C283($lMinHeight; $lMinWidth)
$lMinHeight:=0  //the width or height of the minimized  palette 0 shows just the title bar
$lMinWidth:=35
C_LONGINT:C283($iLeft; $iRight; $iTop; $iBottom)
C_LONGINT:C283($lWinNTHeightAdjustment; $lWinNTWidthAdjustment)

If (<>SDA_IN_WINDOWS)  //if Windows
	
	If (SDA_util_IsPost60x)  //if post version 6.1
		$lWinNTWidthAdjustment:=0
		$lWinNTHeightAdjustment:=0  //do nothing since window resizing has been repaired 
		
	Else   //prior to version 6.1    
		$lWinNTHeightAdjustment:=42  //Window position adjustment required for Windows NT 4.0. Note that
		$lWinNTWidthAdjustment:=4  // this only works if the 4D Toolbar is off. If you use the Toolbar, you must
		// increase the height adjustment.
	End if 
	
Else   //Mac
	$lWinNTWidthAdjustment:=0
	$lWinNTHeightAdjustment:=0  //do nothing since the window is relative to the Mac screen      
End if 

Case of 
		
	: (<>SDA_PaletteSize=<>SDA_MAXIMIZED_PALETTE)  //it was large, so now shrink it
		GET WINDOW RECT:C443($iLeft; $iTop; $iRight; $iBottom; <>lSDA_PaletteWinRef)
		
		If (<>lSDA_PaletteWidth><>lSDA_PaletteHeight)  //if we were using the horiz toolbar
			$iRight:=$iLeft+$lMinWidth  //it was a horiz palette make the width very small, esp smaller than the height
			$iBottom:=$iTop+$lMinHeight
			
		Else   //using the vertical toolbar
			$iBottom:=$iTop+$lMinHeight
			//don't change the width      
		End if 
		
		$iBottom:=$iBottom-$lWinNTHeightAdjustment  //We must subtract the MDI window bar height. This must be
		$iTop:=$iTop-$lWinNTHeightAdjustment  // adjusted to your window. This setting works on Windows NT 4.0.
		$iRight:=$iRight-$lWinNTWidthAdjustment
		$iLeft:=$iLeft-$lWinNTWidthAdjustment
		SET WINDOW RECT:C444($iLeft; $iTop; $iRight; $iBottom; <>lSDA_PaletteWinRef)
		<>SDA_PaletteSize:=<>SDA_MINIMIZED_PALETTE  //"Minimized"
		
	: (<>SDA_PaletteSize=<>SDA_MINIMIZED_PALETTE)  //it was Minimized, so now expand it
		GET WINDOW RECT:C443($iLeft; $iTop; $iRight; $iBottom; <>lSDA_PaletteWinRef)
		$iBottom:=$iTop+<>lSDA_PaletteHeight
		$iBottom:=$iBottom-$lWinNTHeightAdjustment  //We must subtract the MDI window bar height. This must be
		$iTop:=$iTop-$lWinNTHeightAdjustment  // adjusted to your window. This setting works on Windows NT 4.0.
		$iRight:=$iLeft+<>lSDA_PaletteWidth
		$iRight:=$iRight-$lWinNTWidthAdjustment
		$iLeft:=$iLeft-$lWinNTWidthAdjustment
		SET WINDOW RECT:C444($iLeft; $iTop; $iRight; $iBottom; <>lSDA_PaletteWinRef)
		<>SDA_PaletteSize:=<>SDA_MAXIMIZED_PALETTE  //"Maximized"
		
	Else   //you should know by now, I don't take chances.
		SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "SDA_PaletteMinMaxToggle"; <>SDA_PaletteSize)
End case 
