//%attributes = {}
//******************************************************************************
//Method: SDA_util_ConvertToString
//Written by  Tod Gentille on 9/25/1998
//
//Purpose: A general purpose core routine that determines if the variable
//pointed to by the parameter is a text or string value or is  compatible with the
//string function and returns the string equivalent. If not compat it returns ""
//
//$1 - pointer to var to test and convert
//$0 return converted string or ""
//
//Copyright 1998 Syncor Systems, Inc.
//
//NOTE: Does not support pointers to arrays
//******************************************************************************

C_POINTER:C301($1; $pVariableToConvert)
C_LONGINT:C283($lVarType)
C_TEXT:C284($0)
C_BOOLEAN:C305($bIsStringCompatible)

$pVariableToConvert:=$1
$lVarType:=Type:C295($pVariableToConvert->)

If (($lVarType=Is string var:K8:2) | ($lVarType=Is text:K8:3))
	$0:=$pVariableToConvert->
Else 
	
	$bIsStringCompatible:=True:C214  //init to true and trap all valid types
	Case of 
		: ($lVarType=Is integer:K8:5)  //aren't named constants nice?
		: ($lVarType=Is longint:K8:6)
		: ($lVarType=Is real:K8:4)
		: ($lVarType=Is date:K8:7)
		: ($lVarType=Is time:K8:8)
			
		Else   // not a supported type by the String function 
			$bIsStringCompatible:=False:C215
			$0:=""
	End case   //  Case of 
	//
	If ($bIsStringCompatible)
		$0:=String:C10($pVariableToConvert->)
	End if   //  If ($bIsStringCompatible)
	
End if   //If (($lSearchVarType=Is String Var) | (($lSearchVarType=Is Text))  
