//%attributes = {}
//******************************************************************************
//Method: SDA_util_GetOpenWindowNmRef
//Taken from: SDA_util_GetOpenWindowNames
//Written by  Cyril Harnisch on 2/3/99
//
//Purpose: Get a list of all the open method window names & reference numbers
// and put them in the passed arrays. 
//
//$1 - pointer to array to hold the list of window names 
//$2 - pointer to array to hold the list of window reference numbers 
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $2; $pWindowTitleAry; $pWindowRefAry)
C_LONGINT:C283($lSize; $lWinTitleAryIdx)
C_TEXT:C284($tWinTitle)

$pWindowTitleAry:=$1
$pWindowRefAry:=$2

//Get all the open window references, create an array of window names
WINDOW LIST:C442($pWindowRefAry->)

$lSize:=Size of array:C274($pWindowRefAry->)
ARRAY TEXT:C222($pWindowTitleAry->; $lSize)

For ($lWinTitleAryIdx; 1; $lSize)
	
	If (SDA_util_IsMethod($pWindowRefAry->{$lWinTitleAryIdx}))
		$tWinTitle:=Get window title:C450($pWindowRefAry->{$lWinTitleAryIdx})
		$pWindowTitleAry->{$lWinTitleAryIdx}:=$tWinTitle
		
	Else   //not a method window
		$pWindowTitleAry->{$lWinTitleAryIdx}:=""  //don't assign a name    
	End if 
	
End for 

//if there were any non method windows they will have no name entry
For ($lWinTitleAryIdx; $lSize; 1; -1)  //loop backwards
	
	If ($pWindowTitleAry->{$lWinTitleAryIdx}="")
		DELETE FROM ARRAY:C228($pWindowTitleAry->; $lWinTitleAryIdx; 1)
		DELETE FROM ARRAY:C228($pWindowRefAry->; $lWinTitleAryIdx; 1)
	End if 
	
End for 
