//%attributes = {}
//******************************************************************************
//Method: SDA_util_PostString
//Written by  Tod Gentille on 2/23/98
//
//Purpose: Bypass the normal method used by SDA to post keys because it is too 
//slow for 4D's type ahead feature. This should only be used when
//posting keys sequentially for type-ahead. There is no checking here
//or delays to make sure the design environment had time to process the keystrokes
//
//$1 - text the sequence of keys to post
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_TEXT:C284($1; $tTextToPost)
C_LONGINT:C283($i; $lTextLength)

$tTextToPost:=$1
$lTextLength:=Length:C16($tTextToPost)
//Since the type ahead only seems to work for a certain number of characters
//only post that number of characters. This limit is set in SDA_strt_Prefs
If ($lTextLength><>SDA_TYPE_AHEAD_MAX_LEN)
	$lTextLength:=<>SDA_TYPE_AHEAD_MAX_LEN
End if 

ARRAY LONGINT:C221($alAsciiVals; $lTextLength)

For ($i; 1; $lTextLength)
	$alAsciiVals{$i}:=Character code:C91($tTextToPost[[$i]])
End for 

For ($i; 1; $lTextLength)
	//SDA_PostKey is not fast enough    
	POST KEY:C465($alAsciiVals{$i}; 0; <>lSDA_DesignPID)
End for 
