//%attributes = {}
//_prli_AppendColumn(Area;->Array;Header;Width;Format;MiscPrms)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION: 
//This method allows you to configure many of the settings for a report
//   column, all in one call.
//This command is over and above any PrintList™ commands.

//--------------------------------------------------------------------------------
//PARAMETERS
//$1: Longint: AreaRef
//$2: Ptr: Pointer to the array/Field/variable
//$3: Text: Header Text
//$4: Longitn: Width.  (pass zero to auto-calculate)
//$5: Format (for numbers/date/boolean)
//$6-N: Text: Miscellaneouls column parameters:
//   ColJust;{ColJustNum}
//   ColFont;{FontName}
//   ColFontSize;{FontSize}
//   ColFontStyle;{StyleNum}

//   HdrJust;{HdrJustNum}
//   HdrFont;{FontName}
//   HdrFontSize;{FontSize}
//   HdrFontStyle;{StyleNum}

//   BrkText;{LevelNum};{Text}
//   BrkOverflowCols;{LevelNum};
//   BrkJust;{LevelNum};{ColJustNum}
//   BrkFont;{LevelNum};{FontName}
//   BrkFontSize;{LevelNum};{FontSize}
//   BrkFontStyle;{LevelNum};{StyleNum}

//   BkHText;{LevelNum};
//   BkHOverflowCols;{LevelNum};
//   BkHJust;{LevelNum};{ColJustNum}
//   BkHFont;{LevelNum};{FontName}
//   BkHFontSize;{LevelNum};{FontSize}
//   BkHFontStyle;{LevelNum};{StyleNum}


//--------------------------------------------------------------------------------
//REVISION HISTORY
//02/02/2008: Bug Fix in MiscPrms
//07/30/2007: Change prms $6-$n to misc text prms
//--------------------------------------------------------------------------------

C_LONGINT:C283($1; $_prli_iAreaRef; $_prli_iFindArea)
C_POINTER:C301($2)
C_TEXT:C284($3)
C_LONGINT:C283($4)
C_TEXT:C284($5)
C_TEXT:C284(${6}; $_prli_Prm)

$_prli_iAreaRef:=$1

$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; "_prli_AppendColumn")
If ($_prli_iFindArea>-1)
	
	$_prli_iCol:=Size of array:C274(_prli_aArray{$_prli_iFindArea})+1
	
	_prli_SetArraysPtr($_prli_iAreaRef; $_prli_iCol; 1; $2)
	If (Count parameters:C259>2)
		_prli_SetHeaders($_prli_iAreaRef; $_prli_iCol; 1; $3)
	End if 
	If (Count parameters:C259>3)
		_prli_SetWidths($_prli_iAreaRef; $_prli_iCol; 1; $4)
	End if 
	
	If (Count parameters:C259>4)
		//See Also: _prli_SetFormat
		_prli_aFormat{$_prli_iFindArea}{$_prli_iCol}:=_str_ FormatChange($5)  // PM 2011-03-01
	End if 
	
	
	C_LONGINT:C283($_prli_i; $_prli_iPos; $_prli_iFindlevCol)
	For ($_prli_i; 6; Count parameters:C259)
		_prli_Util_SetColMiscPrm($_prli_iFindArea; $_prli_iCol; ${$_prli_i})
	End for 
	
End if 
