//%attributes = {}
//_prli_Util_SizeArray(Size;->Array1;{->ArrayN})

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION
//Set the listed arrays to Size.
//Do NOT clear out existing elements

//Rev: 11/19/02: Bug Fix from 11/14/02
//Rev: 11/14/02: Cleanup & Improvement
//Rev: 08/29/01: Check for Array types
//Rev: 02/24/00: Slight speed increase

C_LONGINT:C283($1; $_prli_iSetSizeTo; $_prli_iPrmCtr; $_prli_iTableNum; $_prli_iFieldNum; $_prli_iOldSize; $_prli_iType; $_prli_iAddElements)
C_POINTER:C301(${2}; $_prli_Ptr)
C_TEXT:C284($_prli_VarName)

$_prli_iSetSizeTo:=$1

If ($_prli_iSetSizeTo<0)
	_prli_Util_ErrorAlert("Parameter 1 = "+String:C10($_prli_iSetSizeTo); Current method name:C684)
	$_prli_iSetSizeTo:=0
End if 

For ($_prli_iPrmCtr; 2; Count parameters:C259)
	$_prli_Ptr:=${$_prli_iPrmCtr}
	$_prli_iType:=Type:C295($_prli_Ptr->)
	Case of 
		: ($_prli_iType=Is undefined:K8:13)  //If array has never been defined (yes, this happens in comp environ also.)
			If ($_prli_iSetSizeTo>0)
				RESOLVE POINTER:C394($_prli_Ptr; $_prli_VarName; $_prli_iTableNum; $_prli_iFieldNum)
				If ($_prli_iTableNum>-1)
					$_prli_VarName:=$_prli_VarName+"{"+String:C10($_prli_iTableNum)+"}"
				End if 
				_prli_Util_ErrorAlert("The Array '"+$_prli_VarName+"' has not been defined (Parameter #"+String:C10($_prli_iPrmCtr)+")"; Current method name:C684)
			End if 
			
			
			//List every existing array type here
		: (($_prli_iType=Array 2D:K8:24) | ($_prli_iType=Boolean array:K8:21) | ($_prli_iType=Date array:K8:20) | ($_prli_iType=Integer array:K8:18) | ($_prli_iType=LongInt array:K8:19) | ($_prli_iType=Picture array:K8:22) | ($_prli_iType=Pointer array:K8:23) | ($_prli_iType=Real array:K8:17) | ($_prli_iType=String array:K8:15) | ($_prli_iType=Text array:K8:16))
			$_prli_iOldSize:=Size of array:C274($_prli_Ptr->)
			$_prli_iAddElements:=$_prli_iSetSizeTo-$_prli_iOldSize
			Case of 
				: ($_prli_iAddElements<0)
					DELETE FROM ARRAY:C228($_prli_Ptr->; $_prli_iOldSize+1+$_prli_iAddElements; -$_prli_iAddElements)
				: ($_prli_iAddElements>0)
					INSERT IN ARRAY:C227($_prli_Ptr->; $_prli_iOldSize+1; $_prli_iAddElements)
			End case 
			
			
			
		Else 
			
			RESOLVE POINTER:C394($_prli_Ptr; $_prli_VarName; $_prli_iTableNum; $_prli_iFieldNum)
			If ($_prli_iTableNum>-1)
				$_prli_VarName:=$_prli_VarName+"{"+String:C10($_prli_iTableNum)+"}"
			End if 
			_prli_Util_ErrorAlert("Tried to size "+$_prli_VarName+" as an array."; Current method name:C684)
			
	End case 
End for 
