//%attributes = {}
// Method: cal_PlaceEvents
// 2005.10.31-14:13:38 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: 
// Places the to_do events in the day boxes
// 
// Original method by Dave Batton, DataCraft

COMPILER_do

C_DATE:C307(cal_dLastDateToDisplay)
C_TEXT:C284($cal_tSelectedRecordUUID)
C_LONGINT:C283($cal_lElement; $cal_lBoxNumber)
C_POINTER:C301($cal_pVarPtr)

cal_pDragBannerPtr:=cal_pNilPtr  // Since a redraw will make this pointer invalid.
cal_tError:=""

// If an event is currently selected, get the record ID here so we can restore 
// the highlight after we've moved everything around.
If (Is nil pointer:C315(cal_pSelectedObjectPtr))
	$cal_tSelectedRecordUUID:=""
Else 
	cal_lEventIndex:=cal_AssociatedEventIndexGet(cal_pSelectedObjectPtr)
	$cal_tSelectedRecordUUID:=do_atRecord_ID{cal_lEventIndex}  //[To_Do]Record_ID
	cal_OBJECT_DESELECT(cal_pSelectedObjectPtr)
End if 

OBJECT MOVE:C664(*; "Text@"; 5000; 5000; 5005; 5005; *)  // Move the text boxes offscreen until they're needed.
OBJECT MOVE:C664(*; "Banner@"; 5000; 5000; 5005; 5005; *)  // Move the banners offscreen until they're needed.
OBJECT MOVE:C664(*; "DragBttn@"; 5000; 5000; 5005; 5005; *)  // Move the drag buttons offscreen until they're needed.
OBJECT MOVE:C664(*; "Pict@"; 5000; 5000; 5005; 5005; *)  // Move the picture variables offscreen until they're needed.

// Clear the array we use to track what boxes already have banners in them.
For ($cal_lBoxNumber; 1; Size of array:C274(cal_alBoxBannerLevel))
	cal_alBoxBannerLevel{$cal_lBoxNumber}:=0
End for 

// We're going to create two matching (in the number of elements) arrays that will
// allow us to keep track of which [to_do] record each variable object has
// been associated with.  Keep in mind that one Banner event may require 
// multiple variable objects, because it may span multiple rows.  So at this 
// point we don't know how many array elements we're going to need.
ARRAY LONGINT:C221(cal_alEventIndex; 0)
ARRAY TEXT:C222(cal_atVariableName; 0)

// Now figure out the range of dates visible on the calendar.
If (cal_lLastBox<=35)  // We may be displaying only 5 rows.
	cal_dLastDateToDisplay:=cal_dFirstBoxDate+35
Else 
	cal_dLastDateToDisplay:=cal_dFirstBoxDate+42
End if 

// Get the to_do events into arrays
// Do not make a new query when resizing or dragging
If ((Form event code:C388#On Resize:K2:27) & (Form event code:C388#On Timer:K2:25))
	cal_EVENTS_TO_ARR
End if 

C_LONGINT:C283($cal_lIndex; $cal_lCount)

cal_dLastDatePlaced:=!00-00-00!  // Used by cal_PlaceTextObject.
cal_lNextTextTop:=15  // Used by cal_PlaceTextObject.

cal_lTextObjectCount:=0
cal_lBannerObjectCount:=0
cal_lPictureObjectCount:=0

cal_lEventCount:=Size of array:C274(do_atRecord_ID)
For (cal_lEventIndex; 1; cal_lEventCount)
	If (do_adEnd_Date{cal_lEventIndex}=!00-00-00!)
		If (cal_lTextObjectCount>=cal_lMaxTextObjects)
			cal_tError:=_lang Current("There are more events this month than can be displayed on this calendar")+ksPeriod
		Else 
			cal_lTextObjectCount:=cal_lTextObjectCount+1
			cal_TEXT_PLACE(cal_lTextObjectCount)
		End if 
	Else 
		If (cal_lBannerObjectCount>=cal_lMaxBannerObjects)
			cal_tError:=_lang Current("There are more banner events this month than can be displayed on this calendar")+ksPeriod
		Else 
			cal_lBannerObjectCount:=cal_lBannerObjectCount+1
			cal_BANNER_PLACE  // (cal_lBannerObjectCount) ` use directly cal_lBannerObjectCount
		End if 
	End if 
	If (do_asPicture_Name{cal_lEventIndex}#"")
		If (cal_lPictureObjectCount>=cal_lPictureObjectCount)
			cal_tError:=_lang Current("There are more picture events this month than can be displayed on this calendar")+ksPeriod
		Else 
			cal_lPictureObjectCount:=cal_lPictureObjectCount+1
			cal_PICTURE_PLACE(cal_lPictureObjectCount)
		End if 
	End if 
End for 

// If an event was selected (highlighted) then reselect it.
If ($cal_tSelectedRecordUUID#"")
	// first find out if the uuid of the selected record is still in the selection
	$cal_lElement:=Find in array:C230(do_atRecord_ID; $cal_tSelectedRecordUUID)
	// then find the variable name associated with it
	$cal_lElement:=Find in array:C230(cal_alEventIndex; $cal_lElement)
	If ($cal_lElement>0)
		$cal_pVarPtr:=Get pointer:C304(cal_atVariableName{$cal_lElement})  // Since we stored the var names without "<>", we add it back.
		cal_OBJECT_SELECT($cal_pVarPtr)
	End if 
End if 

SET CURSOR:C469(kCursorNormal)  //v11, restore after _sel SEL_TO_ARR