//%attributes = {}
// Project Method: Calendar_SetObjectColor (->form object; {highlighted?})

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// This method will set the foreground and background colors of the specified 
//   object.  The color will be determined by the value of [Calendar]Event Color
//   and the type of event (banners are colored differently than text events)
//   unless the optional type and color parameters are passed.
//   The background color also depends on whether the text item is in the current 
//   month or an adjacent month.
// Assumes a [Calendar] record is loaded.

// The numbers for the colors here were determined using the Color Tool example 
//   database, designed by Tad Wheeler.


C_POINTER:C301($1; $cal_objectPtr)
C_BOOLEAN:C305($2; $cal_highlighted)
C_LONGINT:C283($cal_foregroundColor; $cal_backgroundColor; $cal_eventColor)
C_TEXT:C284($cal_eventType)

$cal_objectPtr:=$1
If (Count parameters:C259>1)
	$cal_highlighted:=$2  // Draw the object as highlighted?
Else 
	$cal_highlighted:=False:C215
End if 

$cal_eventType:=do_asType_{cal_lEventIndex}
$cal_eventColor:=do_alColor{cal_lEventIndex}
If ($cal_eventColor=0)
	$cal_eventColor:=1  //black = Default foreground color
End if 

// A default, in case we don't set these otherwise in the code below.
$cal_foregroundColor:=Foreground color:K23:1

If (do_adEnd_Date{cal_lEventIndex}#!00-00-00!)  //$cal_eventType="Banner")
	If ($cal_highlighted)  // We use this color on Banners.
		Case of 
			: ($cal_eventColor=1)  // White
				$cal_backgroundColor:=0x00DDDDDD
			: ($cal_eventColor=2)  // Light Gray
				$cal_backgroundColor:=0x00AAAAAA
			: ($cal_eventColor=3)  // Pink
				$cal_backgroundColor:=0x00FF8080
			: ($cal_eventColor=4)  // Light Blue
				$cal_backgroundColor:=0x00A8A8FF
			: ($cal_eventColor=5)  // Light Green
				$cal_backgroundColor:=0x0080FF85
			: ($cal_eventColor=6)  // Light Purple
				$cal_backgroundColor:=0x00FF70FF
			: ($cal_eventColor=7)  // Light Orange
				$cal_backgroundColor:=0x00FFBE7F
			: ($cal_eventColor=8)  // Light Blue
				$cal_backgroundColor:=0x005FFEFF
			Else 
				$cal_backgroundColor:=0x00FFFFFF  // White.
		End case 
		
		If (Form event code:C388=On Timer:K2:25)  //during drag
			Case of 
				: ((cal_lDragPosition=kStart) & ($cal_objectPtr=(->cal_lDragSelectL)))
					$cal_backgroundColor:=$cal_backgroundColor-0x00444444  //darken the color
				: ((cal_lDragPosition=kStop) & ($cal_objectPtr=(->cal_lDragSelectR)))
					$cal_backgroundColor:=$cal_backgroundColor-0x00444444  //darken the color
				Else 
					//all ok          
			End case 
		End if 
		
	Else   // ($highlighted)
		Case of 
			: ($cal_eventColor=1)  // White
				$cal_backgroundColor:=0x00FFFFFF
			: ($cal_eventColor=2)  // Light Gray
				$cal_backgroundColor:=0x00CCCCCC
			: ($cal_eventColor=3)  // Pink
				$cal_backgroundColor:=0x00FFA0A0
			: ($cal_eventColor=4)  // Light Blue
				$cal_backgroundColor:=0x00C0CAFF
			: ($cal_eventColor=5)  // Light Green
				$cal_backgroundColor:=0x00C0FFC5
			: ($cal_eventColor=6)  // Light Purple
				$cal_backgroundColor:=0x00FFA0FF
			: ($cal_eventColor=7)  // Light Orange
				$cal_backgroundColor:=0x00FFCFA0
			: ($cal_eventColor=8)  // Light Blue
				$cal_backgroundColor:=0x00A0FFFF
			Else 
				$cal_backgroundColor:=0x00FFFFFF  // White.
		End case 
	End if   // ($highlighted)
	
Else   // It's a text event.
	
	//@   Cal_PlaceBoxes same colors used
	Case of 
		: (Count parameters:C259>2)  // No record is available, so just pick a color.
			$cal_backgroundColor:=cal_lBoxColorLight
		: (do_adDate_{cal_lEventIndex}=cal_dCurrentDate)  // The date is in the selected month.
			$cal_backgroundColor:=cal_lBoxColorToday
		: (Month of:C24(do_adDate_{cal_lEventIndex})=cal_atMonths)  // The date is in the selected month.
			$cal_backgroundColor:=cal_lBoxColorLight
		Else 
			$cal_backgroundColor:=cal_lBoxColorDarkBackground
	End case 
	
	Case of 
		: ($cal_eventColor=1)  // Black
			$cal_foregroundColor:=Foreground color:K23:1  //0x00111111  `dark gray `
		: ($cal_eventColor=2)  // Gray
			$cal_foregroundColor:=0x00555555
		: ($cal_eventColor=3)  // Red
			$cal_foregroundColor:=0x00FF0000
		: ($cal_eventColor=4)  // Blue
			$cal_foregroundColor:=0x00FF
		: ($cal_eventColor=5)  // Green
			$cal_foregroundColor:=0xBB00
		: ($cal_eventColor=6)  // Purple
			$cal_foregroundColor:=0x00EC00EB
		: ($cal_eventColor=7)  // Orange
			$cal_foregroundColor:=0x00FF6600
		: ($cal_eventColor=8)  // Dark Green
			$cal_foregroundColor:=0x7409
	End case 
End if 

OBJECT SET RGB COLORS:C628($cal_objectPtr->; $cal_foregroundColor; $cal_backgroundColor)
