//%attributes = {}
// Method: wpa_AutomaticWpaCreate 
// 08.02.12, 19:11:14 / MG_AK
// © Copyright Manage Applications
// Purpose: 
// called from: wpa_ AUTOMATIC_WPA_CREATE, wpa_ UNMANNED_WPA_CREATE, (not wpa_ UNPRODUCTIVE_WPA_CREATE)
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($0)  // created wpa_kRecord_ID
C_LONGINT:C283($1; $wpa_lAction; $8; $wpa_lPhase; $9; $wpa_lShift; $wpa_lIndex; $wpa_lCount; $wpa_lCountWo; $wpa_lCountWos; $wpa_lCountWpa; $wpa_lFarInThePast)
C_LONGINT:C283($wpa_lErrorPhaseNumber; $wpa_lUnknownPhaseNumber; $wpa_lCry; $wpa_lStartType; $wpa_lOK)
C_TEXT:C284($2; $wpa_tOpearation; $wpa_tUnknownWork; $wpa_tUnknownWorkProdLot; $wpa_tLoadGroupOld)
C_REAL:C285($3; $wpa_rAmount; $5; $wpa_rDateTime; $11; $wpa_rAutomaticReceiptDelay; $wpa_rStart; $wpa_rEnd; $wpa_rSetupHours; $wpa_rSecondsBefore; $wpa_rRealTimeSeconds; $wpa_rSecondsInThePast)
C_TEXT:C284($4; $wpa_tProductionLot; $wpa_tProductionLotPhase)
C_TEXT:C284($6; $wpa_tLoadGroup)
C_TEXT:C284($7; $wpa_tEmployee)
C_TEXT:C284($10; $wpa_tJsonInfo; $wpa_tJsonInfoFld)

C_TEXT:C284($wpa_tWork; $wpa_tDescription; $wpa_tInfo; $wpa_tErrInfo; $wpa_tErrMessage; $wpa_tPlateProgram; $wpa_tPlateProgram2; $wpa_tSmeltingNum; $wpa_tRecId; $wpa_tStartType; $wpa_tSubtype)
C_TEXT:C284($wpa_tStockParcelCode; $wpa_tWorkProdLotState; $wpa_tWosState)
C_REAL:C285($wpa_rHours; $wpa_rMachineHours; $wpa_rSetupHours; $wpa_rQuantityFinished; $wpa_rQuantityFailed)
C_DATE:C307($wpa_dDate; $wpa_dStartDate)
C_TIME:C306($wpa_hTime; $wpa_hStartTime)

$wpa_lAction:=$1
$wpa_tOpearation:=$2  // only to info
$wpa_rAmount:=$3
$wpa_tProductionLot:=$4
$wpa_rDateTime:=$5
$wpa_tLoadGroup:=$6
$wpa_tEmployee:=$7
$wpa_lPhase:=$8
$wpa_lShift:=$9
$wpa_tJsonInfo:=$10
$wpa_rAutomaticReceiptDelay:=$11
$wpa_dDate:=_dt RealToDate($wpa_rDateTime)
$wpa_hTime:=_dt RealToTime($wpa_rDateTime)
$wpa_tInfo:=""
$wpa_tErrMessage:=""
$wpa_tSmeltingNum:=""
$wpa_tStockParcelCode:=""

$wpa_lErrorPhaseNumber:=999
$wpa_lUnknownPhaseNumber:=99
_prf_ JSON(<>wpa_tAutomaticPrfName; "ErrorPhaseNumber"; ->$wpa_lErrorPhaseNumber)  // for plain LOAD/UNLOAD and errors
_prf_ JSON(<>wpa_tAutomaticPrfName; "UnknownPhaseNumber"; ->$wpa_lUnknownPhaseNumber)  // phase oe alternative machine phase not found
_prf_ JSON(<>wpa_tAutomaticPrfName; "UnknownWork"; ->$wpa_tUnknownWork)  // for plain LOAD/UNLOAD
$wpa_rRealTimeSeconds:=900  // =15 min
_prf_ JSON(<>wpa_tAutomaticPrfName; "RealTimeSeconds"; ->$wpa_rRealTimeSeconds)
$wpa_rDateTimeCurrent:=_dt CurrentToReal(kTrue)
$wpa_rSecondsInThePast:=_dt Difference($wpa_rDateTimeCurrent; $wpa_rDateTime)*3600
$wpa_lFarInThePast:=kFalse
If ($wpa_rSecondsInThePast>$wpa_rRealTimeSeconds) & ($wpa_rSecondsInThePast>0)
	$wpa_lFarInThePast:=kTrue  // check state only if event is not far in the past
End if 

$wpa_tUnknownWorkProdLot:=wo_ LastOpenWorkOrderGet($wpa_tUnknownWork)  // from work -> prod. lot 

$wpa_tErrInfo:=$wpa_tLoadGroup+" - "+$wpa_tProductionLot+" - "+_date ToString($wpa_dDate)+ksSpace+_time ToString($wpa_hTime)+" - "
Case of 
	: ($wpa_lAction=1)
		$wpa_tPlateProgram:="LOAD;"+$wpa_tOpearation+";"+String:C10($wpa_rAmount)+";"+$wpa_tProductionLot
	: ($wpa_lAction=2)
		$wpa_tPlateProgram:="LOAD"
		$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot
		$wpa_tWork:=wo_ ProductionLotToWorkPosNum($wpa_tProductionLot)
		$wpa_lPhase:=$wpa_lErrorPhaseNumber
		$wpa_tInfo:=_lang Current("Production lot number was not included for actual work phase event")+": "+$wpa_tErrInfo+$wpa_tOpearation+";"+String:C10($wpa_rAmount)+";"+$wpa_tProductionLot
	: ($wpa_lAction=3)
		$wpa_tPlateProgram:="UNLOAD;"+$wpa_tOpearation+";"+String:C10($wpa_rAmount)+";"+$wpa_tProductionLot
	: ($wpa_lAction=4)
		$wpa_tPlateProgram:="UNLOAD"
		$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot
		$wpa_tWork:=wo_ ProductionLotToWorkPosNum($wpa_tProductionLot)
		$wpa_lPhase:=$wpa_lErrorPhaseNumber
		$wpa_tInfo:=_lang Current("Production lot number was not included for actual work phase event")+": "+$wpa_tErrInfo+$wpa_tOpearation+";"+String:C10($wpa_rAmount)+";"+$wpa_tProductionLot
	: ($wpa_lAction=5)
		//  correct record is in selection in end event create
	Else 
		TRACE:C157
		$wpa_tPlateProgram:=""
End case 

$wpa_tErrInfo:=$wpa_tLoadGroup+" - "+$wpa_tProductionLot+" - "+_date ToString($wpa_dDate)+ksSpace+_time ToString($wpa_hTime)+" - "+$wpa_tPlateProgram
If (($wpa_lAction#4) & ($wpa_lAction#2))
	
	$wpa_tWorkProdLotState:="err"
	// find if work exists
	$wpa_tWork:=wo_ ProductionLotToWorkPosNum($wpa_tProductionLot)
	$wpa_lCount:=_qry Fld(0; w_kWork__Position_Num_ID; "="; ->$wpa_tWork; ""; kFalse; kTrue)
	Case of 
		: ($wpa_lCount<1)
			$wpa_tInfo:=_lang Current("Work was not found for actual work phase event")+": "+$wpa_tErrInfo
			_cron_ MESSAGE(kError; $wpa_tInfo+ksTab+_date CurrentDateTimeToString)
			$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot  // must be after err messages
			$wpa_lPhase:=$wpa_lErrorPhaseNumber
		: ($wpa_lCount>1)
			$wpa_tInfo:=_lang Current("More than one work was found for actual work phase event")+": "+$wpa_tErrInfo
			_cron_ MESSAGE(kError; $wpa_tInfo+ksTab+_date CurrentDateTimeToString)
			$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot  // must be after err messages
			$wpa_lPhase:=$wpa_lErrorPhaseNumber
		Else 
			// 1 work found, ok
			// find if work order exists
			$wpa_lCount:=_qry Fld(0; wo_kProduction_Lot; "="; ->$wpa_tProductionLot; ""; kFalse; kTrue)
			Case of 
				: ($wpa_lCount<1)
					$wpa_tInfo:=_lang Current("Work order was not found for actual work phase event")+": "+$wpa_tErrInfo
					_cron_ MESSAGE(kError; $wpa_tInfo+ksTab+_date CurrentDateTimeToString)
					$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot  // must be after err messages
					$wpa_lPhase:=$wpa_lErrorPhaseNumber
				: ($wpa_lCount>1)
					$wpa_tInfo:=_lang Current("More than one work order was found for actual work phase event")+": "+$wpa_tErrInfo
					_cron_ MESSAGE(kError; $wpa_tInfo+ksTab+_date CurrentDateTimeToString)
					$wpa_tProductionLot:=$wpa_tUnknownWorkProdLot  // must be after err messages
					$wpa_lPhase:=$wpa_lErrorPhaseNumber
				Else 
					If ($wpa_tProductionLot#$wpa_tUnknownWorkProdLot)
						
						If ($wpa_lFarInThePast=kFalse)  // check state only if event event is not far in the past
							$wpa_tWorkProdLotState:=_fld ValueStr(wo_kState)
							If ($wpa_tWorkProdLotState=ld_kStateFinished)
								$wpa_tInfo:=_lang Current("Work order is finished for actual work phase event")+": "+$wpa_tErrInfo
								_cron_ MESSAGE(kError; $wpa_tInfo+ksTab+_date CurrentDateTimeToString)
								$wpa_lPhase:=$wpa_lUnknownPhaseNumber  // 99 ***AK
							End if 
						End if 
						
					End if 
					// 1 work order found, ok
			End case 
	End case 
	$wpa_tWork:=wo_ ProductionLotToWorkPosNum($wpa_tProductionLot)
	
	$wpa_tDescription:=""
	If ($wpa_lPhase=-1)
		$wpa_tErrMessage:=""
		$wpa_lPhase:=wpa_AutomaticFirstOpenPhaseGet($wpa_tProductionLot; $wpa_tLoadGroup; $wpa_lUnknownPhaseNumber; $wpa_lFarInThePast; ->$wpa_tDescription; ->$wpa_tErrMessage)
		If ($wpa_tErrMessage#"")
			$wpa_tErrMessage:=$wpa_tErrMessage+" - "+$wpa_tOpearation
			//$wpa_tErrMessage:=$wpa_tErrMessage+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroup // $wpa_tProductionLot and $wpa_tLoadGroup are aleady in wpa_
			$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
			_cron_ MESSAGE(kError; $wpa_tErrMessage+ksTab+_date CurrentDateTimeToString)
		End if 
	End if 
	
End if 

$wpa_tProductionLotPhase:=wos_ ProductionLot__PhaseSet($wpa_tProductionLot; $wpa_lPhase)

_trans_ START
_sel_ QUERY_LOCK_SET(kTrue)
$wpa_lCount:=_qry Fld(0; wo_kProduction_Lot; "="; ->$wpa_tProductionLot; ""; kFalse; kTrue)
If (OK=1)
	$wpa_lCount:=_qry Fld(0; wos_kProduction_Lot; "="; ->$wpa_tProductionLot; ""; kFalse; kTrue)
End if 
If (OK=0)
	$wpa_lCount:=-1
End if 
_sel_ QUERY_LOCK_SET(kFalse)
_trans_ CANCEL

//$wpa_tDescription:=$wpa_tInfo  // change Description or get from wpe_?

$wpa_tErrInfo:=$wpa_tLoadGroup+" - "+$wpa_tProductionLot+" - "+_date ToString($wpa_dDate)+ksSpace+_time ToString($wpa_hTime)+" - "+$wpa_tPlateProgram
Case of 
	: ($wpa_lCount<0)
		$wpa_tErrMessage:=_lang Current("Locked records prevented automatic create for event")+": "+$wpa_tErrInfo
		$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
		_cron_ MESSAGE(kError; $wpa_tErrMessage)
		
		
		
		
	: (($wpa_lAction=1) | ($wpa_lAction=2))  // create fms start event
		$wpa_tStartType:=ld_kTypeStarted  // korjaa aga -1 -> aloitus? 
		$wpa_tSubtype:=ld_kSubtypeStarted
		// $wpa_tInfo ????
		//$wpa_lCountWos:=wpa_ StartEventGet ($wpa_tStartType;$wpa_tWork;$wpa_tProductionLot;$wpa_lPhase;$wpa_tEmployee;$wpa_tPlateProgram;$wpa_tStockParcelCode;$wpa_tLoadGroup)  //time cart phase num set negative
		If (wpa_rPrevDateTime#$wpa_rDateTime)
			$wpa_lCountWos:=wpa_ StartEventGet($wpa_tStartType; ""; "@"; 0; $wpa_tEmployee; ""; ""; $wpa_tLoadGroup)  //time cart phase num set negative
		Else 
			$wpa_lCountWos:=0  // we must allow many production lot LOAD -creates in one machine data row
		End if 
		If ($wpa_lCountWos>0)
			
			C_TEXT:C284($wpa_tProductionLot2; $wpa_tPlateProgram2; $wpa_tOpearation2)
			C_LONGINT:C283($wpa_lPhase2; $wpa_lShift2)
			C_REAL:C285($wpa_rAmount2; $wpa_rDateTime2; $wpa_rDateTimeWpa)
			C_DATE:C307($wpa_dDateWpa)
			C_TIME:C306($wpa_hTimeWpa)
			
			//$wpa_lAction:=$1
			//$wpa_tOpearation:=$2  // only to info
			//$wpa_rAmount:=$3
			//$wpa_tProductionLot:=$4
			//$wpa_rDateTime:=$5
			//$wpa_tLoadGroup:=$6
			//$wpa_tEmployee:=$7
			//$wpa_lPhase:=$8
			//$wpa_lShift:=$9
			//$wpa_tJsonInfo:=$10
			//$wpa_rAutomaticReceiptDelay:=$11
			$wpa_rSecondsBefore:=60  // default is create1 minute = 60 seconds before
			_prf_ JSON(<>wpa_tAutomaticPrfName; "ErrorCreateEndEventSecondsBefore"; ->$wpa_rSecondsBefore)  // for plain LOAD/UNLOAD and errors
			
			If ($wpa_rSecondsBefore<0)
				$wpa_tErrMessage:=_lang Current("Same event already exists, automatic create failed for start event")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			Else 
				$wpa_rDateTime:=_dt ToReal($wpa_dDate; $wpa_hTime)
				
				ARRAY TEXT:C222($wpa_atRecId; 0)
				_sel_ SEL_TO_ARR_ONE(wpa_kRecord_ID; ->$wpa_atRecId)
				Repeat 
					_time WAIT(0.01)  // slow down too tight loop
					_qry Fld(0; wpa_kRecord_ID; "="; ->$wpa_atRecId{$wpa_lCountWos}; ""; kFalse; kFalse)
					
					$wpa_tPlateProgram2:=_fld ValueStr(wpa_kProgram_id)  // for ex: LOAD;10;1;05644/102
					$wpa_dDateWpa:=_fld ValueDate(wpa_kStart_Date)
					$wpa_hTimeWpa:=_fld ValueTime(wpa_kStart_Time)
					$wpa_rDateTimeWpa:=_dt ToReal($wpa_dDateWpa; $wpa_hTimeWpa)
					If ($wpa_rDateTimeWpa>$wpa_rDateTime)
						
						$wpa_tErrInfo:=$wpa_tErrInfo+" -- "+$wpa_tPlateProgram2+" - "+_dt RealToDateTimeString($wpa_rDateTimeWpa)
						$wpa_tErrMessage:=_lang Current("Load event already exists in the future")+": "+$wpa_tErrInfo
						$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
						_cron_ MESSAGE(kError; $wpa_tErrMessage)
						
					Else 
						$wpa_rDateTime2:=$wpa_rDateTime-_dt SecondsToReal($wpa_rSecondsBefore)  // end one minute less before next load
						If ($wpa_rDateTime2<$wpa_rDateTimeWpa)
							$wpa_rDateTime2:=$wpa_rDateTimeWpa
						End if 
						// recursive calls here
						$wpa_tProductionLot2:=_fld ValueStr(wpa_kProduction_Lot)
						//$wpa_tLoadGroup:=$6
						//$wpa_tEmployee:=$7
						$wpa_lPhase2:=_fld ValueLong(wpa_kWork_Phase_Est_id)
						$wpa_lShift2:=_fld ValueLong(wpa_kShift_Number)
						//$wpa_tJsonInfo:=_fld ValueStr (wpa_kAdditional_Data)// wpa_kAdditional_Data
						//$wpa_tJsonInfo:=Replace string($wpa_tJsonInfo;"LOAD";"UNLOAD")
						$wpa_tOpearation2:=_str Parse($wpa_tPlateProgram2; ";"; 2)
						$wpa_rAmount2:=Num:C11(_str Parse($wpa_tPlateProgram2; ";"; 3))  // read from $wpa_tJsonInfo 
						//$wpa_rAutomaticReceiptDelay:=$11
						//$wpa_tRecID:=wpa_AutomaticWpaCreate (3;$2;$3;$4;$wpa_rDateTime;$6;$7;$8;$9;$wpa_tJsonInfo;$11)  // create unload end event
						$wpa_tErrInfo:=$wpa_tErrInfo+" -- "+$wpa_tPlateProgram2
						$wpa_tRecID:=wpa_AutomaticWpaCreate(3; $wpa_tOpearation2; $wpa_rAmount2; $wpa_tProductionLot2; $wpa_rDateTime2; $wpa_tLoadGroup; $wpa_tEmployee; $wpa_lPhase2; $wpa_lShift2; $wpa_tPlateProgram2; $wpa_rAutomaticReceiptDelay)  // create unload end event
						
						$wpa_tErrMessage:=_lang Current("Load event already exists, creating extra unload event")+": "+$wpa_tErrInfo
						$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
						_cron_ MESSAGE(kError; $wpa_tErrMessage)
						
					End if 
					$wpa_lCountWos:=$wpa_lCountWos-1
				Until ($wpa_lCountWos<1)
				
			End if 
			
		End if 
		
		wpa_rPrevDateTime:=$wpa_rDateTime
		$wpa_tRecID:=wpa_ StartEventCreate($wpa_tStartType; $wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tLoadGroup; $wpa_tEmployee; $wpa_tDescription; $wpa_lShift; $wpa_dDate; $wpa_hTime; $wpa_tStockParcelCode; $wpa_tSubtype; ""; "")
		
		$wpa_lCountWo:=0
		$wpa_lCountWos:=0
		
		If ($wpa_tRecId="")
			$wpa_tErrMessage:=_lang Current("Automatic create failed for start event")+": "+$wpa_tErrInfo
			$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
			_cron_ MESSAGE(kError; $wpa_tErrMessage)
		Else 
			
			$wpa_lCountWpa:=_qry Fld(0; wpa_kRecord_ID; "="; ->$wpa_tRecId; ""; kFalse; kTrue)
			If ($wpa_lCountWpa#1)
				$wpa_tErrMessage:=_lang Current("Actual work phase was not found after start event")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			Else 
				
				Case of   // update wo_ and wos_
					: ($wpa_tWorkProdLotState="err")
						IDLE:C311  // no prod lot
					: (($wpa_lPhase=$wpa_lUnknownPhaseNumber) | ($wpa_lPhase=$wpa_lErrorPhaseNumber))
						IDLE:C311  // do not update prod lot or wos_
					Else 
						// update  wos_ subtype 
						$wpa_lCountWo:=_qry Fld(0; wo_kProduction_Lot; "="; ->$wpa_tProductionLot; ""; kFalse; kTrue)
						If ($wpa_lCountWo#1)
							$wpa_tErrMessage:=_lang Current("Production lot was not found after start event")+": "+$wpa_tErrInfo
							$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
							_cron_ MESSAGE(kError; $wpa_tErrMessage)
						Else 
							
							// get old wos_ state
							$wpa_lCountWos:=_qry Fld(0; wos_kProduction_Lot__work_ph; "="; ->$wpa_tProductionLotPhase; ""; kFalse; kTrue)
							Case of 
								: ($wpa_lCountWos<1)
									$wpa_tErrMessage:=_lang Current("Work order schedule was not found after start event")+": "+$wpa_tErrInfo
									$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
									_cron_ MESSAGE(kError; $wpa_tErrMessage)
								: ($wpa_tWorkProdLotState="err")
									IDLE:C311  // no prod lot
								: (($wpa_lPhase=$wpa_lUnknownPhaseNumber) | ($wpa_lPhase=$wpa_lErrorPhaseNumber))
									IDLE:C311  // do not update prod lot or wos_
								Else 
									$wpa_tWosState:=_fld ValueStr(wos_kWork_Phase_State)  // save state before wo_ STATE_STARTED_SET
									If (($wpa_tWosState=ld_kStateNotLoaded) | ($wpa_tWosState=ld_kStateLoaded) | ($wpa_tWosState=ld_kStateStarted))
										// $wpa_tWosState = prev wos state before wo_ STATE_STARTED_SET
										_tbl WRITE_STATE(wos_kTbl; kTrue)
										_rec LOCKED_WAIT(wos_kTbl; kTrue)
										If (OK=1)
											Case of 
												: ($wpa_tWosState=ld_kStateNotLoaded)
													$wpa_tSubtype:=ld_kStateStarted
													
												: ($wpa_tWosState=ld_kStateLoaded)
													$wpa_tSubtype:=ld_kStateStarted
													
												: ($wpa_tWosState=ld_kStateStarted)
													$wpa_tSubtype:=ld_kSubtypeRestarted
													
												Else 
													TRACE:C157  // will be started
											End case 
											// $wpa_tSubtype is used later for wpa_kStart_Subtype
											
											_fld VALUE_STR_SET(kSet; wos_kWork_Phase_State; ld_kStateStarted)  // changed later in wo_ STATE_STARTED_SET?
											_fld VALUE_STR_SET(kSet; wos_kSubtype; $wpa_tSubtype)  // put this later to wo_ STATE_STARTED_SET
											_rec SAVE(wos_kTbl)
										End if 
										_rec UNLOAD(wos_kTbl)
										_tbl WRITE_STATE(wos_kTbl; kPrevious)
									End if 
							End case 
							
						End if 
				End case 
			End if 
			// wpa_ STATE_STARTED_SET crete new
			
			// update wpa_
			_tbl WRITE_STATE(wpa_kTbl; kTrue)
			_fld VALUE_STR_SET(kSet; wpa_kSubtype; $wpa_tSubtype)  // restarted if wos_ was started
			_fld VALUE_STR_SET(kSet; wpa_kStart_Subtype; $wpa_tSubtype)
			_fld VALUE_STR_SET(kSet; wpa_kProgram_id; $wpa_tPlateProgram)
			_fld VALUE_STR_SET(kSet; wpa_kInfo; $wpa_tInfo)
			$wpa_tJsonInfo:=_json_ TextToJsonText(""; "FmsLoad"; $wpa_tJsonInfo)  // is new empty json
			_fld VALUE_STR_SET(kSet; wpa_kAdditional_Data; $wpa_tJsonInfo)
			_rec SAVE(wpa_kTbl)
			_rec UNLOAD(wpa_kTbl)
			_tbl WRITE_STATE(wpa_kTbl; kPrevious)
			
			If ($wpa_lCountWos>0)
				If (wos_ StartMakeWoStarted=kTrue)
					wo_ STATE_STARTED_SET($wpa_tProductionLot)  // set all other wos_ states
				End if 
			End if 
			
			_cron_ MESSAGE(0; _lang Current("Created automatic actual work phase start event")+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroup+ksTab+_date CurrentDateTimeToString)
			
		End if 
		
		
		
		
		
	: (($wpa_lAction=3) | ($wpa_lAction=4))  // create fms end event
		$wpa_rHours:=0
		$wpa_rSetupHours:=0
		$wpa_tPlateProgram2:=Replace string:C233($wpa_tPlateProgram; "UNLOAD"; "LOAD")
		
		// ak 2014-09-19
		$wpa_tDescription:=""
		If ($wpa_lPhase=-1)
			$wpa_tErrMessage:=""
			$wpa_lPhase:=wpa_AutomaticFirstOpenPhaseGet($wpa_tProductionLot; $wpa_tLoadGroup; $wpa_lUnknownPhaseNumber; $wpa_lFarInThePast; ->$wpa_tDescription; ->$wpa_tErrMessage)
			If ($wpa_tErrMessage#"")
				$wpa_tErrMessage:=$wpa_tErrMessage+" - "+$wpa_tOpearation
				//$wpa_tErrMessage:=$wpa_tErrMessage+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroup // $wpa_tProductionLot and $wpa_tLoadGroup are aleady in wpa_
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage+ksTab+_date CurrentDateTimeToString)
			End if 
		End if 
		
		// ak 2013-11-14
		$wpa_lStartType:=wpa_ StartEventType
		$wpa_lSelSize:=wpa_ StartEventGet(String:C10($wpa_lStartType); $wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tEmployee; $wpa_tPlateProgram2; $wpa_tStockParcelCode; $wpa_tLoadGroup)
		If ($wpa_lSelSize<=0)
			$wpa_lSelSize:=wpa_ StartEventGet(String:C10($wpa_lStartType); $wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tEmployee; "LOAD"; $wpa_tStockParcelCode; $wpa_tLoadGroup)
			If ($wpa_lSelSize>0)
				$wpa_tPlateProgram2:="LOAD"
			Else   // ak 2014-03-19
				$wpa_lSelSize:=wpa_ StartEventGet(String:C10($wpa_lStartType); $wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tEmployee; "@"; $wpa_tStockParcelCode; $wpa_tLoadGroup)
				If ($wpa_lSelSize>0)
					$wpa_tPlateProgram2:="@"
				End if 
			End if 
		End if 
		
		// ak 2014-03-18
		$wpa_lOK:=kTrue
		If ($wpa_lSelSize>0)
			$wpa_rDateTime:=_dt ToReal($wpa_dDate; $wpa_hTime)
			$wpa_dDateWpa:=_fld ValueDate(wpa_kStart_Date)
			$wpa_hTimeWpa:=_fld ValueTime(wpa_kStart_Time)
			$wpa_rDateTimeWpa:=_dt ToReal($wpa_dDateWpa; $wpa_hTimeWpa)
			If ($wpa_rDateTimeWpa>$wpa_rDateTime)
				$wpa_lOK:=kFalse
				$wpa_tErrInfo:=$wpa_tErrInfo+" -- "+$wpa_tPlateProgram2+" - "+_dt RealToDateTimeString($wpa_rDateTimeWpa)
				$wpa_tErrMessage:=_lang Current("Start event is later than end")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			End if 
		Else   // ak 2014-03-19
			$wpa_tErrMessage:=_lang Current("Start event was not found. New end event created without start")+": "+$wpa_tErrInfo
			$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
			_cron_ MESSAGE(kError; $wpa_tErrMessage)
		End if 
		
		$wpa_tRecId:=""
		If ($wpa_lOK=kTrue)
			$wpa_tRecId:=wpa_ EndEventCreate(2; $wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tLoadGroup; $wpa_tEmployee; $wpa_rHours; $wpa_rSetupHours; $wpa_rQuantityFinished; $wpa_rQuantityFailed; $wpa_tDescription; $wpa_tSmeltingNum; $wpa_lShift; $wpa_dDate; $wpa_hTime; $wpa_tPlateProgram2; $wpa_tStockParcelCode; $wpa_tInfo; ""; "")
		End if 
		$wpa_lCountWo:=0
		$wpa_lCountWos:=0
		
		If ($wpa_tRecId="")
			$wpa_tErrMessage:=_lang Current("Automatic create failed for end event")+": "+$wpa_tErrInfo
			$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
			_cron_ MESSAGE(kError; $wpa_tErrMessage)
		Else 
			$wpa_lCountWpa:=_qry Fld(0; wpa_kRecord_ID; "="; ->$wpa_tRecId; ""; kFalse; kTrue)
			If ($wpa_lCountWpa#1)
				$wpa_tErrMessage:=_lang Current("Actual work phase was not found after end event")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			Else 
				
				Case of   // update wo_ and wos_
					: ($wpa_tWorkProdLotState="err")
						IDLE:C311  // no prod lot
					: (($wpa_lPhase=$wpa_lUnknownPhaseNumber) | ($wpa_lPhase=$wpa_lErrorPhaseNumber))
						IDLE:C311  // do not update prod lot or wos_
					Else 
						// get old wos_ state
						$wpa_lCountWos:=_qry Fld(0; wos_kProduction_Lot__work_ph; "="; ->$wpa_tProductionLotPhase; ""; kFalse; kTrue)
						If ($wpa_lCountWos<1)
							$wpa_tErrMessage:=_lang Current("Work order schedule was not found after end event")+": "+$wpa_tErrInfo
							$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
							_cron_ MESSAGE(kError; $wpa_tErrMessage)
						Else 
							$wpa_tWosSubtype:=_fld ValueStr(wos_kSubtype)  // save subtype before wpa_WOS_UPDATE
							$wpa_lCry:=<>wpa_lCryIfWosNotFound
							<>wpa_lCryIfWosNotFound:=2
							wpa_WOS_UPDATE($wpa_tProductionLot; $wpa_lPhase; kFalse; ""; kTrue; 0; kTrue; 0; kTrue; 0; ""; 0; 0)
							<>wpa_lCryIfWosNotFound:=$wpa_lCry
							//--------------
							If ($wpa_tWosSubtype#ld_kSubtypeFinished)  // prev wos state before wo_ STATE_STARTED_SET
								$wpa_lCountWos:=_qry Fld(0; wos_kProduction_Lot__work_ph; "="; ->$wpa_tProductionLotPhase; ""; kFalse; kTrue)
								If ($wpa_lCountWos<1)
									$wpa_tErrMessage:=_lang Current("Work order schedule was not found after end event update")+": "+$wpa_tErrInfo
									$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
									_cron_ MESSAGE(kError; $wpa_tErrMessage)
								Else 
									_tbl WRITE_STATE(wos_kTbl; kTrue)
									_rec LOCKED_WAIT(wos_kTbl; kTrue)
									If (OK=1)
										$wpa_tSubtype:=ld_kSubtypeBreak
										_fld VALUE_STR_SET(kSet; wos_kSubtype; $wpa_tSubtype)
										//_fld VALUE_STR_SET (kSet;wos_kWork_Phase_State;ld_kStateStarted)
										_rec SAVE(wos_kTbl)
									End if 
									_rec UNLOAD(wos_kTbl)
									_tbl WRITE_STATE(wos_kTbl; kPrevious)
								End if 
							End if 
							//--------------
						End if 
						$wpa_lCountWpa:=_qry Fld(0; wpa_kRecord_ID; "="; ->$wpa_tRecId; ""; kFalse; kTrue)  // redo query
				End case 
				
				If ($wpa_lCountWpa#1)
					$wpa_tErrMessage:=_lang Current("Actual work phase was not found after end event update")+": "+$wpa_tErrInfo
					$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
					_cron_ MESSAGE(kError; $wpa_tErrMessage)
				Else 
					_tbl WRITE_STATE(wpa_kTbl; kTrue)
					If (_fld ValueStr(wpa_kProgram_id)="")
						_fld VALUE_STR_SET(kSet; wpa_kProgram_id; $wpa_tPlateProgram)
					End if 
					
					If (_fld ValueDate(wpa_kStart_Date)=!00-00-00!)
						_fld VALUE_DATE_SET(kSet; wpa_kStart_Date; $wpa_dDate)
						_fld VALUE_TIME_SET(kSet; wpa_kStart_Time; $wpa_hTime)
					End if 
					
					_fld VALUE_STR_SET(kSet; wpa_kInfo; $wpa_tInfo)
					$wpa_tJsonInfoFld:=_fld ValueStr(wpa_kAdditional_Data)
					$wpa_tJsonInfoFld:=_json_ TextToJsonText($wpa_tJsonInfoFld; "FmsUnload"; $wpa_tJsonInfo)  // is new tag
					_fld VALUE_STR_SET(kSet; wpa_kAdditional_Data; $wpa_tJsonInfoFld)
					
					_fld VALUE_STR_SET(kSet; wpa_kType_; ld_kTypeFinished)
					//_fld VALUE_STR_SET (kSet;wpa_kStart_Subtype;ld_kSubtypeStarted) // only start can set this
					_fld VALUE_STR_SET(kSet; wpa_kSubtype; ld_kSubtypeBreak)
					xapp TblRun(wpa_kEnd_Time; wpa_kTbl; kNoEvent)  // calculate work times
					// add cnc time = wpa_kMachine_Hours
					
					// calculate machine times
					$wpa_rMachineHours:=0
					$wpa_rHours:=0
					
					$wpa_dStartDate:=_fld ValueDate(wpa_kStart_Date)
					$wpa_hStartTime:=_fld ValueTime(wpa_kStart_Time)
					$wpa_dDate:=_fld ValueDate(wpa_kDate_)
					$wpa_hTime:=_fld ValueTime(wpa_kEnd_Time)
					$wpa_rStart:=_dt ToReal($wpa_dStartDate; $wpa_hStartTime)
					$wpa_rEnd:=_dt ToReal($wpa_dDate; $wpa_hTime)
					wpa_AUTOMATIC_WPA_TIMES_GET($wpa_tPlateProgram; $wpa_tJsonInfo; $wpa_rStart; $wpa_rEnd; $wpa_tLoadGroup; $wpa_rAutomaticReceiptDelay; ->$wpa_rMachineHours; ->$wpa_rHours; kTrue)
					_fld VALUE_REAL_SET(kSet; wpa_kMachine_Hours; $wpa_rMachineHours)
					_fld VALUE_REAL_SET(kSet; wpa_kWork_Time__amount; $wpa_rHours)
					wpa_SETUP_HOURS_CALCULATE($wpa_rHours; $wpa_rMachineHours)
					xapp TblRun(wpa_kSalary__hour; wpa_kTbl; kNoEvent)  // AK 2012-06-12: update prices 
					
					_rec SAVE(wpa_kTbl)
					_rec UNLOAD(wpa_kTbl)
					_tbl WRITE_STATE(wpa_kTbl; kPrevious)
					
					wos_ REMAINING_WORK_TIME_SAVE2($wpa_tProductionLot; $wpa_lPhase)
					
					If (wos_ StartMakeWoStarted=kTrue)
						wo_ STATE_STARTED_SET($wpa_tProductionLot)  // set all other wos_ states
					End if 
					
					_cron_ MESSAGE(0; _lang Current("Created automatic actual work phase end event")+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroup+ksTab+_date CurrentDateTimeToString)
					
				End if 
			End if 
		End if 
		
		
		
		
		
	: ($wpa_lAction=5)  // create unmanned end event
		
		// calculate end time from machine run time and delay
		$wpa_dStartDate:=_fld ValueDate(wpa_kStart_Date)
		$wpa_hStartTime:=_fld ValueTime(wpa_kStart_Time)
		$wpa_rEnd:=wpa_UnmannedEndTime($wpa_tLoadGroup; $wpa_rAutomaticReceiptDelay; $wpa_dStartDate; $wpa_hStartTime)
		$wpa_dDate:=_dt RealToDate($wpa_rEnd)
		$wpa_hTime:=_dt RealToTime($wpa_rEnd)
		If ($wpa_rEnd=-1)
			IDLE:C311  // do not create end event
			_cron_ MESSAGE(0; _lang Current("Machine data was not found, automatic unmanned actual work phase end event create was cancelled")+": "+$wpa_tErrInfo)
		Else 
			$wpa_tRecId:=_fld ValueStr(wpa_kRecord_ID)
			$wpa_lCountWpa:=1
			$wpa_lCountWos:=_qry Fld(0; wos_kProduction_Lot__work_ph; "="; ->$wpa_tProductionLotPhase; ""; kFalse; kTrue)
			If ($wpa_lCountWos<1)
				$wpa_tErrMessage:=_lang Current("Work order schedule was not found after unmanned end event")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			Else 
				
				// get old wos_ state
				//$wpa_tWosSubtype:=_fld ValueStr (wos_kSubtype)  // save subtype before wpa_WOS_UPDATE
				//Case of 
				//: ($wpa_tWosSubtype=ld_kSubtypeFinished)
				//IDLE
				//: ($wpa_tWosSubtype=ld_kSubtypeShiftEnd)
				//IDLE
				//Else 
				$wpa_lCry:=<>wpa_lCryIfWosNotFound
				<>wpa_lCryIfWosNotFound:=2
				wpa_WOS_UPDATE($wpa_tProductionLot; $wpa_lPhase; kFalse; ""; kTrue; 0; kTrue; 0; kTrue; 0; ""; 0; 0)
				<>wpa_lCryIfWosNotFound:=$wpa_lCry
				//--------------
				$wpa_lCountWos:=_qry Fld(0; wos_kProduction_Lot__work_ph; "="; ->$wpa_tProductionLotPhase; ""; kFalse; kTrue)
				If ($wpa_lCountWos<1)
					$wpa_tErrMessage:=_lang Current("Work order schedule was not found after unmanned end event update")+": "+$wpa_tErrInfo
					$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
					_cron_ MESSAGE(kError; $wpa_tErrMessage)
				Else 
					_tbl WRITE_STATE(wos_kTbl; kTrue)
					_rec LOCKED_WAIT(wos_kTbl; kTrue)
					If (OK=1)
						_fld VALUE_STR_SET(kSet; wos_kSubtype; ld_kSubtypeShiftEnd)
						_fld VALUE_STR_SET(kSet; wos_kWork_Phase_State; ld_kStateStarted)
						_rec SAVE(wos_kTbl)
					End if 
					_rec UNLOAD(wos_kTbl)
					_tbl WRITE_STATE(wos_kTbl; kPrevious)
				End if 
				//End case 
				//--------------
				$wpa_lCountWpa:=_qry Fld(0; wpa_kRecord_ID; "="; ->$wpa_tRecId; ""; kFalse; kTrue)  // redo query
			End if 
			
			If ($wpa_lCountWpa#1)
				$wpa_tErrMessage:=_lang Current("Actual unmanned work phase was not found after end event update")+": "+$wpa_tErrInfo
				$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
				_cron_ MESSAGE(kError; $wpa_tErrMessage)
			Else 
				_tbl WRITE_STATE(wpa_kTbl; kTrue)
				
				_fld VALUE_LONG_SET(kSet; wpa_kShift_Number; $wpa_lShift)  // wpa_UnmannedEndTime was after this
				
				_fld VALUE_DATE_SET(kSet; wpa_kDate_; $wpa_dDate)
				_fld VALUE_TIME_SET(kSet; wpa_kEnd_Time; $wpa_hTime)
				$wpa_rStart:=_dt ToReal($wpa_dStartDate; $wpa_hStartTime)
				$wpa_rHours:=_dt Difference($wpa_rEnd; $wpa_rStart)
				
				_fld VALUE_STR_SET(kSet; wpa_kInfo; $wpa_tInfo)
				_fld VALUE_STR_SET(kSet; wpa_kType_; ld_kTypeFinished)
				//_fld VALUE_STR_SET (kSet;wpa_kStart_Subtype;ld_kSubtypeStarted) // only start can set this
				_fld VALUE_STR_SET(kSet; wpa_kSubtype; ld_kSubtypeShiftEnd)
				
				$wpa_rSetupHours:=0
				_sel RELATE_ONE(w_kWork__Position_Num_ID; wpa_kWork__Position_Num_id)
				
				$wpa_tLoadGroupOld:=_fld ValueStr(wpa_kWork_Load_Group_id)
				If ($wpa_tLoadGroupOld#"")
					If ($wpa_tLoadGroupOld#$wpa_tLoadGroup)
						_cron_ MESSAGE(0; _lang Current("Actual work phase load group has changed")+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroupOld+" -> "+$wpa_tLoadGroup+ksTab+_date CurrentDateTimeToString)
					End if 
				End if 
				
				wpa_ FLD_VALUES_SET($wpa_tWork; $wpa_tProductionLot; $wpa_lPhase; $wpa_tLoadGroup; $wpa_tEmployee; $wpa_rHours; $wpa_rSetupHours; $wpa_rQuantityFinished; $wpa_rQuantityFailed; $wpa_tDescription; $wpa_tSmeltingNum; $wpa_lShift)
				
				
				ARRAY TEXT:C222($wpa_atMaintenanceWork; 0)
				wpa_ MAINTENANCE_WORK_ARR(->$wpa_atMaintenanceWork)
				If (Find in array:C230($wpa_atMaintenanceWork; _fld ValueStr(wpa_kWork__Position_Num_id))<0)  // don't use Machine_Hours on maintenance work
					$wpa_rHours:=wpa_UnmannedMachineTime($wpa_tLoadGroup; $wpa_rStart; $wpa_rEnd)
					_fld VALUE_REAL_SET(kSet; wpa_kMachine_Hours; $wpa_rHours)
				End if 
				
				//xapp TblRun (wpa_kEnd_Time;wpa_kTbl;kNoEvent)  // calculate work times
				
				//If ($wpa_lCountWos=1)
				//
				//end if
				_rec SAVE(wpa_kTbl)
				_rec UNLOAD(wpa_kTbl)
				_tbl WRITE_STATE(wpa_kTbl; kPrevious)
				
				wos_ REMAINING_WORK_TIME_SAVE2($wpa_tProductionLot; $wpa_lPhase)
				
				If (wos_ StartMakeWoStarted=kTrue)
					wo_ STATE_STARTED_SET($wpa_tProductionLot)  // set all other wos_ states
				End if 
				
			End if 
			//End if 
			//
			_cron_ MESSAGE(0; _lang Current("Created automatic unmanned actual work phase end event")+": "+$wpa_tProductionLot+", "+$wpa_tLoadGroup+ksTab+_date CurrentDateTimeToString)
			//
			//End if 
		End if 
		
	Else 
		TRACE:C157  // should never come here
		
End case 


$0:=$wpa_tRecId

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 