//%attributes = {}
// Method: wpa_UnmannedEndTime 
// 20.03.12, 03:50:57 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// 
// calculate end time from machine run time and delay, MUST NOT change wpa_kTbl current record
// called from: wpa_ UNMANNED_WPA_CREATE -> wpa_AutomaticWpaCreate
// see: wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_UnmannedMachineTime
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($1; $wpa_tLoadGroup; $wpa_tLoadGroupMachine; $wpa_tWorkCalendar)
C_DATE:C307($3; $wpa_dStartDate; $wpa_dEndDate)
C_TIME:C306($4; $wpa_hStartTime)
C_REAL:C285($2; $wpa_rAutomaticReceiptDelay; $wpa_rUnmannedNotRunTime; $wpa_rStart; $wpa_rEnd)
C_LONGINT:C283($wpa_lCapIndex; $wpa_lCapIndexLast; $wpa_lInRunRatio; $wpa_lUnmannedShift; $wpa_lPartIndex)

$wpa_tLoadGroup:=$1
$wpa_tLoadGroupMachine:=$wpa_tLoadGroup+"_machine"
$wpa_rAutomaticReceiptDelay:=$2
$wpa_dStartDate:=$3
$wpa_hStartTime:=$4
$wpa_rStart:=_dt ToReal($wpa_dStartDate; $wpa_hStartTime)

$wpa_lUnmannedShift:=4
_prf_ JSON(<>wpa_tAutomaticPrfName; "UnmannedShift"; ->$wpa_lUnmannedShift)

$wpa_rEnd:=0
$wpa_rUnmannedNotRunTime:=0

$wpa_dEndDate:=_date Current(kTrue)
ldcap_ MACHINE_LOAD_DATE_SET($wpa_dStartDate; $wpa_dEndDate)

wpa_TIME_PART_ARR_CREATE_INIT($wpa_tLoadGroup; $wpa_dStartDate; !00-00-00!)

// calculate ldcap_InfoToBrushColor.json prf "ldcap_alBrushInRunRatio" array > 0 times to machine hours field
ldcap_ARR_LOAD_SAVE(kLoad; $wpa_tLoadGroupMachine; kFalse)  // load machine data

$wpa_lCapIndexLast:=ldcap_IndexLast($wpa_tLoadGroupMachine)
$wpa_lCapIndex:=ldcap_ IndexFirstLoaded($wpa_tLoadGroupMachine; $wpa_dStartDate; $wpa_hStartTime)

// --- calculate UnmannedNotRunTime hours ---
// wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_ UNPRODUCTIVE_WPA_CREATE 
If ($wpa_lCapIndex<1)
	$wpa_lCapIndex:=-1  // no end found
	_err MESSAGE(_lang Current("No array index found for load group")+": "+$wpa_tLoadGroup; Current method name:C684; kFalse)
Else 
	While ($wpa_lCapIndex>0)  // calculate run times
		IDLE:C311
		If (ldcap_arCapacity{$wpa_lCapIndex}>0)  // = end and start are the same?
			
			$wpa_tInfo:=_str Parse(ldcap_atInfo{$wpa_lCapIndex}; ";"; 2)  // LOAD, CYCLE ON, ERROR and so on...
			$wpa_lInRunRatio:=Num:C11(ldcap_ InfoToBrushColor(3; "ldcap_InfoToBrushColor"; $wpa_tInfo))
			// in debug use: _dt RealToDateTimeString 
			// split cap to part with load goup shift calendar and sum those parts
			wpa_TIME_PART_ARR_CREATE($wpa_tLoadGroup; ldcap_arStart{$wpa_lCapIndex}; ldcap_arEnd{$wpa_lCapIndex})  // will fill wpa_lPartCount and wpa_arPart... -arrrays
			For ($wpa_lPartIndex; 1; wpa_lPartCount)
				
				If (($wpa_lInRunRatio<1) & (wpa_alPartShift{$wpa_lPartIndex}>=1) & (wpa_alPartShift{$wpa_lPartIndex}#$wpa_lUnmannedShift))
					// shift is normal work shift
					If ($wpa_rUnmannedNotRunTime>0)
						// end at the start of real shift
						If ($wpa_rUnmannedNotRunTime<$wpa_rAutomaticReceiptDelay)
							$wpa_rEnd:=wpa_arPartStart{$wpa_lPartIndex}
						End if 
						$wpa_lPartIndex:=wpa_lPartCount+1  // exit loop
						$wpa_lCapIndex:=-3
					End if 
					// end - shift is normal work shift
				Else 
					
					// sum only if not in run ratio & not normal work shift
					If (($wpa_lInRunRatio>0) & (wpa_alPartShift{$wpa_lPartIndex}>=1) & (wpa_alPartShift{$wpa_lPartIndex}#$wpa_lUnmannedShift))
						$wpa_rEnd:=wpa_arPartStart{$wpa_lPartIndex}  // normal shift + machine runs = end time is part start always
						$wpa_lPartIndex:=wpa_lPartCount+1  // exit part for loop
						$wpa_lCapIndex:=-3  // exit while loop
					Else 
						If ($wpa_rUnmannedNotRunTime=0)
							$wpa_rEnd:=wpa_arPartStart{$wpa_lPartIndex}
						End if 
						If ($wpa_rStart>wpa_arPartStart{$wpa_lPartIndex})
							If (wpa_arPartEnd{$wpa_lPartIndex}>$wpa_rStart)
								$wpa_rUnmannedNotRunTime:=$wpa_rUnmannedNotRunTime+_dt Difference(wpa_arPartEnd{$wpa_lPartIndex}; $wpa_rStart)
							End if 
						Else 
							$wpa_rUnmannedNotRunTime:=$wpa_rUnmannedNotRunTime+_dt Difference(wpa_arPartEnd{$wpa_lPartIndex}; wpa_arPartStart{$wpa_lPartIndex})
						End if 
						
						If (($wpa_lInRunRatio>0) | ((wpa_alPartShift{$wpa_lPartIndex}>=1) & (wpa_alPartShift{$wpa_lPartIndex}#$wpa_lUnmannedShift)))
							// normal run will reset UnmannedNotRunTime
							If ($wpa_rUnmannedNotRunTime>=$wpa_rAutomaticReceiptDelay)
								$wpa_rEnd:=wpa_arPartEnd{$wpa_lPartIndex}
							Else 
								$wpa_rUnmannedNotRunTime:=0
							End if 
						End if 
						
					End if 
					
					If ($wpa_rUnmannedNotRunTime>=$wpa_rAutomaticReceiptDelay)
						$wpa_lPartIndex:=wpa_lPartCount+1  // exit loop
					End if 
					// end - sum only if not in run ratio & not normal work shift
					
				End if 
			End for 
			
		End if   // If (ldcap_arCapacity{$wpa_lCapIndex}>0)  // = end and start are the same?
		
		Case of 
			: ($wpa_lCapIndex=-3)
				IDLE:C311  // loop already cancelled
			: ($wpa_rUnmannedNotRunTime>=$wpa_rAutomaticReceiptDelay)
				$wpa_lCapIndex:=-2  // end loop, long-enough unmanned time was found
			: ($wpa_lCapIndex>=$wpa_lCapIndexLast)
				$wpa_lCapIndex:=-1  // end loop, no long-enough unmanned time was found
			Else 
				$wpa_lCapIndex:=$wpa_lCapIndex+1  // continue loop
		End case 
	End while 
End if 

If ($wpa_lCapIndex=-1)
	$0:=-1  // no long-enough unmanned time was found, cancel end event create
Else 
	If ($wpa_rStart>$wpa_rEnd)
		$wpa_rEnd:=$wpa_rStart  // now we have looped to capacity index where long enough UnmannedNotRunTime started, set that time to work end time
	End if 
	
	If ($wpa_lCapIndex#-3)
		If (_dt Difference($wpa_rEnd; $wpa_rStart)<$wpa_rAutomaticReceiptDelay)
			$wpa_rEnd:=$wpa_rStart+_dt HoursToReal($wpa_rAutomaticReceiptDelay)
		End if 
	End if 
	
	$0:=$wpa_rEnd  // now we have looped to capacity index where long enough UnmannedNotRunTime started, set that time to work end time
	// no delay at the end: +_dt HoursToReal ($wpa_rAutomaticReceiptDelay)
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 