//%attributes = {}
// Method: xml_ObjWhitespaceTrim
// 2002.03.15-17:20:15 / Pasi Mankinen
// © Copyright 2002 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
//Method: xml_ObjWhitespaceTrim(CDATA) --> CDATA
//Author: Mark Mitchenall
//Created: 4/11/01 at 3:56 PM

//This routine trims the whitespace from the start and end of CDATA.
//This my be built into Expat4D at a later stage depending on user requests.
//NOTE: this method uses the global array <>xmlObj_Whitespace which is 
//initialised in xmlObj_Startup.

C_TEXT:C284($1; $input)
C_TEXT:C284($0; $output)

$input:=$1
$output:=""

//From XML 1.0 Specification: Whitespace
//[3] 	S	::= 	(#x20 | #x9 | #xD | #xA)+

C_LONGINT:C283($fromStart; $fromEnd)


$fromEnd:=Length:C16($input)
$fromStart:=0

If ($fromEnd>0)
	
	$fromStart:=1
	
	While (($fromStart<$fromEnd) & (<>xml_afObjWhitespace{Character code:C91($input[[$fromStart]])}))
		$fromStart:=$fromStart+1
	End while 
	
	If ($fromStart<$fromEnd)
		While (($fromEnd>$fromStart) & (<>xml_afObjWhitespace{Character code:C91($input[[$fromEnd]])}))
			$fromEnd:=$fromEnd-1
		End while 
	End if 
	
	Case of 
		: ($fromStart#$fromEnd)
			$output:=Substring:C12($input; $fromStart; ($fromEnd-$fromStart)+1)
		: ($fromStart=1)  // also $fromEnd=1
			If (<>xml_afObjWhitespace{Character code:C91($input[[$fromStart]])})
				$output:=""
			Else 
				$output:=$input
			End if 
	End case 
	
End if 

$0:=$output
