const rec = state.rec
const arr = state.arr
const hdr = state.hdr
const mainState = nc.mainState()
const recordTypeSeparator = mainState.rec.recordTypeSeparator
mainState.list = state

const area = 'list' // grid area name
const baseCallParam = {
	rec: { tab: '', table: '' } // , query: { field: '', operator: '', query_value1: '', query_value2: '', query_name: '' } }
}
let prevTable = ''
let allSelected = ref(false)
let rowsLoaded = ref(0)
let rowsInSelection = ref(0)
let rowsInTable = ref(0)
let gridStyle = ref('')
setGridStyle(1)

callServer('init')

onDeactivated(() => {
	mainState.rec.in_form = ''
})

onActivated(() => {
	// using keep-alive
	mainState.rec.in_form = 'list'
	if (rec.row_index != null && rec.first_displayed_row != null && rec.start_row_index != null) {
		nc.grid.redrawRows(state, area)
		nc.grid.activateRows(state, area, rec.row_index, rec.first_displayed_row + rec.row_index - rec.start_row_index, 'unselectOther')
	}
	/* if (rec.record_id) {
				const selectIdx = nc.recordArrayIndex(state.grid.list.data, rec.table_prefix + '.record_id', rec.record_id)
				nc.grid.activateRows(state, area, selectIdx + 1, 'scroll-first', 'unselectOther')
			} */
})

/* onDeactivated(() => {
			// using keep-alive
		}) */

onMounted(() => {
	mainState.rec.in_form = 'list'
	// window.removeEventListener('keyup', globalKeypress)
	window.addEventListener('keyup', globalKeypress)
})

onBeforeUnmount(() => {
	mainState.rec.in_form = ''
	window.removeEventListener('keyup', globalKeypress)
})

function globalKeypress() {}

watchEffect(() => {
	if (mainState.rec.table !== '' && rec.table !== mainState.rec.table) {
		if (arr.query && nc.isArray(arr.query[mainState.rec.table]) && nc.isArray(arr.query[rec.table])) {
			if (arr.query[mainState.rec.table].length > arr.query[rec.table].length) {
				setGridStyle(arr.query[mainState.rec.table].length) // make grid area smaller, never bigger to prevent scollbar flash
			}
		}
		arr.defalut_query[0].field = '' // re-set this
		rec.table = mainState.rec.table
		arr.tab_orig = null
		callServer('init')
	}
})

function addSavedQuery(name) {
	const queryArr = arr.query[rec.table]
	const value = nc.clone(queryArr) // nc.clone(queryArr, ['table_field'])
	rec.saved_query = value
	arr.saved_query.splice(0, 0, { show: name, value: value })
	if (nc.isArray(arr.saved_query) && arr.saved_query.length > rec.saved_query_count) {
		arr.saved_query.splice(rec.saved_query_count, 10) // delete from end
	}
}

function selectSavedQuery(value, prevValue) {
	if (value !== prevValue) {
		if (rec.saved_query === 'save_query') {
			const name = prompt('Anna haun nimi:', '')
			if (name != null) {
				addSavedQuery(name)
			}
			return
		}
		if (nc.isArray(rec.saved_query) && rec.saved_query.length > 0) {
			arr.query[rec.table] = nc.clone(rec.saved_query)
			setGridStyle(arr.query[rec.table].length)
		}
	}
}

function setQueryArray() {
	if (!arr.defalut_query[0].field) {
		arr.defalut_query[0].field = rec.field
	}
	const queryArr = arr.query[rec.table]
	if (queryArr == null || !nc.isArray(queryArr)) {
		arr.query[rec.table] = nc.clone(arr.defalut_query)
	} else {
		arr.query[rec.table] = queryArr
		if (queryArr.length > 0 && (queryArr[0].query_value1 || queryArr[0].operator !== '=')) {
			let save = true
			if (arr.saved_query.length > 0) {
				for (const item of arr.saved_query)
					if (nc.isEqual(queryArr, item.value, ['table_field'])) {
						save = false
						break
					}
			}
			if (save) {
				let name = queryArr[0].query_value1 // arr.saved_query.length + 1 + '. ' + queryArr[0].query_value1
				if (queryArr[0].query_value2) {
					name += ' - ' + queryArr[0].query_value2
				}
				name += ` (${queryArr.length})`
				addSavedQuery(name)
			}
		}
	}
	const tblField = arr.table_field[rec.table]
	if (tblField) {
		for (const item of arr.query[rec.table]) {
			item.table_field = tblField
			if (!item.field) {
				item.field = rec.field // item.field is '' or null
			} else {
				rec.field = item.field // set rec.field to last in query array
			}
		}
	}
	if (nc.isArray(arr.query[rec.table])) {
		setGridStyle(arr.query[rec.table].length, 'remove')
	}
}

function loadParam(callParam) {
	if (!rec.table) {
		const param = nc.getParam()
		if (param && param.rec.table) {
			rec.table = param.rec.table
		} else {
			rec.table = ''
		}
	} else {
		const param = nc.getParam('nc-list-form')
		if (param && param[rec.table]) {
			callParam.rec = Object.assign(callParam.rec, param[rec.table].rec)
			param[rec.table].rec = undefined
			callParam = Object.assign(callParam, param[rec.table])
		}
	}
}

function setCallParamRec(callParam, option) {
	callParam.rec.tab = rec.tab
	const arrRec = nc.findRecFromArr(arr.tab, 'value', rec.tab)
	callParam.rec.query_name = arrRec && arrRec.query_name ? arrRec.query_name : ''
	callParam.rec.table = rec.table
	if (arr.query[rec.table] == null) {
		callParam.rec.query = nc.clone(arr.defalut_query)
		// delete callParam.rec.query[0].query_dropdown
	} else {
		callParam.rec.query = []
		for (const item of arr.query[rec.table]) {
			callParam.rec.query.push({
				field: item.field || '',
				selection_type: item.selection_type,
				operator: item.operator,
				query_value1: item.query_value1,
				query_value2: item.query_value2
			})
		}
	}
	allSelected.value = option === 'all'
	callParam.rec.all_records = allSelected.value
	/* if (!nc.isEqual(callParam.rec, prevCallParamRec)) {
				saveParam()
			} */
}

function setTabCount() {
	if (state.grid.list.info && state.grid.list.info.row_count != null) {
		rowsLoaded.value = state.grid.list.info.row_count || 0
		rowsInSelection.value = state.grid.list.info.row_count_total || 0
		rowsInTable.value = state.grid.list.info.rowCountTable || 0
		let rows = rowsLoaded.value.toLocaleString() //rowsInSelection.value.toLocaleString()
		if (state.new_record && state.new_record.length > 0) {
			rows += ` + ${state.new_record.length.toLocaleString()} = ${(rowsInSelection.value + state.new_record.length).toLocaleString()}`
		}
		arr.tab_orig = arr.tab_orig || nc.clone(arr.tab) // null arr.tab_orig on table change
		const arrRecOrig = nc.findRecFromArr(arr.tab_orig, 'value', rec.tab)
		const arrRec = nc.findRecFromArr(arr.tab, 'value', rec.tab)
		if (arrRec && arrRec.show && arrRecOrig && arrRecOrig.show) {
			arrRec.show =
				arrRecOrig.show +
				rec.table_count_format.replace('rowsInSelection', `${rows}`).replace('rowsInTable', `${rowsInTable.value.toLocaleString()}`)
		}
	}
}

function callServer(action, option) {
	const return_object = []
	let callParam = nc.clone(baseCallParam)
	if (action === 'init') {
		loadParam(callParam)
		return_object.push('load_batch_size')
		return_object.push('arr.tab')
		if (!mainState.rec.table) {
			return_object.push('arr.table')
		}
		if (rec.table !== prevTable || rec.table === '') {
			prevTable = rec.table
			return_object.push('arr.table_field')
		}
		action = 'query'
	}
	return_object.push('grid')
	callParam.action = action
	setCallParamRec(callParam, option)
	callParam.return_object = return_object
	if (option && typeof option === 'object') {
		for (let key in option) {
			callParam[key] = option[key]
		}
	}
	function serverCallback(ret) {
		state.new_record = []
		loadRows(ret)
		if (ret.rec) {
			rec.field = peg.parseBefore(rec.field, ',') // todo: temporary fix for multiple fields
			setQueryArray()
			mainState.arr.table = arr.table
			mainState.rec.table = rec.table
			setListDataRec(state.grid.list.data && state.grid.list.data[0])
			if (arr.tab) {
				// this should run only when arr.tab changes
				arr.tab = arr.tab.map(item => {
					if (item.query_name && !item.icon) item.icon = 'filter'
					return item
				})
			}
		}
	}
	nc.callServer(state, area, callParam, serverCallback)
}

function query(event, option) {
	if (event) {
		event.preventDefault()
		if (event.key === 'Enter') {
			callServer('query', option)
		}
	} else {
		callServer('query', option)
	}
}

function loadRows(ret) {
	if (ret.grid && ret.grid.list && ret.grid.list.info) {
		state.new_record = state.new_record || mainState.list.new_record || []
		if (state.new_record.length > 0) {
			const removeIdx = []
			let idx = 0
			for (const item of state.new_record) {
				if (item.record_id == '') {
					removeIdx.push[idx]
				} else {
					state.grid.list.data.push(item)
				}
				idx++
			}
			for (const idx of removeIdx) {
				state.new_record.splice(idx, 1)
			}
		}
		setTabCount()
	}
}

function queryValue2Disabled(index) {
	if (!arr.query[rec.table] && arr.query[rec.table][index]) {
		return true
	}
	return ['!==', '==', '<', '<=', '>', '>='].includes(arr.query[rec.table][index].operator)
}

function fallbackCopyTextToClipboard(text) {
	var textArea = document.createElement('textarea')
	textArea.value = text
	// Avoid scrolling to bottom
	textArea.style.top = '0'
	textArea.style.left = '0'
	textArea.style.position = 'fixed'
	document.body.appendChild(textArea)
	textArea.focus()
	textArea.select()
	try {
		var successful = document.execCommand('copy')
		var msg = successful ? 'successful' : 'unsuccessful'
		console.log('Fallback: Copying text command was ' + msg)
	} catch (err) {
		console.error('Fallback: Oops, unable to copy', err)
	}
	document.body.removeChild(textArea)
}

function copyTextToClipboard(text) {
	if (!navigator.clipboard) {
		fallbackCopyTextToClipboard(text)
		return
	}
	navigator.clipboard.writeText(text).then(
		function () {
			// message.setInfo(state, `Copying text to clipboard was successful`)
		},
		function (err) {
			message.setWarning(state, `Could not copy text, error: ${err.message}`)
		}
	)
}

function setChangeRecord(data, colId, oldValue, newValue) {
	if (data.changeRecord && data.changeRecord[colId] === newValue) {
		delete data.changeRecord[colId]
		if (nc.isEmptyObject(data.changeRecord)) {
			delete data.changeRecord
		}
	} else if (oldValue !== newValue) {
		if (data.changeRecord == null) {
			data.changeRecord = { [colId]: oldValue }
		} else if (data.changeRecord[colId] == null && oldValue !== newValue) {
			data.changeRecord[colId] = oldValue
		}
	}
}

function setNewChangeRecord(gridData, dataRec, rowIndex) {
	// TODO: unique find by field type unique or primary key, not per.person_id
	// TODO: check allowed values from field preferece
	if (dataRec.per && dataRec.per.person_id != null) {
		let idx = nc.recordArrayIndexLowerCase(gridData, 'per.person_id', dataRec.per.person_id)
		if (idx === rowIndex) {
			idx = nc.recordArrayIndexLowerCase(gridData, 'per.person_id', dataRec.per.person_id, idx + 1)
		}
		if (idx >= 0 || dataRec.per.person_id === '') {
			if (dataRec.changeRecord) {
				dataRec.changeRecord.duplicate = idx + 1
			} else {
				dataRec.changeRecord = { duplicate: idx + 1 }
			}
		} else if (dataRec.changeRecord && dataRec.changeRecord.duplicate != null) {
			delete dataRec.changeRecord.duplicate
		}
	}
}

function cleanNewRecord(data) {
	const dataRec = data
	dataRec.record_id = ''
	dataRec.modify_id = ''
	delete data.idx
	delete dataRec.db_id
	delete dataRec.db_modify_id
	delete dataRec.create_time
	delete dataRec.modify_time
	delete dataRec.modify_user
}

function cleanRecordId(area) {
	const grid = nc.grid.grid(state, area)
	const useHeaderName = grid.options && grid.options.use_header_name
	return useHeaderName != null
}

function flatten(obj, prefix, current, cleanExport = true, cleanRecId) {
	prefix = prefix || []
	current = current || {}
	// null is also an object
	if (typeof obj === 'object' && obj != null) {
		obj = nc.clone(obj)
		if (cleanRecId) {
			delete obj.record_id
		}
		if (cleanExport) {
			delete obj.idx
			delete obj.modify_id
			delete obj.db_id
			delete obj.db_modify_id
			delete obj.create_time
			delete obj.modify_time
			delete obj.modify_user
		}
		for (const key of Object.keys(obj)) {
			flatten(obj[key], prefix.concat(key), current, cleanRecId)
		}
	} else {
		current[prefix.join('.')] = obj
	}
	return current
}

function updateGridData(action, ret) {
	let resultArr
	if (action === 'save') {
		if (!nc.isArray(ret.save)) {
			return `Tallennuksen tulos ei sisällä '${action}' -taulukkoa`
		} else {
			resultArr = ret.save
		}
	} else if (action === 'delete') {
		if (!nc.isArray(ret.delete)) {
			return `Tallennuksen tulos ei sisällä '${action}' -taulukkoa`
		} else {
			resultArr = ret.delete
		}
	}
	for (const tbl of resultArr) {
		if (!nc.isArray(tbl.data)) {
			return `Tallennuksen tulos ei sisällä 'data' -taulukkoa`
		}
		for (let i = 0; i < tbl.data.length; i++) {
			const item = tbl.data[i]
			if (action === 'save') {
				if (item == null) {
					return `Tallennuksen tulos ei sisällä '${rec.table_prefix}' -objektia` // todo: test save
				}
				let idx = nc.recordArrayIndex(state.grid.list.data, 'record_id', item.record_id)
				if (idx < 0) {
					return 'ok'
				}
				if (!state.grid.list.data[idx] || state.grid.list.data[idx] == null) {
					return `Lista ei sisällä tallennuksen tuloksen objektia '${rec.table_prefix}' -objektia`
				}
				state.grid.list.data[idx] = item
				delete state.grid.list.data[idx].changeRecord
			} else if (action === 'delete') {
				const fld = peg.parseAfter(tbl.field, rec.table_prefix + '.')
				const idx = nc.recordArrayIndex(state.grid.list.data, fld, item)
				if (idx < 0) {
					return `Tuhoamisen tulos: ${tbl.field} -kenttää '${item}' ei löydy`
				}
				nc.grid.removeByArray(state, area, [state.grid.list.data[idx]])
			}
		}
	}
	return 'ok'
}

async function sendRecs(activatedArr, action, verb, startVerb, doneVerb) {
	let status = 'ok'
	let i = 0
	let count = 0
	let records
	let callFunction
	if (action === 'save') {
		callFunction = nc.saveArray
	} else if (action === 'delete') {
		callFunction = nc.deleteArray
	} else {
		message.setWarning(state, 'sendRecs action is not save or delete')
		return
	}
	if (activatedArr.length === 1) {
		records = 'record'
	} else {
		records = 'records'
	}
	rec.progress_bar.message = `${startVerb} ${activatedArr.length.toLocaleString()} ${records}...`
	while (i < activatedArr.length && status === 'ok') {
		const sendArr = activatedArr.slice(i, i + rec.save_batch_size)
		rec.progress_bar.percent = Math.round(((count + sendArr.length / 2) / activatedArr.length) * 100)
		count = count + sendArr.length
		const sendPromise = new Promise(resolve => {
			callFunction(state, rec.table, sendArr, ret => {
				status = ret && (ret.error || ret.status)
				rec.progress_bar.percent = Math.round((count / activatedArr.length) * 100)
				if (status !== 'ok') {
					rec.progress_bar.message = `${verb} failed, status: ${status}`
					resolve()
				} else {
					status = updateGridData(action, ret)
					if (status !== 'ok') {
						rec.progress_bar.message = `${verb} failed, error: ${status}`
						resolve()
					} else {
						setTimeout(() => {
							// give time to other users in server
							resolve()
						}, rec.batch_delay_ms)
					}
				}
			})
		})
		await sendPromise
		i = i + sendArr.length
		nc.grid.refereshCells(state, area)
	}
	if (status === 'ok') {
		rec.progress_bar.message = `${activatedArr.length.toLocaleString()} ${records} ${doneVerb}, status: ${status}`
		rec.progress_bar.status = 'success'
	} else {
		rec.progress_bar.status = 'error'
	}
}

function newKeyValue(value, action, newValue, oldValue) {
	const arr = value.split(',')
	const newArr = []
	let someFound = false
	for (let i = 0; i < arr.length; i++) {
		value = peg.cleanBeforeAfterDoubleSpace(arr[i])
		if (value) {
			// not an empty string
			let found
			if (oldValue != null) {
				found = value.toLowerCase() === oldValue.toLowerCase()
			} else {
				found = value.toLowerCase() === newValue.toLowerCase()
			}
			someFound = someFound || found
			if (found && action === 'remove') {
				// newArr.push()
			} else if (found && action === 'modify') {
				newArr.push(newValue)
			} else {
				newArr.push(value)
			}
		}
	}
	if (!someFound && action === 'add') {
		newArr.push(newValue)
	}
	value = newArr.join(', ')
	return value
}

function applyKeyword(action, activatedArr) {
	if (action === 'open') {
		if (rec.table !== 'person' || rec.table_rec_type !== 'person') {
			message.setWarning(state, nc.l('Apply keyword works only in person -table.'))
			return
		}
		if (state.grid.list.options.allow_save !== true) {
			message.setWarning(state, nc.l('Saving is not allowed in this list. Please use other list for saving.'))
			return
		}
		let warn = false
		let data = activatedArr[0].json_data
		if (data == null) {
			warn = true
		} else {
			for (let i = 1; i <= rec.keyword_count; i++) {
				if (typeof data['keyword' + i] !== 'string') {
					warn = true
					break
				}
			}
		}
		if (warn) {
			message.setWarning(
				state,
				nc.l('List must have all keyword fields loaded before applying values. Please use another list for this action.')
			)
			return
		}
		rec.apply.show = 'true' // show dialog
	} else if (action === 'modal-ok') {
		// pressed ok in dialog
		activatedArr = nc.grid.activatedRecordArr(state, area) // activatedArr does not come as parameter
		rec.apply.show = ''
		rec.apply.new_value = peg.cleanBeforeAfterDoubleSpace(rec.apply.new_value)
		rec.apply.old_value = peg.cleanBeforeAfterDoubleSpace(rec.apply.old_value)
		let applyField = peg.parseAfter(rec.apply.field, rec.table_prefix + '.')
		for (const item of activatedArr) {
			const oldValue = nc.recData(item, applyField)
			let newValue
			if (rec.apply.action === 'add') {
				if (oldValue === '') {
					newValue = rec.apply.new_value
				} else {
					newValue = newKeyValue(oldValue, rec.apply.action, rec.apply.new_value)
				}
			} else if (rec.apply.action === 'remove') {
				newValue = newKeyValue(oldValue, rec.apply.action, rec.apply.new_value)
			} else if (rec.apply.action === 'modify') {
				newValue = newKeyValue(oldValue, rec.apply.action, rec.apply.new_value, rec.apply.old_value)
			}
			setChangeRecord(item, applyField, oldValue, newValue)
			nc.recDataSet(item, applyField, newValue)
		}
		nc.grid.refereshCells(state, area)
	} else if (action === 'modal-cancel') {
		rec.apply.show = ''
	}
}

/* function appAction(action) {
			if (action === 'get-action') {
				return [
					{ value: 'add-keyword', show: 'Lisää avainsana...', icon: '' },
					{ value: 'remove-keyword', show: 'Poista avainsana...', icon: '' }
				]
			} else if (action === 'save-list-query') {
				message.setInfo(state, 'Toiminto ei ole vielä valmis')
				// nc.grid.invertActivated(state, area)
				return
			}
			let activatedArr = nc.grid.activatedRecordArr(state, area)
			if (activatedArr.length < 1) {
				message.setInfo(state, nc.l(`Please select rows first`))
				return
			}
		} */

function exportSpreadsheet(arr, fileType) {
	const XLSX = sql.XLSX
	const grid = nc.grid.grid(state, area)
	const useHeaderName = grid.options && grid.options.use_header_name
	const column = grid.column
	const name = (grid.options && grid.options.worksheet_name) || rec.table
	const flatArr = arr.map(item => flatten(item, null, null, true, cleanRecordId(area)))
	const defaultColumnWidth = 150
	const header = {}
	const headerArr = []
	for (let item of column) {
		const fieldName = peg.parseAfter(item.field, rec.table_prefix + '.')
		if (flatArr[0][fieldName] != null) {
			headerArr.push(fieldName)
			header[fieldName] = { name: useHeaderName ? item.name : item.field, width: Math.round(item.width) }
		}
	}
	const workSheet = XLSX.utils.json_to_sheet(flatArr, { header: headerArr })
	workSheet['!cols'] = [] // Cols width array
	// const range = XLSX.utils.decode_range(workSheet['!ref'])
	// see example: https://github.com/LuisEnMarroquin/json-as-xlsx/blob/main/index.ts
	// for (let C = range.s.r; C <= range.e.r; ++C) {
	for (let col = 0; col < headerArr.length; col++) {
		const address = XLSX.utils.encode_col(col) + '1' // <-- first row, column number col
		/* if (workSheet[address] == null) {
					continue
				} */
		const item = header[workSheet[address].v]
		if (item) {
			workSheet[address].v = item.name
			workSheet['!cols'].push({ wpx: item.width })
		} else {
			message.setWarning(state, "export header was not found for column '${workSheet[address].v}'")
			debugger
			workSheet['!cols'].push({ wpx: defaultColumnWidth })
		}
		/* type ColInfo = {
						// visibility
						hidden?: boolean, // if true, the column is hidden

						// column width is specified in one of the following ways:
						wpx?: number, // width in screen pixels
						width?: number, // width in Excel's "Max Digit Width", width*256 is integral
						wch?: number, // width in characters

						// other fields for preserving features from files
						MDW?: number // Excel's "Max Digit Width" unit, always integral
					} */
	}
	const wb = XLSX.utils.book_new()
	XLSX.utils.book_append_sheet(wb, workSheet, name)
	if (fileType === 'xlsx') {
		XLSX.writeFile(wb, name + '.' + fileType, { bookType: 'xlsx', bookSST: true, compression: true })
	} else {
		XLSX.writeFile(wb, name + '.' + fileType)
	}
}

function copyCleanArr(activatedArr) {
	return activatedArr.map(item => {
		item = nc.clone(item)
		delete item.idx
		delete item.db_id
		delete item.db_modify_id
		delete item.record_id
		delete item.modify_id
		// delete item.create_time
		// delete item.modify_time
		// delete item.modify_user
		return item
	})
}
function gridToolSelected(area, action) {
	let activatedArr = nc.grid.activatedRecordArr(state, area)
	if (action === 'activate-all') {
		nc.grid.activateAll(state, area)
		return
	} else if (action === 'deactivate-all') {
		nc.grid.deactivateAll(state, area)
		return
	} else if (action === 'invert-activated') {
		nc.grid.invertActivated(state, area)
		return
	} else if (action === 'paste') {
		if (navigator.clipboard && typeof navigator.clipboard.readText === 'function') {
			navigator.clipboard
				.readText()
				.then(text => {
					addDataToGrid(text)
				})
				.catch(err => {
					message.setWarning(state, `Failed to read clipboard content: ${err.message}`)
				})
		} else {
			message.setWarning(state, `We are sorry, but this browser does not support getting text from clipboard`)
			// const text = window.clipboardData.getData('Text') // old browser
			// addDataToGrid(text)
		}
		return
	} else if (action === 'add') {
		// const dataRec = { [rec.table_prefix]: {} }
		const dataRec = {} // todo: test this
		addDataToGrid([dataRec])
		return
		/* } else if (action === 'import-excel') {
				const el = document.getElementById('import-file')
				el.click() // this does not work, click must be triggered by user interaction
				return */
	}
	// all below need activated array
	if (activatedArr.length < 1) {
		message.setInfo(state, nc.l(`Please select rows first`))
		return
	}
	if (action === 'apply-keyword') {
		applyKeyword('open', activatedArr)
	} else if (action === 'select-activated') {
		nc.grid.removeByArray(state, area, activatedArr, 'not-selected')
		nc.grid.activateAll(state, area)
	} else if (action === 'duplicate') {
		// call rest input/duplicate?
		const arr = copyCleanArr(activatedArr)
		addDataToGrid(arr)
	} else if (action === 'copy') {
		const text = nc.toJson(copyCleanArr(activatedArr))
		copyTextToClipboard(text)
	} else if (action === 'save') {
		if (state.grid.list.options.allow_save !== true) {
			message.setWarning(state, nc.l('Saving is not allowed in this list. Please use other list for saving.'))
			return
		}
		let ok
		if (activatedArr.length === 1) {
			ok = confirm(`Tallenetaanko 1 tietue?`)
		} else {
			ok = confirm(`Tallenetaanko ${activatedArr.length} tietuetta?`)
		}
		if (ok !== true) {
			return
		}
		sendRecs(activatedArr, action, 'Save', 'Saving', 'saved')
	} else if (action === 'delete') {
		if (state.grid.list.options.allow_delete !== true) {
			message.setWarning(state, nc.l('Deleting is not allowed in this list. Please use other list for deleting.'))
			return
		}
		let ok
		if (activatedArr.length === 1) {
			ok = confirm(`Tuhotaanko 1 tietue?`)
		} else {
			ok = confirm(`Tuhotaanko ${activatedArr.length} tietuetta?`)
		}
		if (ok !== true) {
			return
		}
		const newArr = activatedArr.filter(item => !(item && item.record_id))
		if (newArr.length > 0) {
			nc.grid.removeByArray(state, area, newArr)
		}
		if (newArr.length < activatedArr.length) {
			const deleteArr = activatedArr.filter(item => item && item.record_id)
			sendRecs(deleteArr, action, 'Delete', 'Deleting', 'deleted')
		}
	} else if (action === 'copy-tsv') {
		const flatArr = activatedArr.map(item => flatten(item, null, null, true, cleanRecordId(area)))
		const workSheet = sql.XLSX.utils.json_to_sheet(flatArr)
		const text = sql.XLSX.utils.sheet_to_csv(workSheet, { FS: '\t' })
		// const text = nc.toJson(flatArr)
		copyTextToClipboard(text)
	} else if (action === 'export-excel') {
		exportSpreadsheet(activatedArr, 'xlsx')
	} else if (action === 'export-csv') {
		exportSpreadsheet(activatedArr, 'csv')
	} else if (action === 'export-tsv') {
		const flatArr = activatedArr.map(item => flatten(item, null, null, true, cleanRecordId(area)))
		sql
			.promise(`SELECT * INTO TSV("${rec.table}.tsv") FROM ?`, [flatArr])
			.then(function () {
				// message.setInfo(state, `Save to TSV ${rec.table}.tsv was successful`)
			})
			.catch(function (err) {
				message.setWarning(state, `Save to TSV error: ${err.message}`)
			})
	}
}

function gridContextMenu(area, event) {
	let activatedArr = nc.grid.activatedRecordArr(state, area)
	console.debug('gridContextMenu', area, event, activatedArr)
	// event.preventDefault()
}

function setListDataRec(listDataRec) {
	if (listDataRec) {
		rec.row_index = listDataRec.idx // not js 0-based but 1-based
		rec.start_row_index = rec.row_index // not js 0-based but 1-based
		if (nc.grid.getFirstDisplayedRow) {
			rec.first_displayed_row = nc.grid.getFirstDisplayedRow(state, area)
		} else {
			rec.first_displayed_row = 0
		}
		if (rec.first_displayed_row > 0) {
			rec.first_displayed_row += 11 // some bug in ag-grid?
		}
		if (listDataRec) {
			rec.record_id = listDataRec.record_id
			if (rec.record_id == null) {
				rec.record_id = listDataRec[`record_id${recordTypeSeparator}${rec.record_type || listDataRec.record_type}`]
			}
		} else {
			rec.record_id = null
		}
	}
}

function getEventData(event) {
	return event.data || event.detail.model // event.data for ag-grid and event.detail.model for revogrid
}

function gridRowClicked(area, rowIndex, selected, event) {
	if (selected) {
		setListDataRec(getEventData(event))
	}
	// let activatedArr = nc.grid.activatedRecordArr(state, area)
	// console.debug('gridRowClicked', area, rowIndex, selected, event, activatedArr)
}

function gridRowDoubleClicked(area, rowIndex, event) {
	nc.grid.stopEditing(state, area, event, true)
	nc.grid.activateRows(state, area, rowIndex + 1, false) // no-scroll
	setListDataRec(getEventData(event))
	if (rec.record_id == null) {
		message.setWarning(state, `Selected array item does not contain record_id -field, table prefix: '${rec.table_prefix}'`)
	} else {
		delete rec.return
		/* for (var key in listDataRec) {
							// copy all subkeys for input
							if (nc.isObject(listDataRec[key])) {
								// if (key === listRec.table_prefix) {
								rec[key] = nc.clone(listDataRec[key])
							}
						} */
		nc.gotoUrl(state, 'input') // dynamic component will make rest call and create input components: nc-input-form and table's input page
	}
}

function findOrigRecIndex(data, recordId) {
	for (let i = 0; i < data.length; i++) {
		if (data[i].record_id === recordId) {
			return i
		}
	}
	return -1
}

function setKey(gridData, newRec, oldRec, oldRecIdx, keyStart) {
	for (const key of Object.keys(newRec)) {
		if (key !== 'record_id') {
			const newValue = newRec[key]
			if (nc.isObject(newValue)) {
				if (oldRec[key] == null) {
					oldRec[key] = {}
				}
				setKey(gridData, newValue, oldRec[key], oldRecIdx, key + '.')
			} else if (nc.isArray(newValue)) {
				if (oldRec[key] == null) {
					oldRec[key] = []
				}
				setKey(gridData, newValue, oldRec[key], oldRecIdx, key + '.')
			} else {
				setChangeRecord(gridData[oldRecIdx], keyStart + key, oldRec[key], newValue)
				oldRec[key] = newValue
			}
		}
	}
}

function addDataToGrid(data, fileName) {
	if (!nc.isArray(state.grid.list.data)) {
		console.warn('state.grid.list.data is not an array')
		return
	}
	if (fileName) {
		rec.progress_bar.message = `Creating rows from file '${fileName}'...`
	}
	if (typeof data === 'string' && data.length === 0) {
		message.setWarning(state, `No data to paste`)
	} else if (typeof data === 'string') {
		try {
			data = JSON.parse(data)
		} catch (error) {
			message.setWarning(state, `Failed to parse text content to json: ${error.message}, data: '${data.substring(0, 300)}'`)
			return
		}
	}
	const recDataSet = nc.recDataSet // cache value for loop
	let length = state.grid.list.data.length
	let i = 0
	const selectIdx = []
	const percent = rec.progress_bar.percent
	const multiply = 100 - percent
	state.new_record = state.new_record || []
	const gridData = state.grid.list.data
	const tablePrefix = state.rec.table_prefix + '.'
	for (const item of data) {
		let addRec = {}
		let oldRecIdx = -1
		for (const key of Object.keys(item)) {
			if (typeof item[key] === 'string' && peg.endsWith(key, 'json_data')) {
				item[key] = JSON.parse(item[key])
			}
			let toKey = peg.parseAfterStart(key, tablePrefix)
			recDataSet(addRec, toKey, item[key])
		}
		if (!addRec) {
			i++
		} else {
			if (addRec.record_id) {
				// update old record
				oldRecIdx = findOrigRecIndex(gridData, addRec.record_id)
				if (oldRecIdx >= 0) {
					if (typeof addRec.json_data === 'string') {
						addRec.json_data = JSON.parse(addRec.json_data)
					}
					if (typeof gridData[oldRecIdx].json_data === 'string') {
						gridData[oldRecIdx].json_data = JSON.parse(gridData[oldRecIdx].json_data)
					}
					setKey(gridData, addRec, gridData[oldRecIdx], oldRecIdx, '')
					selectIdx.push(oldRecIdx + 1)
				}
			}
			i++
			if (oldRecIdx < 0) {
				// add a new record
				cleanNewRecord(addRec)
				addRec.idx = length + i // idx is on screen, 1-based
				setNewChangeRecord(gridData, addRec, i)
				gridData.splice(i - 1, 0, addRec) // add to start of list. 0-based
				state.new_record.push(addRec)
				selectIdx.push(length + i) // selectIdx is 1-based
			}
		}
		if (fileName) rec.progress_bar.percent = percent + Math.round((i / data.length) * multiply)
	}
	setTabCount()
	nc.setGrid(state, area, Object.assign({}, state.grid.list))
	setTimeout(() => {
		nc.grid.activateRows(state, area, selectIdx, 'scroll-first', 'unselectOther')
		if (fileName) {
			rec.progress_bar.message = `Created ${data.length} rows from file '${fileName}'`
			rec.progress_bar.status = 'success'
		}
		// message.setInfo(state, msg)
	}, 250)
}

function importFile(fileName, data) {
	// message.setInfo(state, `Import from file '${fileName}' was successful, imported ${data.length} rows`)
	rec.progress_bar.percent += 40
	// rec.progress_bar.message = `Import from file '${fileName}' was successful, imported ${data.length} rows`
	setTimeout(() => {
		// give first message time to show
		debugger
		addDataToGrid(data, fileName)
	}, 100)
}

function setGridStyle(arrLength, remove) {
	const queryEm = (arrLength - 1) * 2.7 + 14.5 // 2.9
	gridStyle.value = `width: 100%; min-height: 4.4em; height: calc(100vh - ${queryEm}em)`
	if (remove) {
		gridStyle.value += '; transition: height 0.001s' // ease-in
	}
}

function setQueryDropdown(index, value) {
	let queryArr = arr.query_dropdown_field && nc.recData(arr.query_dropdown_field, value)
	if (nc.isArray(queryArr) && queryArr.length > 0) {
		queryArr = nc.clone(queryArr)
		arr.query_dropdown = queryArr
		arr.query[rec.table][index].query_dropdown = queryArr
		arr.query[rec.table][index].query_value1 = ''
		arr.query[rec.table][index].query_value2 = ''
	} else {
		delete arr.query[rec.table][index].query_dropdown
	}
	arr.query[rec.table][index].operator = arr.defalut_query[0].operator
}

function setQueryItem(key, index, value) {
	if (typeof value === 'object' && value.target) {
		value = value.target.value // value is event
	}
	const queryRec = arr.query[rec.table][index]
	queryRec[key] = value
	if (key === 'field' && rec.field !== value) {
		rec.field = value
		setQueryDropdown(index, value)
	}
}

function addQueryRow(index) {
	const addRec = nc.clone(arr.query[rec.table][index])
	if (addRec.selection_type === 'new') {
		addRec.selection_type = rec.new_selection_type
	}
	setGridStyle(arr.query[rec.table].length + 1)
	index++
	arr.query[rec.table].splice(index, 0, addRec)
}

function removeQueryRow(index) {
	if (!nc.isArray(arr.query[rec.table])) {
		console.warn('arr.query[rec.table] is not an array')
		return
	}
	if (index < 1 && arr.query[rec.table].length === 1) {
		arr.query[rec.table][0].query_value1 = ''
		arr.query[rec.table][0].query_value2 = ''
		arr.query[rec.table][0].field = arr.defalut_query[0].field
		setQueryDropdown(index, '')
	} else {
		arr.query[rec.table].splice(index, 1)
		setTimeout(() => {
			setGridStyle(arr.query[rec.table].length, 'remove')
		}, 210) // NOTE: 200ms = 0.2s of nc-fade-fast transition, + x ms to be just after query row removal transition
	}
	if (arr.query[rec.table][0].selection_type !== 'new') {
		arr.query[rec.table][0].selection_type = 'new'
	}
}

function gridCellKeyDown(area, rowIndex, event) {
	if (!event.event) {
		gridRowDoubleClicked(area, rowIndex, event)
	} else {
		const cmdOrCtrlKey = event.event && nc.isMac() ? event.event.metaKey : event.event.ctrlKey
		if (event.event.key === 'Enter' && cmdOrCtrlKey === true) {
			gridRowDoubleClicked(area, rowIndex, event)
			// event.event.preventDefault()// these do
			// event.event.stopPropagation()
		}
	}
}

function gridCellValueChanged(area, node, data, newValue, oldValue, colId, rowIndex) {
	const gridData = state.grid.list.data
	setNewChangeRecord(gridData, data, rowIndex) // need to set value before cleaned
	if (typeof newValue === 'string') {
		const cleaned = peg.cleanBeforeAfterDoubleSpace(newValue)
		if (cleaned !== newValue) {
			newValue = cleaned
			nc.setRecData(data, colId, newValue)
			setNewChangeRecord(gridData, data, rowIndex)
		}
	}
	setChangeRecord(data, colId, oldValue, newValue)
	nc.grid.refereshCells(state, area, node)
	// state.grid.list.data[rowIndex] = data

	/* 	const origValue = nc.recData(loadedRec, fieldName)
			if (origValue !== newValue) {
				nc.recDataSet(changeRecord.value, fieldName, newValue)
			} else {
				const clearEmptySubkeyLevel = 2 // tbl.json_data.xxx
				nc.recDataSet(changeRecord.value, fieldName, undefined, clearEmptySubkeyLevel)
			}
			const tblRec = changeRecord.value
			saveEnabled.value = tblRec && !nc.isEmptyObject(tblRec)
			mainState.input.save_enabled = saveEnabled.value */
}
