# Help

For questions, feature discussions, and suggestions about including binary modules, please use the the maillist or the IRC channel as described in the [community section](http://studio.zerobrane.com/community) of the project website.

# Bugs

When filing a bug, please help us reproduce the issue by including the following information:

* Steps to reproduce the issue as well as the expected result. Screenshots also help.
* Your operating system and the IDE version (or the latest commit if you are using the development version).
* Any relevant configuration from the config file, if you cannot reproduce the issue with an empty config.
* Any relevant plugins, if you cannot reproduce the issue without plugins.

It always helps to make sure that the issue is still reproducible with the most recent version of the IDE.

If you think that the issue is with the *debugger* (this also includes serialization issues), then open an issue in the [MobDebug repository](https://github.com/pkulchenko/MobDebug/issues).
If the issue is with one of the *plugins*, then open an issue in the [ZeroBranePackage repository](https://github.com/pkulchenko/ZeroBranePackage/issues).

# Contributing

_By contributing to ZeroBrane Studio you are agreeing to release your contribution under the MIT License._

Thank you for contributing to ZeroBrane Studio! Here are some things you can do to improve it:

* **Fixing issues**: If you have ideas or suggestions on [fixing existing issues](https://github.com/pkulchenko/ZeroBraneStudio/issues), please update the tickets directly or send a pull request.
* **Adding translations**: See [translation documentation](http://studio.zerobrane.com/doc-translation) for details.
* **Implementing new features**: Please [discuss with us](http://studio.zerobrane.com/community) any significant changes you plan as early as possible.
Try to implement the changes as a plugin first; the project already provides [plugin API](http://studio.zerobrane.com/doc-plugin) with more than [45 plugins](https://github.com/pkulchenko/ZeroBranePackage) already available.
* **Improving documentation**: All the existing documentation is generated based on pages in [gh-pages branch](https://github.com/pkulchenko/ZeroBraneStudio/tree/gh-pages). You can provide clarifications, check the documentation for errors/typos, or fill any gaps.
* **Spreading the word**!
