// public/nc-plugin.js

import { n as nc } from './nc-util.js'
import { r as rest } from './nc-rest.js'
import { p as peg } from './nc-peg.js'
import { d as dt } from './nc-dt.js'
import { m as message } from './nc-message.js'
import { m as mainState, n as newState } from './nc-state.js'
import { l } from './nc-lang.js'
import { s as session } from './nc-session.js'
import auth from './nc-auth.js'
import { g as gotoUrl } from './nc-router.js'
import { a as addComponent, u as updateDynamicComponent } from './nc-main.js'
import { i as importFile, s as setChangeRecord, a as setNewChangeRecord } from './nc-grid-menu.js'

// ------ copy code from below to /src/core/nc-plugin.js  ------

console.debug('* lazy imported nc-plugin')
export { dt, message, nc, peg }

nc.mainState = mainState
nc.newState = newState
nc.l = l
nc.isDesigner = auth.isDesigner
nc.isAdmin = auth.isAdmin

nc.callServer = rest.callServer
nc.saveRecord = rest.saveRecord
nc.deleteRecord = rest.deleteRecord
nc.saveArray = rest.saveArray
nc.deleteArray = rest.deleteArray
nc.gotoUrl = gotoUrl
nc.getParam = session.getParam
nc.setParam = session.setParam
nc.gridImportFile = importFile
nc.setChangeRecord = setChangeRecord
nc.gridSetNewChangeRecord = setNewChangeRecord

nc.updateDynamicComponent = updateDynamicComponent
nc.addImportedComponent = function addImportedComponent(comp) {
	// remove later
	if (comp.error) {
		message.setWarning(null, comp.error)
	} else {
		addComponent(comp)
	}
}

nc.addCss = function (state, cssText) {
	if (!cssText) {
		message.setWarning(state, `addCss: css text is missing`)
		return
	}
	const el = state.el || document.getElementById(state.owner) // || state.form
	if (!el) {
		message.setWarning(state, `addCss: owner ${state.owner} element id was not found`)
		return
	}
	const sheet = document.createElement('style')
	sheet.innerHTML = cssText
	el.prepend(sheet)
}

nc.round = function (num, decimals, showTrailingZero, suffixTxt, nullTxt) {
	let amount, decimalPower
	if (num !== 0 && (!num || num === void 0 || typeof num !== 'number')) {
		if (!nc.isNil(nullTxt)) {
			return nullTxt
		}
		return num
	}
	if (nc.isFinite(num)) {
		if (showTrailingZero) {
			amount = num.toFixed(decimals)
			if (!nc.isNil(suffixTxt)) {
				return amount + suffixTxt
			}
			return amount
		}
		if (typeof decimals === typeof 'undefined') {
			decimals = 0
		}
		decimalPower = Math.pow(10, decimals)
		amount = Math.round(parseFloat(num) * decimalPower) / decimalPower
		if (!nc.isNil(suffixTxt)) {
			return amount + suffixTxt
		}
		return amount
	}
	if (!nc.isNil(nullTxt)) {
		return nullTxt
	} else if (!nc.isNil(suffixTxt)) {
		return num + suffixTxt
	}
	return num // "" # NaN
}

nc.findCaseInsensitiveRecFromArr = function (arr, recordIdFldName, recordValue, defaultValue) {
	if (recordValue == null) {
		return null
	}
	recordValue = recordValue.toLowerCase()
	let recVal
	for (const rec of arr) {
		recVal = nc.recData(rec, recordIdFldName)
		if (!nc.isNil(recVal) && recVal.toLowerCase() === recordValue) {
			return rec
		}
	}
	// test optional defaultValue
	if (defaultValue != null) {
		for (const rec of arr) {
			recVal = nc.recData(rec, recordIdFldName)
			if (!nc.isNil(recVal) && recVal.toLowerCase() === defaultValue) {
				return rec
			}
		}
	}
	return null
}

nc.update = function update(action) {
	if (action != null) {
		nc.callServer(state, 'query', { name: `${state.path}/${action}.json` })
	} else {
		nc.callServer(state, 'query', { name: `${state.path}/init.json` })
	}
}

/*
// we can't use this function because vite rewrites imports and it causes them to fail
nc.importPath = async function (path) {
	// const url = window.location.protocol + `//` + window.location.host + '/plugin/' + path + '.js'
	const url = '/plugin/' + path + '.js'
	let comp = await import(/* @vite-ignore * / url)
		.then(mod => {
			return mod.default
		})
		.catch(err => {
			return { error: err.message }
		})
	if (comp.error) {
		message.setWarning(null, comp.error)
	} else {
		// comp = comp.default
		updateDynamicComponent(comp, false) // addComponent(comp)
	}
	return comp
}
*/
