// /public/sw.js
// see: https://stackoverflow.com/questions/40100922/activate-updated-service-worker-on-refresh
// https://developers.google.com/web/ilt/pwa/caching-files-with-service-worker

// eslint-disable-next-line no-undef
/* importScripts('./nats.js') // import { connect as natsConnect } from './nats.js' // Firefox does not support import is sw
function testNats() {
	console.debug('NATS connect:', typeof connect)
} */
const CACHE_NAME = 'v005'
const DEV_MODE = 1 // 4 is all messages
const componentCache = {}
const fileTypeToCache = {}
// const fileTypeToCacheArr = ['js', 'css', 'png', 'jpg', 'jpeg', 'gif', 'svg', 'woff', 'woff2', 'ttf', 'eot', 'otf', 'ico']
const fileTypeToCacheArr = ['js', 'css', 'png', 'jpg', 'jpeg', 'gif', 'svg', 'woff', 'woff2', 'ttf', 'eot', 'otf', 'ico']
for (const key of fileTypeToCacheArr) {
	fileTypeToCache[key] = true
}
let openedCache
let cacheOpenState = false

function isSafari() {
	return navigator.userAgent.indexOf('Safari') > -1 && navigator.userAgent.indexOf('Chrome') === -1
}

function isFirefox() {
	return navigator.userAgent.indexOf('Firefox') > -1
}

if (isSafari() || isFirefox()) {
	const debugOrig = console.debug
	const warnOrig = console.warn
	console.debug = (...args) => {
		debugOrig.apply(null, args)
		postMessage({ type: 'debug', args })
	}
	console.warn = (...args) => {
		warnOrig.apply(null, args)
		postMessage({ type: 'warn', args })
	}
}

function parseAfter(subjectString, separator) {
	const pos = subjectString.indexOf(separator)
	if (pos >= 0) {
		return subjectString.substring(pos + separator.length)
	}
	return subjectString
}
function endsWith(subjectString, endString) {
	return subjectString.substring(subjectString.length - endString.length) === endString
}
function postMessage(msg) {
	self.clients.matchAll({ includeUncontrolled: true, type: 'window' }).then(clients => {
		if (clients && clients.length > 0) {
			// you need to decide which clients you want to send the message to, we use only first
			const client = clients[0]
			const msg2 = JSON.parse(JSON.stringify(msg)) // prevent DOMException: Failed to execute 'postMessage' on 'Client': Response object could not be cloned.
			client.postMessage(msg2)
		}
	})
}

async function deleteKey(keyList) {
	console.debug(`•• service-worker activate: delete all cache keys, keyList`, keyList)
	const ret = await Promise.allSettled(
		keyList.map(key => {
			// if (key !== CACHE_NAME) {
			console.debug(`•• service-worker activate: deleted cache key '${key}'`)
			return caches.delete(key)
			// }
		})
	)
	ret.map(item => {
		if (item.status === 'rejected') {
			console.error(`•• service-worker activate: delete cache key FAILED, reason: `, item.reason)
		}
	})
}
async function deleteKeyList() {
	// `•• service-worker: activate, self.clients.claim() and delete old cache keys not equal to '${CACHE_NAME}'`
	await caches.keys().then(keyList => {
		deleteKey(keyList)
	})
}

async function activate(event) {
	await event.waitUntil(self.clients.claim())
	/* self.registration
	.unregister()
	.then(function () {
		return self.clients.matchAll()
	})
	.then(function (clients) {
		clients.forEach(client => {
			console.debug(`•• service-worker activate: unregister, reload client.url '${client.url}'`)
			client.navigate(client.url)
		})
	}) */
	if (navigator.onLine) {
		await event.waitUntil(deleteKeyList())
	}
	await event.waitUntil(openCache())
}

self.addEventListener('activate', async event => {
	console.debug(`•• service-worker activate start`)
	await event.waitUntil(activate(event)) // this does not wait for caches to actually open
	// console.debug(`•• service-worker activate done`)
})

async function openCache() {
	const ret = await caches
		.open(CACHE_NAME)
		.then(cache => {
			// testNats() // todo: remove this
			openedCache = cache
			return openedCache
				.keys()
				.then(keys => {
					console.debug(`•• service-worker: caches.open '${CACHE_NAME}', keys`, keys)
					postMessage({ type: 'activate', result: 'ok' })
				})
				.catch(error => {
					console.error(`•• service-worker: caches.open '${CACHE_NAME}' keys error`, error)
					postMessage({ type: 'activate', result: error })
				})

			/* 	return cache.addAll([
				'/src/cache-test/import.js'
			]) */
		})
		.catch(error => {
			console.error(`•• service-worker: caches.open error`, error)
		})
	return ret
}

self.addEventListener('install', async event => {
	await event.waitUntil(self.skipWaiting())
	console.debug(`•• service-worker: install done`)
})

const replaceAssets = new RegExp('/assets/', 'g')
async function componentResponse(event, response) {
	const ret = await response.clone().json()
	// console.debug(`🚀 ~ file: sw.js ~ line 93 ~ componentResponse ~ ret`, ret)
	if (ret.include) {
		const baseUrl = event.request.url.substring(0, event.request.url.indexOf('/rest/nc/')) + '/plugin/'
		for (const item of ret.include) {
			const url = baseUrl + item.path
			componentCache[url] = item.path
			const newRequest = new Request(url)
			let js
			if (event.request.url.search('localhost:8080') > -1 || event.request.url.search('dev.nadacode.com') > -1 || event.request.url.search('home.stuta.dev:8080') > -1) {
				js = item.js.replace(replaceAssets, '/src/core/')
			}
			const newResponse = new Response(js || item.js, { headers: { 'Content-Type': 'text/javascript' } })
			openedCache.put(newRequest, newResponse)
			if (DEV_MODE > 0) {
				console.debug(`•••• service-worker: ADD TO CACHE ${url}, ${Math.floor((item.js.length / 1024) * 10) / 10} Kb`)
			}
		}
	}
	return response
}

function fetchResponse(event, response) {
	if (response.ok === false && response.status === 504) {
		// 504 = Gateway Timeout
		if (event.request.url.search('.vite/deps') > -1) {
			console.error(`•• service-worker: .vite/deps fetch FAILED ${event.request.url}, response`, response)
			debugger
			removeServiceWorker() /* () => {
				window.location.reload()
			}) */
			return response
		}
	}
	if (response.ok === false && response.status !== 304) {
		// 304 = Not Modified
		console.error(`•• service-worker: fetch FAILED ${event.request.url}, response`, response)
		return response
	}
	// console.debug(`🚀 ~ file: sw.js ~ line 153 ~ fetchResponse ~ fileType`, fileType, event.request.url)
	if (endsWith(event.request.url, '/rest/nc/import/component') || endsWith(event.request.url, '/rest/nc/input')) {
		return componentResponse(event, response)
	}
	const fileType = parseAfter(event.request.url, '.')
	if (event.request.method === 'GET' && event.request.url.indexOf('?') === -1 && fileTypeToCache[fileType] && event.request.url.substring(0, 4) === 'http') {
		// skip chrome extensions do not start with 'http'
		if (DEV_MODE > 3) {
			console.debug(`••• service-worker: fetch ok, cached ${event.request.url}, response: `, response)
		} else if (DEV_MODE > 2) {
			console.debug(`••• service-worker: fetch ok, cached ${event.request.url}`)
		}
		openedCache.put(event.request, response.clone())
	} else {
		if (DEV_MODE > 3) {
			console.debug(
				`•• service-worker: fetch ok, not cached ${event.request.url}, status: ${response.status} ${response.statusText}` // example: status: 200 OK
			)
		}
	}
	return response
}

self.addEventListener('fetch', async event => {
	if (event.request.url.search('vite') > -1 || event.request.url.search('.vue') > -1) {
		if (DEV_MODE > 1) {
			console.debug(`•••• service-worker: direct dev request: ${event.request.url}`)
		}
		return fetch(event.request) // must not be event.request.url because request may be PUSH, not GET
			.then(fetchRes => {
				return fetchResponse(event, fetchRes)
			})
			.catch(error => {
				console.warn(`•• service-worker: direct dev request fetch ERROR ${event.request.url}, error`, error)
				return
			})
	}
	if (!openedCache && cacheOpenState === false) {
		console.debug(`••• service-worker: fetch -event, openCache`)
		await openCache()
		cacheOpenState = true
	}
	if (openedCache) {
		const match = openedCache.match(event.request)
		return event.respondWith(
			match
				.then(response => {
					if (response) {
						// https://stackoverflow.com/questions/56654119/how-do-you-set-the-url-when-creating-a-new-response
						// Object.defineProperty(response, 'url', { value: event.request.url })
						if (DEV_MODE > 0 && componentCache[event.request.url]) {
							console.debug(`••• service-worker: SERVED COMPONENT FROM CACHE ${event.request.url}`)
						} else if (DEV_MODE > 1) {
							console.debug(`••• service-worker: SERVED FROM CACHE ${event.request.url}`)
						}
						return response
					} else {
						return fetch(event.request) // must not be event.request.url because request may be PUSH, not GET
							.then(fetchRes => {
								return fetchResponse(event, fetchRes)
							})
							.catch(error => {
								console.error(`•• service-worker: fetch ERROR ${event.request.url}, error`, error)
								return
							})
					}
				})
				.catch(error => {
					console.error(`•• service-worker: event.respondWith match ERROR ${event.request.url}, error`, error)
					return
				})
		)
	}
	// fallback method 'Cache falling back to the network'
	console.warn(`•• XXX XXX service-worker: XXX XXX, fetch ${event.request.url}`)
	return event.respondWith(
		caches.match(event.request).then(response => {
			if (response) {
				console.debug(`•• XXX XXX service-worker: XXX XXX, SERVED FROM CACHE ${event.request.url}`)
				return response
			}
			return fetch(event.request)
				.then(fetchRes => {
					return fetchResponse(event, fetchRes)
				})
				.catch(error => {
					console.error(`•• XXX XXX service-worker: fetch ERROR ${event.request.url}, error`, error)
					return
				})
		})
	)
})

function removeServiceWorker() {
	self.registration
		.unregister()
		.then(function () {
			return self.clients.matchAll()
		})
		.then(function (clients) {
			clients.forEach(client => client.navigate(client.url))
		})
}

/*

function installServiceWorker(logPrefix) {
	logPrefix = logPrefix || '* '
	navigator.serviceWorker.addEventListener('message', function (event) {
		// sw.js will use this posted message only in Safari because Safari does not show console.xxx messages in main window
		if (event.data.type === 'debug') {
			console.debug.apply(null, event.data.args)
		} else if (event.data.type === 'warn') {
			console.warn.apply(null, event.data.args)
		} else {
			console.error('unknown event.data.type', event.data)
		}
	})
	let serviceWorkerPath = '/sw.js'
	if (window.location.pathname.substring(0, 4) === '/nw/') {
		serviceWorkerPath = '/nw/sw.js'
	} else if (window.location.pathname.substring(0, 4) === '/nc/') {
		serviceWorkerPath = '/nc/sw.js'
	}
	navigator.serviceWorker
		.register(serviceWorkerPath) // , { type: 'module' } // Firefox does not support import is sw
		.then(function (registration) {
			registration.update()
			// console.debug('•• service worker, registration successful, scope', registration.scope)
			const reloaded = session.getLocalData('reloaded')
			if (reloaded) {
				session.deleteLocalData('reloaded')
				console.debug('•• service worker has been reloaded, scope', registration.scope)
			} /* else {
					session.setLocalData('reloaded', true)
					setTimeout(() => {
						window.location.reload()
					}, 100)
				} * /
		})
		.catch(function (error) {
			const err = logPrefix + `service worker registration FAILED, error: ${error}`
			console.error(err)
			alert(err)
		})
}
*/
