function _optionalChain(ops) {
	let lastAccessLHS = undefined
	let value = ops[0]
	let i = 1
	while (i < ops.length) {
		const op = ops[i]
		const fn = ops[i + 1]
		i += 2
		if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
			return undefined
		}
		if (op === 'access' || op === 'optionalAccess') {
			lastAccessLHS = value
			value = fn(value)
		} else if (op === 'call' || op === 'optionalCall') {
			value = fn((...args) => value.call(lastAccessLHS, ...args))
			lastAccessLHS = undefined
		}
	}
	return value
}
import { defineComponent, h } from 'vue'

const createPDFComponent = tag =>
	defineComponent({
		name: tag,
		inheritAttrs: false,
		render() {
			return h(
				tag,
				this.$attrs,
				_optionalChain([this, 'access', _ => _.$slots, 'optionalAccess', _2 => _2.default, 'optionalCall', _3 => _3()]) || []
			)
		}
	})

export const View = createPDFComponent('View')
export const Text = createPDFComponent('Text')
export const image = createPDFComponent('image')
export const Document = createPDFComponent('Document')
