// This is the most low level node.

import { defaults } from './styling.js'
let id = 0
// Eg Text is a PDFNode. PDFNode does not have children.
export class PDFNode {
	constructor() {
		this.id = id // (Math.random() * 10000).toFixed(0)
		id++
		this.styles = {}
	}
	get parent() {
		if (!this._parent) {
			throw Error(`No parent found for node #${this.id}`)
		}
		return this._parent
	}
}

export class PDFTextNode extends PDFNode {
	constructor(value) {
		super()
		this.value = value
	}
}

// PDFElement is the main class of Elements you will use.
// The difference between PDFNode and PDFElement is PDFElements can have children.
export class PDFElement extends PDFNode {
	constructor(tag) {
		super()
		this.children = []
		this.tag = tag
	}
}

export class PDFDocumentElement extends PDFElement {
	constructor(tag, options) {
		super(tag)
		this.id = 'root'
		this.styles = { ...defaults }
		this.filename = options.filename
	}
}

export class PDFImageElement extends PDFElement {
	constructor(...args) {
		super(...args)
		this._src = ''
	}
	get src() {
		if (this._src === '') {
			throw Error(`src must be set to use <image>`)
		}
		return this._src
	}
}

export class PDFTextElement extends PDFElement {}
export class PDFViewElement extends PDFElement {}
