// plugin/vue-renderer/index.js

import fs from 'fs'
import { defineComponent, compile } from 'vue'
import { PDFDocumentElement } from './elements.js'
import { Text, View, image } from './components.js'
import { createApp } from './renderer.js'
const html = fs.readFileSync('./form2.html', 'utf8')

const styles = {
	header: {
		align: 'center'
	},
	title: {
		fontSize: 30
	},
	author: {
		fontSize: 15
	},
	text: {
		fontSize: 10,
		marginTop: 1
	},
	image: {
		align: 'center',
		marginTop: 2,
		marginBottom: 2
	}
}

const App = defineComponent({
	components: { Text, View, image },
	setup() {
		return {
			colors: ['red', 'blue', 'green'],
			styles
		}
	},
	render: compile(`${html}`)
})

const app = createApp(App)
app.mount(new PDFDocumentElement('Document', { filename: './file.pdf' }))
