// /src/components/nc-input/nc-translate.js
// import '/src/components/nc-input/nc-input.vue' // need '/src/lib/fomantic-ui/dist/components/label.css'
// import { rowColStyle } from '/src/components/nc-form-col-row.js'

export default function createComponent(name) {
	// export default function createComponent(name, defaultWidth) {
	return {
		name: name,
		inject: ['state'],
		props: {
			model: {
				type: String,
				default: undefined,
				required: false // unlike elsewhere model is not required
			},
			hdr: {
				type: String,
				default: undefined,
				required: false
			},
			width: {
				type: String,
				default: undefined,
				required: false
			},
			height: {
				type: String,
				default: undefined,
				required: false
			}
		},
		data() {
			return { calculatedStyle: '' }
		},
		computed: {
			langLabel(vm) {
				if (!vm) {
					console.error('nc-translate component vm is missing')
					return
				}
				if (vm.model || vm.hdr) {
					let data = vm.state
					if (!data) {
						console.error('nc-translate component state is missing')
						return
					}
					if (!data.hdr) {
						console.warn('nc-translate component hdr is missing')
						return
					}
					let hdr = data.hdr
					const model = vm.hdr || vm.model
					let arr = model.split('.')
					/* if (arr[0] === 'rec') {
						console.error(`nc-translate starts with 'rec', model '${vm.model}'`, this)
						hdr = data.rec
					} else */
					if (arr[0] !== 'hdr' && arr[0] !== 'rec') {
						return null
					}
					arr.shift() // remove first element "hdr" or "rec"
					for (let i = 0; i < arr.length; i++) {
						let key = arr[i]
						if (hdr && hdr[key] == null) {
							let pos1 = key.indexOf('[')
							if (pos1 >= 0) {
								let pos2 = key.indexOf(']')
								let index = key.substring(pos1 + 1, pos2)
								index = parseInt(index)
								let hdr2 = null
								if (index >= 0) {
									let key2 = key.substring(0, pos1)
									let hdr2 = hdr[key2] && hdr[key2][index]
									if (typeof hdr2 === 'string') {
										hdr = hdr2
										console.debug('indexed header was found: ' + vm.model + ' = ' + hdr)
									} else {
										hdr2 = null
									}
								}
								if (!hdr2) {
									console.warn('indexed header was not found: ' + vm.model)
									return null
								}
							}
						} else if (typeof hdr === 'object') {
							hdr = hdr[key]
						}
					}
					if (typeof hdr === 'string') {
						return hdr || ' ' // problem with '' being same as null in js if-clause, so return ' ' if hdr is ''
					}
					return null
				}
			}
		},
		created() {
			// this.calculatedStyle = rowColStyle(this, defaultWidth) // true == set default width:100%;
			this.styleClass = name
			if (this.disabled) {
				this.styleClass = this.styleClass + ' nc-disabled'
			}
			if (name === 'nc-translate') {
				this.styleClass = 'nc-translate-vue'
			}
		}
	}
}
