// node is the most low level node.

// import { defaultStyle } from './styling.js'
let idx = 0
// Eg Text is a createNode. createNode does not have children.
function createNode() {
	const node = {
		idx: idx
		// style: {} // this tag will be generated when needed
	}
	idx++
	return node
}

export function newTextNode(value) {
	const node = createNode()
	node.value = value
	node.tag = 'content'
	return node
}

// Element is the main function of Elements you will use.
// The difference between Node and Element is Elements can have children.
export function newElement(tag) {
	const node = createNode()
	node.children = []
	node.tag = tag
	return node
}

export function newDocument(options) {
	const node = newElement('Document')
	if (node.idx !== 0) {
		console.error(`Document idx '${node.idx}' is not 0`)
	}
	//  node.style = defaultStyle // { ...defaultStyle } // clones defaultStyle
	node.filename = options.filename
	return node
}
