// plugin/vue-renderer/renderer/styling.js

export const styleRules = ['align', 'color', 'fontSize', 'marginBottom', 'marginTop']

export const defaultStyle = {
	align: 'left',
	color: 'black',
	fontSize: 12,
	marginBottom: 0,
	marginTop: 0
}

export const appStyle = {
	header: {
		align: 'center'
	},
	title: {
		fontSize: 30
	},
	author: {
		fontSize: 15
	},
	text: {
		fontSize: 10,
		marginTop: 1
	},
	image: {
		align: 'center',
		marginTop: 2,
		marginBottom: 2
	}
}

export function getStyleValue(rule, node, nodeMap) {
	if (node == null) {
		return
	}
	if (node.style && node.style[rule] !== undefined) {
		return node.style[rule]
	}
	return node.parent && getStyleValue(rule, nodeMap[node.parent], nodeMap)
}
