// plugin/vue-renderer/render.js

import fs from 'fs'
import { provide, defineComponent, compile, createRenderer } from 'vue'
import { newDocument } from './element.js'
import { createNodeOps } from './nodeOps.js'
import { compileVueFile } from './compileVueFile.js'

import { newState } from '../component/nc-state.js'
// import { createComponent } from './createComponent.js'
// import { renderToPDF } from './renderToPDF.js'

let newComponentPath = '../component/'
let srcPath = '../../../../nc-designer/src/components/'
const elementArr = []
const compiledComponent = []
const comp = {}

// elementArr.push('nc-icon')
// elementArr.push('nc-message')
elementArr.push('nc-form')
elementArr.push('nc-row')
elementArr.push('nc-col')
elementArr.push('nc-draw/nc-line')
elementArr.push('nc-draw/nc-line-v')
elementArr.push('nc-draw/nc-rect')
elementArr.push('nc-form-field')
elementArr.push('nc-form-fields')
elementArr.push('nc-input/nc-label')
elementArr.push('nc-input/nc-input')
elementArr.push('nc-input/nc-textarea')
elementArr.push('nc-input/nc-label-input')
elementArr.push('nc-input/nc-label-textarea')

elementArr.forEach(item => {
	compiledComponent.push(compileVueFile(srcPath, item, newComponentPath))
})
Promise.all(compiledComponent).then(ret => {
	ret.forEach(item => {
		comp[item.default.name] = item.default
	})
	run(comp)
})

function run(comp) {
	const html = fs.readFileSync('./form.html', 'utf8')
	const stateRec = JSON.parse(fs.readFileSync('./state.json', 'utf8'))
	const state = newState('nc-render', stateRec)

	const App = defineComponent({
		name: 'NcRender',
		// components: comp, // create later by app.component(), components must be in app, here is not enugh
		setup() {
			provide('state', state)
			// return Object.assign({ style: appStyle }, toRefs(state)) // this is old-browser compatible version of '...state'
			return { ...state, state } // ...toRefs(state) if state is reactive
		},
		render: compile(`${html}`)
	})

	function createApp(...args) {
		// Modelled after https://github.com/vuejs/vue-next/blob/master/packages/runtime-dom/src/index.ts#L61
		const nodeMap = []
		const nodeOps = createNodeOps(nodeMap) // createNodeOps generates nodeMap
		const renderer = createRenderer(nodeOps)
		const app = renderer.createApp(...args) // vue call
		const { mount } = app

		app.mount = doc => {
			const proxy = mount(doc)
			doc.nodeMap = nodeMap
			return proxy
		}
		return app
	}
	const app = createApp(App)
	for (let key in comp) {
		app.component(key, comp[key])
	}
	const doc = newDocument({ filename: './file.pdf' })
	app.mount(doc) // this creates doc.nodeMap
	delete doc.nodeMap[0]._vnode
	delete doc.nodeMap[0].__vue_app__
	// console.log('\nnodeMap raw', doc.nodeMap)

	const nodeMap = doc.nodeMap.map(item => {
		const ret = {}
		for (const key in item) {
			if (!key.startsWith('_') && key !== 'nodeMap') {
				ret[key] = item[key]
			}
		}
		if (item.__vnode && item.__vnode.props) {
			const item2 = item.__vnode.props
			ret.props = {}
			for (const key2 in item2) {
				if (item2[key2] != null && typeof item2[key2] !== 'function') {
					ret.props[key2] = item2[key2]
				}
			}
		}
		return ret
	})
	// console.log('\nelementArr', elementArr)
	let data = JSON.stringify(elementArr, null, 2)
	fs.writeFileSync('./elemen-arr.json', data)
	// console.log('\nnodeMap', nodeMap)
	data = JSON.stringify(nodeMap, null, 2)
	fs.writeFileSync('./page.json', data)

	// renderToPDF(doc.nodeMap)
}
