// form/nc/nc-document/nc-document.js
// old web: plugin/dialog/script/document.coffee

export default {
	setup() {
		const rec = state.rec

		let selectedDocType = ref('')
		let pdfFrame = null
		let pdfFullscreenFunc = null
		let viewerNode = null
		let viewer = null
		let documentPassword = {}
		const cache = {
			// cache last loaded document data, saves rest call
			// todo: cache all files in view?
			docData: null,
			docPath: '',
			docName: '',
			docType: '',
			applicationType: ''
		}

		function clearPreview(clearName) {
			if (clearName) {
				rec.document_name = ''
			}
			rec.pdf_style = 'display: none'
			if (viewerNode) {
				viewerNode.parentNode.removeChild(viewerNode)
				viewerNode = null
			}
			nc.setRec(state, 'pdf_data', '')
		}

		function fullScreen() {
			if (pdfFrame == null) {
				pdfFrame = document.getElementById('pdfjs-viewer-iframe')
				pdfFullscreenFunc = pdfFrame.requestFullscreen || pdfFrame.webkitRequestFullscreen || pdfFrame.mozRequestFullScreen
			}
			if (pdfFullscreenFunc) {
				pdfFullscreenFunc.call(pdfFrame)
			}
		}

		function closeFullpage() {
			rec.pdf_style = rec.pdf_style_preview
			rec.viewer_show_type = 'preview'
			documentRowClicked(rec.viewer_show_type)
		}

		function find() {
			nc.callServer(
				state,
				'form/nc/nc-document',
				{
					parameter: {
						connection: rec.connection,
						state: rec.document_state,
						product: rec.product
					}
				},
				() => {
					documentPassword = {}
					if (rec.select_row_on_load) {
						setTimeout(() => {
							const unselectOther = true
							const scroll = true
							nc.gridActivateRows(state, 'document', 1, scroll, unselectOther)
							documentRowClicked(rec.viewer_show_type)
						}, rec.select_row_timeout) // needs timeout for grid to be drawn
					}
				}
			)
		}

		function openCallback(ret, showType) {
			let docData = ret.rec && ret.rec.picture // must use re.rec because of keep_value in rest answer
			if (!docData) {
				// show error message?
				clearPreview()
				return
			}
			const docName = rec.document_name
			const docPath = rec.document_path
			let docType = rec.document_type.toLowerCase()
			let applicationType
			if (docType === 'txt' || docType === 'text') {
				docType = 'text'
				applicationType = 'text/plain'
			} else if (docType === 'md') {
				applicationType = 'text/markdown'
			} else if (docType === 'svg') {
				applicationType = 'image/svg+xml'
			} else if (docType === 'jpg') {
				docType = 'jpeg' // safari fix
			}
			if (docType === 'png' || docType === 'jpeg' || docType === 'gif') {
				applicationType = 'image/' + docType
			}
			if (!applicationType) {
				applicationType = 'application/' + docType
			}
			openDocument(showType, docName, docPath, docData, docType, applicationType)
		}

		function openDocument(showType, docName, docPath, docData, docType, applicationType) {
			message.clearMessage(state) // clear old errors on successful load
			if (!rec.open_type.includes(docType) && !rec.open_type.includes(applicationType)) {
				const txt = nc.l(`document type '${applicationType}' can not be opened`)
				message.alert(state, txt)
				return
			}
			/* const save = false
			if (save) {
				// or nc.isSafari()
				lib.saveFileAs(blob, docName)
			} else { */
			if (cache.docPath !== docPath) {
				cache.docData = docData
				cache.docPath = docPath
				cache.docName = docName
				cache.docType = docType
				cache.applicationType = applicationType
			}
			if (!viewer) {
				viewer = document.getElementById('nc-pdf-preview-canvas')
			}
			if (docType === 'pdf') {
				docData = nc.base64ToBinary(docData, applicationType)
				if (showType === 'fullpage') {
					rec.pdf_style = rec.pdf_style_fullpage
				} else {
					rec.pdf_style = rec.pdf_style_preview
				}
				nc.setRec(state, 'viewer_show_type', showType)
				nc.setRec(state, 'pdf_data', { data: docData, viewer_show_type: showType })
			} else {
				if (!rec.do_not_encode_type.includes(docType)) {
					docData = nc.base64toBlob(docData, applicationType)
				}
				if (viewer) {
					if (applicationType.startsWith('text')) {
						const node = document.createElement('textarea')
						node.className = 'nc-textarea'
						const textNode = document.createTextNode(docData)
						node.appendChild(textNode)
						// in textarea there must be width and min-height, replace the default style
						node.style = rec.pdf_style_preview.replace('max-width', 'width').replace('height', 'min-height') + ';margin: 0'
						viewerNode = viewer.parentNode.insertBefore(node, viewer)
					} else if (docType === 'svg') {
						// https://dev.to/benjaminblack/using-a-string-of-svg-as-an-image-source-8mo
						let docDataBlob = new Blob([docData], { type: 'image/svg+xml' })
						const url = URL.createObjectURL(docDataBlob)
						const node = document.createElement('img')
						node.addEventListener('load', () => URL.revokeObjectURL(url), { once: true })
						node.src = url
						node.style.cssText = rec.pdf_style_preview
						viewerNode = viewer.parentNode.insertBefore(node, viewer)
					} else if (docType === 'png' || docType === 'jpeg') {
						const url = URL.createObjectURL(docData)
						const node = new Image()
						node.addEventListener('load', () => URL.revokeObjectURL(url), { once: true })
						node.src = url
						node.style.cssText = rec.pdf_style_preview
						viewerNode = viewer.parentNode.insertBefore(node, viewer)
					} else {
						const url = URL.createObjectURL(docData)
						const win = window.open(url, docName) // , docName, '_blank')
						if (win) {
							win.addEventListener(
								'load',
								() => {
									URL.revokeObjectURL(url)
									win.document.title = docName // set opened window title so that is does not display "blob:..."
								},
								{ once: true }
							)
						} else if (docType !== 'pdf') {
							message.setInfo(state, 'Opening window for print failed, allow popup windows for this url to see report in browser.')
						}
					}
				}
			}
			// }
		}

		function passwordCallback(reason) {
			let answer
			if (reason === 1) {
				if (documentPassword[rec.document_name]) {
					return documentPassword[rec.document_name]
				}
				answer = prompt(nc.l(`Please enter pdf password`))
			} else {
				//if (reason === 2) {
				answer = prompt(nc.l(`Entered password was invalid, please enter pdf password`))
				/* } else {
				answer = prompt(nc.l(`Please enter pdf password (reason: ${reason})`)) */
			}
			documentPassword[rec.document_name] = answer
			return answer
		}

		function documentRowClicked(showType) {
			const arr = nc.gridActivatedRecordArr(state, 'document')
			clearPreview(false)
			if (arr && arr.length > 0) {
				const row = arr[0]
				if (row.kw.value === cache.docPath) {
					openDocument(showType, cache.docName, cache.docPath, cache.docData, cache.docType, cache.applicationType)
				} else {
					if (row.kw.value !== '') {
						selectedDocType.value = row.kw.field_type
						if (!selectedDocType.value) {
							// empty string
							selectedDocType.value = peg.parseAfterLast(row.kw.value, '.')
						}
						selectedDocType.value = selectedDocType.value.toLowerCase()
						const param = {
							connection: rec.connection,
							state: rec.document_state,
							encode: !rec.do_not_encode_type.includes(selectedDocType.value),
							document_name: row.kw.info,
							document_path: row.kw.value,
							document_type: selectedDocType.value,
							max_file_size_kb: rec.max_file_size_kb
						}
						nc.callServer(state, 'form/nc/nc-document', { parameter: param }, ret => {
							return openCallback(ret, showType)
						})
					}
				}
			}
		}

		clearPreview()
		if (rec.product !== '') {
			find()
		}
		return { selectedDocType, passwordCallback, documentRowClicked, find, fullScreen, closeFullpage }
	}
}
