// /src/components/nc-form-col-row.js
// TODO: make nc-row to functional component, see: https://github.com/alexsasharegan/vue-flex/blob/master/lib/components/Flex.js

import { computed } from 'vue'

function setWarning(vm, ...args) {
	console.warn(...args)
}

function calculatePercent(str, obj, widthHeight, event) {
	if (typeof str !== 'string') {
		if (event !== 'update') {
			setWarning(null, widthHeight + ' parameter type is not string: ', typeof str, str, obj)
		}
		if (typeof str === 'number') {
			return str
		} else {
			return 'auto'
		}
	}
	let arr = str.split('/')
	if (arr.length !== 2) {
		if (event !== 'update') {
			if (arr.length > 2) setWarning(null, widthHeight + ` parameter must contain only one '/' :`, str, obj)
			else setWarning(null, widthHeight + ` parameter does not contain '/' :`, str, obj)
		}
		return 'auto'
	}
	let num1 = Number(arr[0])
	let num2 = Number(arr[1])
	if (num2 <= 0 || num1 > num2 || isNaN(num1) || isNaN(num2)) {
		if (event !== 'update') {
			// if (currentUrl() !== '/editor/layout') {
			// no errors during input of a width
			setWarning(null, widthHeight + ' parameter does not resolve to valid number:', str, obj)
			// }
		}
		return 'auto'
	}
	return num1 / num2
}

export function rowColStyle(props, setDefaultWidth, event) {
	if (!props) return ''
	let style = props.style || ''
	if (setDefaultWidth === true && !props.width) {
		style = style + 'width:100%;'
	} else if (setDefaultWidth && !props.width) {
		style = style + 'width:' + setDefaultWidth + ';'
	}
	if (props.width) {
		// search for '/', for ex. width='1/3'
		if (props.width.search('/') >= 0) {
			let percent = calculatePercent(props.width, props, 'width', event)
			if (percent === 'auto') {
				// style = 'width:auto;' + style
			} else {
				style = 'width:' + percent * 100 + '%;' + style
			}
		} else {
			style = 'width:' + props.width + ';' + style
		}
	}
	if (props.height) {
		if (props.height.search('/') >= 0) {
			if (style !== '') {
				style = style + ' '
			}
			let percent = calculatePercent(props.height, props, 'height', event) * 100
			if (percent === 'auto') {
				style = 'height:auto;' + style
			} else {
				style = style + 'height:' + percent + '%;' + style
			}
		} else {
			style = style + 'height:' + props.height + ';' + style
		}
	}
	// console.log(`🚀 ~ file: nc-form-col-row.js ~ line 81 ~ rowColStyle ~ '${style}'`)
	return style
}

export default function createComponent(name, defaultWidth) {
	return {
		name: name,
		props: {
			style: {
				type: [String, Object],
				default: undefined,
				required: false
			},
			width: {
				type: String,
				default: undefined,
				required: false
			},
			height: {
				type: String,
				default: undefined,
				required: false
			}
		},
		setup(props) {
			// console.debug(`created component ${name}, defaultWidth: ${defaultWidth}`)
			const calculatedStyle = computed(() => {
				return rowColStyle(props, defaultWidth)
			})
			/* if (this.$parent.$attrs.ncnode && this.$parent.$attrs.ncnode.attribute) {
				this._props = this.$parent.$attrs.ncnode.attribute
			} */
			return { calculatedStyle }
		}
	}
}
