// /src/components/nc-input/nc-input-component.js
/* <template>
	<sui-input
		:style='calculatedStyle'
		:class='styleClass'
		:disabled='disabled'
		:value='recValueFormatted'
		@input='updateValue($event)'
		@focus='onFocus($event)'
		@blur='onBlur($event)'/>
</template> */

/* import './nc-input.scss'
import nc from '/src/core/nc-util.js'
import peg from '/src/core/nc-peg.js'
import dt from '/src/core/nc-dt.js'
import { ncValidate } from '/src/directives/nc-validate.js' */
// import SuiInput from '/web_modules/semantic-ui-vue/dist/commonjs/elements/Input/Input.js'

import nc from '../nc-util.js'
import { rowColStyle } from '../nc-form-col-row.js'
const defaultDateFormat = null // 'dd.mm.yyyy' // TODO: fix defaultDateFormat

/* function debouncedRef(value, delay = 200) {
	let timeout
	return customRef((track, trigger) => {
		return {
			get() {
				track()
				return value
			},
			set(newValue) {
				clearTimeout(timeout)
				timeout = setTimeout(() => {
					value = newValue
					trigger()
				}, delay)
			}
		}
	})
} */

export const props = {
	container_style: {
		type: String,
		default: undefined,
		required: false
	},
	input_style: {
		type: String,
		default: undefined,
		required: false
	},
	focus: {
		type: Function,
		default: undefined,
		required: false
	},
	blur: {
		type: Function,
		default: undefined,
		required: false
	},
	required: {
		type: Boolean,
		default: false,
		required: false
	},
	type: {
		type: String,
		default: 'text',
		required: false
	},
	hdr: {
		type: String,
		default: undefined,
		required: false
	},
	model: {
		type: String,
		default: undefined,
		required: false
	},
	labelWidth: {
		type: String,
		default: undefined,
		required: false
	},
	inputWidth: {
		type: String,
		default: undefined,
		required: false
	},
	width: {
		type: String,
		default: undefined,
		required: false
	},
	height: {
		type: String,
		default: undefined,
		required: false
	},
	value: {
		type: [String, Number, Boolean],
		default: undefined,
		required: false
	},
	placeholder: {
		type: String,
		default: undefined,
		required: false
	},
	autocomplete: {
		type: String,
		default: undefined,
		required: false
	},
	disabled: {
		type: Boolean,
		default: undefined,
		required: false
	},
	calendarType: {
		type: String,
		default: undefined,
		required: false
	},
	startMode: {
		type: String,
		default: undefined,
		required: false
	},
	startCalendar: {
		type: String,
		default: undefined,
		required: false
	},
	endCalendar: {
		type: String,
		default: undefined,
		required: false
	},
	hover: {
		type: String,
		default: undefined,
		required: false
	},
	rows: {
		type: String,
		default: undefined,
		required: false
	} // for textarea
	/* editor: { type: String, default: undefined, required: false }, */
}

export default function createComponent(name) {
	return {
		name: name,
		inject: ['state'],
		// directives: { ncValidate },
		props: props, // Object.assign({}, SuiInput.props, props),
		data() {
			return {
				style: '',
				styleClass: 'nc-input',
				isCalendar: false,
				textIsChanged: false,
				dateFormat: null,
				useValue: false,
				recName2: null
				// markedDates: [],
			}
		},
		created() {
			this.recName = null
			this.style = rowColStyle(this, true) // true == set default
			if (!nc.isNil(this.value)) {
				this.useValue = true
				return
			}
			if (this.model == null) {
				if (this.value === undefined) {
					// null is valid
					if (this.$attrs && this.$attrs[':value']) {
						this.useValue = true
						return
					}
					console.warn('input component, model or value does not exist', this)
					this.useValue = true // prevent more errors
					// debugger // eslint-disable-line
					return
				}
				return
			}
			let pos = this.model.indexOf('.')
			this.recName = this.model.substring(pos + 1) // part after "rec."
			if (!nc.isNil(this.startCalendar)) {
				pos = this.startCalendar.indexOf('.')
				this.recName2 = this.startCalendar.substring(pos + 1)
			} else if (!nc.isNil(this.endCalendar)) {
				pos = this.endCalendar.indexOf('.')
				this.recName2 = this.endCalendar.substring(pos + 1)
			}
			if (this.model.indexOf('rec.') !== 0) {
				console.warn("input component model does not start with 'rec.''", this.model, this)
			}
			this.isCalendar = this.type === 'date'
			if (nc.isDate(this.recValue)) {
				// const locale = window.navigator.userLanguage || window.navigator.language // use ma language
				// dt.setLocale(locale) // timestamp.fromJSDate.locale(locale)
				this.dateFormat = defaultDateFormat
				if (this.calendarType === 'timestamp') {
					const timeFormat = dt.timeFormat()
					this.dateFormat = this.dateFormat + ' ' + timeFormat
				}
				// this.type = 'date' // TODO: timestamp?
				this.isCalendar = true
				this.setupDone = true
			}
		},
		computed: {
			calculatedStyle() {
				let style = this.style
				if (this.input_style) {
					style += this.input_style + ';'
				}
				return style
			},
			hdrModel() {
				if (this.hdr) return this.hdr
				if (this.model == null) return ''
				let pos = this.model.indexOf('.')
				return 'hdr.' + this.model.substring(pos + 1) // part after "rec."
			},
			recValue() {
				if (this.useValue) {
					return this.value // this.fieldRec[this.fieldName] # this.value
				}
				return nc.recData(this.state.rec, this.recName)
			},
			recValueFormatted() {
				if (this.useValue) {
					return this.value
				}
				let val = nc.recData(this.state.rec, this.recName)
				if (nc.isDate(val)) {
					this.prevValidDate = val
					this.dateFormat = this.dateFormat || defaultDateFormat
					val = dt.dateToString(val, this.dateFormat) // timestamp.fromJSDate(val).format(this.dateFormat)
				}
				return val
			},
			recValue2() {
				return nc.recData(this.state.rec, this.recName2)
			}
		}
		/* methods: {
			choseDay(newDate) {
				// datepicker date has been chosen
				this.updateValue(newDate)
			},
			updateValue(event) {
				let newValue = event
				const isDate = nc.isDate(newValue)
				if (isDate) {
					this.dateFormat = this.dateFormat || defaultDateFormat
					newValue = dt.dateToString(newValue, this.dateFormat)
				} else if (typeof event === 'object') {
					newValue = event.target.value
				}
				if (typeof newValue === 'string') {
					if (!isDate && typeof event === 'object') {
						event.target.value = newValue
					}
				}
				this.inputValueChanged(newValue)
				this.$emit('change', newValue)
			},
			onEnterKey(event) {
				let runDefault = true
				if (this.focus) {
					runDefault = this.focus(event)
				}
				if (runDefault) {
					this.$emit('enterKey', event)
				}
			},
			onFocus(event) {
				let runDefault = true
				if (this.focus) {
					runDefault = this.focus(event)
				}
				if (runDefault) {
					this.$emit('focus', event)
				}
			},
			onBlur(event) {
				let runDefault = true
				if (this.blur) {
					runDefault = this.blur(event)
				}
				let newValue = event
				if (typeof event === 'object') {
					newValue = event.target.value
				}
				if (this.dateFormat) {
					const oldValue = nc.recData(this.state.rec, this.recName)
					let date = dt.textToDate(oldValue)
					this.prevValidDate = date
					newValue = dt.dateToString(date, this.dateFormat)
				} else if (typeof newValue === 'string') {
					newValue = peg.cleanBeforeAfterDoubleSpace(newValue)
					if (typeof event === 'object') {
						event.target.value = newValue
					}
				}
				this.inputValueChanged(newValue)
				if (runDefault) {
					this.$emit('blur', event)
				}
			},
			inputValueChanged(newValue) {
				if (this.useValue) {
					return
				}
				nc.setPrevRec(this, this.recName, 'nc-input')
				nc.setRec(this, this.recName, newValue)
			}
		} */
		/* 	watch: {
			recValue(newValue, oldValue) {
				let locale, timeFormat
				if (this.useValue) {
					return
				}
				console.debug('newValue', newValue)
				if (nc.isDate(newValue)) {
					if (!this.setupDone && oldValue == null) {
						this.isCalendar = true
						locale = window.navigator.userLanguage || window.navigator.language // use ma language
						dt.setLocale(locale) // timestamp.fromJSDate.locale(locale)
						this.dateFormat = defaultDateFormat
						if (this.calendarType === 'timestamp') {
							timeFormat = dt.timeFormat()
							this.dateFormat = this.dateFormat + ' ' + timeFormat
						}
						// this.type = 'date' // TODO: timestamp?
						this.setupDone = true
					}
				}
			}
		} */
	}
}

/* semantic-ui-vue/src/elements/Input.jsx
  props: {
    action: String,
    disabled: Boolean,
    error: Boolean,
    focus: Boolean,
    icon: String,
    iconPosition: Enum(['left', 'right']),
    inverted: Boolean,
    loading: Boolean,
    transparent: Boolean,
    type: {
      description: 'The HTML input type.',
      default: 'text',
      type: String,
    },
    value: [String, Number],
  },
  events: {
    input: {
      custom: true,
    },
    blur: {
      custom: true,
    },
  },
  methods: {
    handleChange(event) {
      const eventValue = event.target.value;
      const value = this.type === 'number' ? Number(eventValue) : eventValue;
      this.$emit('input', value);
    },
	},

	class={this.classes(
		'ui',
		this.action && 'action',
		this.disabled && 'disabled',
		this.error && 'error',
		this.focus && 'focus',
		this.transparent && 'transparent',
		this.inverted && 'inverted',
		this.loading && 'loading',
		this.iconPosition === 'left' && 'left',
		(this.loading || this.icon) && 'icon',
		'input',
	)}
>
	<input
		value={this.value}
		onInput={this.handleChange}
		onBlur={e => this.$emit('blur', e)}
		ref="input"
		type={this.type}
		{...{ attrs: this.$attrs }}
	/>
	{icon}
	{this.action && <SuiButton content={this.action} />}
*/
