// node is the most low level node.

// import { defaultStyle } from './styling.js'
let id = 0
// Eg Text is a createNode. createNode does not have children.
function createNode() {
	const node = {
		id: id
		// style: {} // this tag will be generated when needed
	}
	id++
	return node
}

export function newTextNode(value) {
	const node = createNode()
	node.value = value
	node.tag = 'content'
	return node
}

// Element is the main function of Elements you will use.
// The difference between Node and Element is Elements can have children.
export function newElement(tag) {
	const node = createNode()
	node.children = []
	node.tag = tag
	return node
}

export function newDocument() {
	const node = newElement('Document')
	if (node.id !== 0) {
		console.error(`Document id '${node.id}' is not 0`)
	}
	//  node.style = defaultStyle // { ...defaultStyle } // clones defaultStyle
	return node
}
