import { newTextNode, newElement } from './element.js'

function noop(fn) {
	console.error(`no-op: ${fn}`)
}

export function createNodeOps(nodeMap) {
	return {
		patchProp: (el, key, prevVal, nextVal) => {
			if (el.key && nextVal != null) {
				el[key] = nextVal
			}
			if (el.tag == 'image' && nextVal) {
				if (key === 'src') {
					el.src = nextVal
				}
				if (key === 'width') {
					el.width = nextVal
				}
				if (key === 'height') {
					el.height = nextVal
				}
			}
			/* 	if (nextVal && key === 'style') {
				if (el.style == null && typeof nextVal === 'string') {
					// el.style = nextVal // style is in props, no need to duplicate it
				} else {
					el.style = el.style || {}
					for (const [attr, value] of Object.entries(nextVal)) {
						el.style[attr] = value
					}
				}
			} */
		},
		insert: (child, parentNode) => {
			// (child, parentNode, anchor)
			if (child == null) {
				return
			}
			if (!(child.id in nodeMap)) {
				nodeMap[child.id] = child
			}
			parentNode.children.push(child.id)
			child.parent = parentNode.id
		},
		createElement: tag => {
			return newElement(tag)
		},
		createText: text => {
			if (text !== '') {
				return newTextNode(text)
			}
		},
		parentNode: () => {
			// node =>
			return null
		},
		createComment: () => {
			return null
		},
		setText: () => noop('setText'),
		setElementText: () => noop('setElementText'),
		nextSibling: () => noop('nextSibling'),
		querySelector: () => noop('querySelector'),
		setScopeId: () => noop('setScopeId'),
		cloneNode: () => noop('cloneNode'),
		insertStaticContent: () => noop('insertStaticContent'),
		forcePatchProp: () => noop('forcePatchProp'),
		remove: () => noop('remove')
	}
}
