// form/core/nc-define/nc-layout-editor/nc-layout-toolbar/nc-layout-toolbar.js

import { cleanLayoutJson, isContainer, restCallback } from '/plugin/nc-layout-editor/nc-layout-editor-util.js'
import NcLayoutElement from '/plugin/nc-layout-editor/nc-layout-element.js'
import NcElementProperty from '/plugin/nc-layout-editor/nc-element-property.js'
import NcContainerProperty from '/plugin/nc-layout-editor/nc-container-property.js'
nc.addImportedComponent(NcLayoutElement)
nc.addImportedComponent(NcElementProperty)
nc.addImportedComponent(NcContainerProperty)

console.debug('* nc-layout-toolbar lazy-loaded')

const rec = state.rec
function save() {
	const saveData = cleanLayoutJson(rec.layout_json, true) // true == strip id
	nc.callServer(state, 'dynamic-form', { path: rec.layout_name, save: saveData }, restCallback(state))
}
function toolWidth() {
	return rec.element_column_width * rec.tool_column_count + rec.toolbar_extra_width - 1.1 + 'em'
}
