// plugin/vue-renderer/renderer/compileVueComponent.js
import { replaceContent } from './replace-content.js'
import { parse, compileScript, compileTemplate, compileStyle } from '../vuelib.js' // '@vue/compiler-sfc' // './vuelib.js'

// inject,
const defaultVuePath = '/vue.js'
const jsStart = `
import { getCurrentInstance, inject, provide, ref, reactive, computed, watch, watchEffect, onBeforeMount, onMounted, onBeforeUpdate, onUpdated, onBeforeUnmount, onUnmounted, onActivated, onDeactivated } from '${defaultVuePath}'
import { dt, message, nc, peg } from '/assets/nc-plugin.js'
`
let id = 10000

export function compileVueComponent(param) {
	let { fileName, js, html, pug, ssr, vuePath, style } = param
	vuePath = vuePath || defaultVuePath
	if (ssr !== true) {
		ssr = false
	}
	const fileNameVue = fileName + '.vue'
	let content
	if (typeof html === 'string') {
		content = '<template>\n' + html + '</template>\n\n' + '<script setup>\n' + jsStart + js + '\n</script>\n'
	} else {
		content = jsStart + js // .vue component from disk
	}
	const parsed = parse(content, { sourceMap: false, filename: fileNameVue })
	id++
	const script = compileScript(parsed.descriptor, { id: 'nc-script-' + id, filename: fileNameVue, sourceMap: false })
	const ret = {}
	if (parsed.descriptor.template) {
		let parsedHtml = parsed.descriptor.template.content
		if (parsed.descriptor.template.lang === 'pug') {
			if (!pug) {
				ret.error = 'pug is not defined, give it as param 4'
			} else {
				const pugOptions = {}
				const fn = pug.compile(parsedHtml, pugOptions)
				const pugLocals = {}
				parsedHtml = fn(pugLocals)
			}
		}
		if (html === true) {
			ret.html = parsedHtml
		}
		id++
		// render = compile(parsedHtml) // works, but gives a function, not code as text
		const render = compileTemplate({
			sourceMap: false,
			id: 'nc-template-' + id,
			source: parsedHtml,
			filename: fileNameVue,
			ssr: ssr
		})
		ret.code = replaceContent(fileName, script.content + '\n\n// render code\n' + render.code, vuePath)
	}
	if (style) {
		ret.style = parsed.descriptor.styles
		return ret
	}
	return ret.code
}

/*
function parseVueComponent(param) {
	let { fileName, content, pug, sass, vuePath } = param
	vuePath = vuePath || defaultVuePath
	const parsed = parse(content, { sourceMap: false, filename: fileName + '.vue' })
	const ret = {}
	if (parsed.errors.length > 0) {
		ret.error = parsed.errors.join('\n')
	}
	if (parsed.descriptor.script) {
		if (parsed.descriptor.scriptSetup) {
			ret.code = parsed.descriptor.scriptSetup.content
		} else {
			ret.code = parsed.descriptor.script.content
		}
	}
	if (parsed.descriptor.styles && parsed.descriptor.styles.length > 0) {
		let scopedStyleArr = []
		let styleArr = []
		for (const item of parsed.descriptor.styles) {
			let css = item.content
			if (item.lang === 'scss' || item.lang === 'sass') {
				const result = sass.renderSync({ data: css })
				css = result.css.toString()
			}
			const style = compileStyle({ id: 'nc-style-' + id, source: css, filename: fileName })
			if (item.scoped) {
				scopedStyleArr.push(style.code)
			} else {
				styleArr.push(style.code)
			}
		}
		if (scopedStyleArr.length > 0) {
			ret.scoped_style = scopedStyleArr
		}
		if (styleArr.length > 0) {
			ret.style = styleArr
		}
	}
	if (parsed.descriptor.template) {
		let parsedHtml = parsed.descriptor.template.content
		if (parsed.descriptor.template.lang === 'pug') {
			if (!pug) {
				ret.error = 'pug is not defined, give it as param'
			} else {
				const pugOptions = {}
				const fn = pug.compile(parsedHtml, pugOptions)
				const pugLocals = {}
				parsedHtml = fn(pugLocals)
			}
		}
		ret.html = parsedHtml
	}
	return ret
} */
