// javascript/later.v8.mjs
import { later } from './later.mjs'
/* console.log("hello")
const schedule = function (scheduleText, count) {
	console.log("hello schedule", scheduleText, count)
	return 'schedule ok: ' + scheduleText
} */
// set later to use local time;
later.date.localTime()
// set later to use UTC (the default):
// later.date.UTC();

const timeZoneOffset = new Date().getTimezoneOffset() * 60 // to seconds
function toUnixTime(dateArr) {
	let ret = []
	if (!dateArr.length) { // not an array, is single value
		ret[0] = Math.floor(dateArr.valueOf() / 1000)
	} else {
		for (let i = 0; i < dateArr.length; i++) {
			ret[i] = Math.floor(dateArr[i].valueOf() / 1000) - timeZoneOffset
			// valueOf() is unix time with milliseconds, remove milliseconds
		}
	}
	return ret
}

function schedule(scheduleText, count) {
	let schedule = later.parse.text(scheduleText)
	if (schedule.error != -1) {
		return "err: schedule error in position " + schedule.error + ", ..." + schedText.substring(schedule.error - 10, schedule.error + 10) + "..."
	}
	let ret
	if (count < 0) {
		ret = later.schedule(schedule).prev(Math.abs(count))
	} else {
		ret = later.schedule(schedule).next(count)
	}
	ret = toUnixTime(ret)
	return ret
}

// timeZoneOffset // return value must be given like this, not with return because main level js can't have return value
