// form/nc/nc-bank/nc-bank.js

export default {
	setup() {
		const rec = state.rec
		const gridData = {}
		const jsonTextData = ref('')
		let id = 0
		nc.setRec(state, 'json_data', [])
		// nc.setRec(state, 'start_date', '')
		// nc.setRec(state, 'end_date', '')

		function changeTab() {
			loadData()
		}

		function loadData() {
			nc.setGrid(state, 'voucher', null)
			const param = {
				name: 'form/nc/nc-bank/grid.json',
				parameter: {
					bank_note_days_before: rec.table === 'bank_note' ? 0 : rec.bank_note_days_before,
					voucher_days_before: rec.table !== 'bank_note' ? 0 : rec.voucher_days_before,
					start_date: rec.start_date,
					end_date: rec.end_date,
					account: rec.account
				},
				return: {
					grid: [
						{
							name: 'bank_note',
							tab: 'bank_note'
						},
						{
							name: 'bank_payment',
							tab: 'bank_payment'
						},
						{
							name: 'voucher',
							tab: rec.table === 'bank_note' ? 'bookkeeping_voucher_row' : rec.table
						}
					]
				}
			}
			nc.callServer(state, 'query', param, compareData)
		}

		function setIdAndValue(arr) {
			arr.forEach(rec => {
				id++
				rec.id = id
				if (rec.record_type === 'T10' || rec.record_type === 'T40') {
					let bookRec = compareBankStatement(rec)
					if (!bookRec) {
						if (rec.record_type === 'T40') {
							rec.difference = rec.balance
						} else if (typeof rec.amount === 'number') {
							rec.difference = rec.amount
						}
					} else {
						rec.voucher = bookRec.bkvr.voucher_id + '-' + bookRec.bkvr.row_number
						if (rec.record_type === 'T40') {
							rec.difference = (bookRec.book_balance - rec.balance).toFixed(2)
						} else {
							if (bookRec.book_value - rec.amount !== 0) {
								// rec.difference = (bookRec.book_value - rec.amount).toFixed(2)
								rec.difference = bookRec.book_value.toFixed(2)
							}
						}
						bookRec.record_type = 'vr'
						if (!rec.content) {
							rec.content = []
						}
						rec.content.unshift(bookRec)
					}
				}
				if (rec.content) {
					setIdAndValue(rec.content)
				}
			})
		}

		function selectedRecordArr(area) {
			let grid = state.grid && state.grid[area]
			if (!(grid && grid.grid && grid.grid.api)) {
				return []
			}
			let sel = grid.grid.api.getSelectedRows()
			if (sel.length > rec.max_selected_rows) {
				message.setInfo(state, `Maximum amount of rows to select is ${rec.max_selected_rows}, otherwise browser may run out of memory.`)
				return []
			}
			return sel
		}

		function selectAreaRow(area, findDate, data) {
			for (let idx = 0; idx < data.length; idx++) {
				if (area == 'voucher' && findDate <= data[idx].bkv.target_date) {
					nc.gridActivateRows(state, area, idx)
					break
				} else if (area == 'bank_note' && findDate <= data[idx].bankm.start_date) {
					nc.gridActivateRows(state, area, idx)
					break
				} else if (area == 'bank_payment' && findDate <= data[idx].bankm.start_date) {
					nc.gridActivateRows(state, area, idx)
					break
				}
			}
		}

		function gridRowClicked(area, rowIndex, selected) {
			const arr = selectedRecordArr(area)
			if (selected && arr.length < 1) {
				nc.setRec(state, 'bankm', {})
				return
			}
			if (selected && area === 'bank_note') {
				selectAreaRow('voucher', arr[0].bankm.start_date, state.grid.voucher.data)
				selectAreaRow('bank_payment', arr[0].bankm.start_date, state.grid.bank_payment.data)
				const jsonArr = []
				for (let idx = 0; idx < arr.length; idx++) {
					jsonArr.push(JSON.parse(arr[idx].bankm.json_data))
				}
				nc.setRec(state, 'json_data', jsonArr)
				gridData.bookStartIdx = 0
				state.grid.voucher.data.forEach(rec => {
					rec.bank_note_id = undefined
				})
				setIdAndValue(jsonArr)
				let date
				const voucherDateArr = {}
				state.grid.voucher.data.forEach(rec => {
					date = rec.bkv.target_date
					if (!voucherDateArr[date]) {
						voucherDateArr[date] = []
					}
					rec.record_type = 'vr'
					voucherDateArr[date].push(rec)
				})
				// jsonTextData.value = JSON.stringify(jsonArr[0], null, 2)
				nc.setRec(state, 'bankm', arr[0].bankm)
				nc.setRec(state, 'voucherDateArr', voucherDateArr)
				// nc.setRec(state, 'start_date', arr[0].bankm.start_date)
				// nc.setRec(state, 'end_date', arr[arr.length - 1].bankm.end_date)
			} else if (!selected && area === 'bank_note') {
				nc.setRec(state, 'bankm', {})
			} else if (selected && area === 'bank_payment') {
				const data = JSON.parse(state.grid.bank_payment.data[rowIndex].bankm.json_data)
				jsonTextData.value = JSON.stringify(data, null, 2)
				selectAreaRow('bank_note', arr[0].bankm.start_date, state.grid.bank_note.data)
				selectAreaRow('voucher', arr[0].bankm.start_date, state.grid.voucher.data)
			} else if (selected) {
				selectAreaRow('bank_note', arr[0].bkv.target_date, state.grid.bank_note.data)
				selectAreaRow('bank_payment', arr[0].bkv.target_date, state.grid.bank_payment.data)
				nc.setRec(state, 'bkv', arr[0].bkv)
			} else if (!selected) {
				nc.setRec(state, 'bkv', {})
			}
		}

		function compareBankStatement(rec) {
			let date, sum
			date = rec.entry_date
			if (rec.record_type === 'T40') {
				sum = rec.balance
			} else {
				sum = rec.amount
			}
			let bookArr = state.grid.voucher.data
			if (!bookArr) {
				return
			}
			// all arrays are sorted by date, we can go only forward in dates so it is good to use prevIdx

			let item, itemDate
			for (let idx = gridData.bookStartIdx; idx < bookArr.length; idx++) {
				item = bookArr[idx]
				itemDate = item.bkv.target_date
				if (itemDate === date) {
					if (rec.record_type === 'T40') {
						gridData.bookStartIdx = idx
					}
					while (idx < bookArr.length && bookArr[idx].bkv.target_date === date) {
						if (rec.record_type === 'T40') {
							if (bookArr[idx].book_balance === sum) {
								item = bookArr[idx]
								return item
							}
						} else if (bookArr[idx].book_value === sum) {
							item = bookArr[idx]
							if (item.bank_note_id == null) {
								item.bank_note_id = rec.id
								return item
							}
						}
						idx++
					}
					if (rec.record_type === 'T40') {
						return item // return last found
					}
					return
				} else if (itemDate > date) {
					if (idx > 0) {
						if (rec.record_type === 'T40') {
							gridData.bookStartIdx = idx - 1
						}
					}
					if (rec.record_type === 'T40') {
						return item // return last found
					}
					return // break loop, we are over asked date
				}
			}
			return
		}

		function getBankBalance(date, sum, balance) {
			const dateBalanceArr = gridData.dateBalanceArr
			if (!dateBalanceArr) {
				return
			}
			let item
			// all arrays are sorted by date, we can go only forward in dates so it is good to use prevIdx

			for (let idx = gridData.startIdx; idx < dateBalanceArr.length; idx++) {
				item = dateBalanceArr[idx]
				if (item.date === date) {
					gridData.startIdx = idx
					while (idx < dateBalanceArr.length && dateBalanceArr[idx].date === date) {
						if (dateBalanceArr[idx].value === sum) {
							item = dateBalanceArr[idx]
							if (item.balance == balance) {
								// gridData.startIdx = idx + 1
								return item
							}
						} else if (dateBalanceArr[idx].balance === balance) {
							return dateBalanceArr[idx]
						}
						idx++
					}
					return item
				} else if (item.date > date) {
					if (idx > 0) {
						gridData.startIdx = idx - 1
						return dateBalanceArr[gridData.startIdx] // break loop, we are over asked date
					}
					return
				}
			}
			return
		}

		function compareData(ret) {
			if (ret.grid && ret.grid.voucher) {
				let item, prevItem, data
				if (ret.grid.bank_note) {
					data = ret.grid.bank_note.data
					const dateBalanceArr = []
					let statementArr, stm
					let totalStatementCount = 0
					let statementIdx = 0

					let dataChanged
					for (let idx = 0; idx < data.length; idx++) {
						dataChanged = false
						item = data[idx]
						let json = JSON.parse(item.bankm.json_data)
						if (idx === 0) {
							let date = dt.dateToString(rec.start_date)
							if (json.start_date > date) {
								json.start_date = date // must start from date range start to get all missing events before bank statements start date
								dataChanged = true
							}
						}
						statementArr = json.content
						if (statementArr == null) {
							console.error(`statementArr content is missing`)
						} else {
							let statement_number = ''
							for (let j = 0; j < statementArr.length; j++) {
								totalStatementCount++
								stm = statementArr[j]
								if (stm.record_type === 'T10') {
									if (
										stm.event_type === 'otto' &&
										stm.content.length === 2 &&
										stm.content[0].info_type === '01' &&
										stm.content[1].info_type === '06'
									) {
										stm.amount = '(' + stm.amount + ')'
										dataChanged = true
									}
								} else if (stm.record_type === 'T40') {
									statementIdx++
									dateBalanceArr.push({
										record_type: stm.record_type + '-' + statement_number,
										dataIdx: idx,
										idx: statementIdx,
										start_date: item.bankm.start_date,
										end_date: item.bankm.end_date,
										date: stm.entry_date,
										balance: stm.balance
										// value: stm.balance
									})
								}
							}
						}
						if (dataChanged) {
							item.bankm.json_data = JSON.stringify(json)
						}
					}

					for (let idx = dateBalanceArr.length - 1; idx > 0; idx--) {
						if (dateBalanceArr[idx].date !== dateBalanceArr[idx].end_date) {
							console.error('bank statement date check error')
						}
						if (dt.addDays(dateBalanceArr[idx - 1].date, 1) !== dateBalanceArr[idx].start_date) {
							const newRec = {
								// add to array
								dataIdx: dateBalanceArr[idx].dataIdx,
								idx: idx + '-err',
								record_type: 'err',
								balance: data[idx - 1].balance,
								start_date: dt.addDays(dateBalanceArr[idx - 1].date, 1),
								end_date: dt.addDays(dateBalanceArr[idx].start_date, -1)
							}
							console.warn(`* missing balance dates: ${newRec.start_date} - ${newRec.end_date} `, newRec)

							dateBalanceArr.splice(idx, 0, newRec)
							const newBankRec = nc.clone(data[newRec.dataIdx - 1])
							newBankRec.id = newBankRec.id + '.1'
							newBankRec.bankm.start_date = newRec.start_date
							newBankRec.bankm.end_date = newRec.end_date
							// const content = []
							// const date = newRec.start_date
							// while (date < newRec.end_date) {
							// 	content.push({ record_type: 'T00' })
							// }
							const jsonData = {
								record_type: 'T00',
								account_owner: 'Error: missing bank note.',
								start_date: newRec.start_date,
								end_date: newRec.end_date,
								start_balance: newRec.balance
								// content: content
							}
							newBankRec.bankm.json_data = JSON.stringify(jsonData)
							data.splice(newRec.dataIdx, 0, newBankRec)
						}
					}
					// dateBalanceArr.sort(nc.dynamicSort(['date', '>', 'record_type', '>', 'value', '>', 'idx', '>']))
					gridData.dateBalanceArr = dateBalanceArr
					gridData.startIdx = 0
					gridData.totalStatementCount = totalStatementCount
				}

				const table = ret.grid.voucher.info.queryTable
				gridData[table] = ret.grid.voucher.data // save loaded table grid data to ret.data
				data = gridData[table]
				if (table === 'bookkeeping_voucher') {
					for (let idx = 0; idx < data.length; idx++) {
						item = data[idx]
						if (item.bkv.json_data.debet_price !== item.bkv.json_data.kredit_price) {
							item.difference = item.bkv.json_data.debet_price - item.bkv.json_data.kredit_price
						}
					}
				} else if (table === 'bookkeeping_voucher_row') {
					for (let idx = 0; idx < data.length; idx++) {
						item = data[idx]
						item.book_value = item.bkvr.json_data.debet_price - item.bkvr.json_data.kredit_price
						if (item.bkv.voucher_type === rec.start_account_voucher_type || idx === 0) {
							item.book_balance = item.book_value
							let bankRec = getBankBalance(item.bkv.target_date, item.book_value, item.book_balance)
							if (bankRec) {
								item.bank_statement_record_type = bankRec.record_type + '.' + bankRec.idx
								item.bank_statement_value = bankRec.value
								item.bank_statement_balance = bankRec.balance
								item.bank_statement_date = bankRec.date
							}
						} else {
							prevItem = data[idx - 1]
							item.book_balance = nc.round(prevItem.book_balance + item.book_value, rec.difference_round)
							if (idx < data.length - 1) {
								let nextItem = data[idx + 1]
								if (nextItem.bkv.target_date !== item.bkv.target_date) {
									let bankRec = getBankBalance(item.bkv.target_date, item.book_value, item.book_balance)
									if (bankRec) {
										item.bank_statement_record_type = bankRec.record_type + '.' + bankRec.idx
										item.bank_statement_value = bankRec.value
										item.bank_statement_balance = bankRec.balance //prevItem.bank_statement_balance + item.bank_statement_value
										item.bank_statement_date = bankRec.date
									}
								}
							}
						}
						if (
							item.book_balance &&
							item.bank_statement_balance &&
							(item.bkv.target_date === item.bank_statement_date || item.bkv.voucher_type === 6)
						) {
							item.balance_difference = nc.round(item.book_balance - item.bank_statement_balance, rec.difference_round)
						}
					}
				}
				nc.setRec(state, 'bankm', {})
				nc.gridActivateRows(state, 'bank_note', 0)
				// gridRowClicked(rec.table, 0, false)
			}
		}

		compareData(state)
		return { gridRowClicked, loadData, changeTab, jsonTextData }
	}
}
