// form/nc/nc-storage/nc-storage.js
// form/nc/nc-storage/init.json
export default {
	setup() {
		const unselectOther = true
		const productCount = ref(0)
		const materialCount = ref(0)
		const workCount = ref(0)
		const selectedMaterialCount = ref(0)
		const selectedWorkCount = ref(0)
		let selectedMaterialIdx = []
		let activatedMaterialIdx = []
		let selectedWorkIdx = []
		let activatedWorkIdx = []
		let productArr = []
		let materialArr = []
		let workArr = []

		function setSelectedWork(materialIdxArr) {
			selectedWorkIdx = workArr
				.filter(work => {
					if (work.material_idx == null) return false
					if (state.rec.only_material_phases === true && work.used_material_idx == null) return false
					const idx = materialIdxArr.findIndex(matIdx => {
						if (state.rec.only_material_phases === true && !work.used_material_idx.includes(matIdx)) return false
						if (!work.material_idx.includes(matIdx)) return false
						return true
					})
					return idx >= 0
				})
				.map(work => work.idx)
			if (state.rec.only_material_phases === true) {
				activatedWorkIdx = selectedWorkIdx
			} else {
				activatedWorkIdx = workArr
					.filter(work => {
						if (work.used_material_idx == null) return false
						if (!selectedWorkIdx.includes(work.idx)) return false
						const idx = materialIdxArr.findIndex(matIdx => {
							if (work.used_material_idx.includes(matIdx)) return true
							return false
						})
						return idx >= 0
					})
					.map(work => work.idx)
			}
		}

		function setSelectedProduct(materialIdx) {
			const productIdx = materialIdx.map(idx => {
				return materialArr[idx - 1].product_idx // indexes are 1 based
			})
			setTimeout(() => {
				nc.gridActivateRows(state, 'product', productIdx, 'scroll-last', unselectOther)
			}, 0)
		}

		function setSelectedMaterialIdx() {
			const selectedWorkNumber = materialArr.filter(mat => activatedMaterialIdx.includes(mat.idx)).map(mat => mat.prma.work_number)
			selectedMaterialIdx = materialArr.filter(mat => selectedWorkNumber.includes(mat.prma.work_number)).map(mat => mat.idx)
		}

		function setFilterArr(selectedItemArr, area) {
			if (area === 'all') {
				selectedMaterialCount.value = materialArr.length
				selectedWorkCount.value = workArr.length
				selectedMaterialIdx = materialArr.map(mat => mat.idx)
				activatedMaterialIdx = []
				selectedWorkIdx = workArr.map(work => work.idx)
				activatedWorkIdx = []
			} else {
				if (area === 'product') {
					if (selectedItemArr.length === 0) {
						setFilterArr(selectedItemArr, 'all')
					} else {
						const selectedProductIdx = selectedItemArr.map(prod => prod.idx)
						activatedMaterialIdx = materialArr.filter(mat => selectedProductIdx.includes(mat.product_idx)).map(mat => mat.idx)
						setSelectedMaterialIdx()
						setSelectedWork(activatedMaterialIdx)
					}
					setTimeout(() => {
						nc.gridActivateRows(state, 'product_material', activatedMaterialIdx, 'scroll-last', unselectOther)
						nc.gridActivateRows(state, 'product_work', activatedWorkIdx, 'scroll-last', unselectOther)
					}, 0)
				} else if (area === 'product_material') {
					if (selectedItemArr.length === 0) {
						activatedMaterialIdx = []
						selectedWorkIdx = workArr.map(work => work.idx)
						activatedWorkIdx = []
					} else {
						activatedMaterialIdx = selectedItemArr.map(mat => mat.idx)
						setSelectedWork(activatedMaterialIdx)
					}
					setSelectedProduct(activatedMaterialIdx)
					setTimeout(() => {
						nc.gridActivateRows(state, 'product_work', activatedWorkIdx, 'scroll-last', unselectOther)
					}, 0)
				} else if (area === 'product_work') {
					if (selectedItemArr.length === 0) {
						selectedMaterialIdx = materialArr.map(mat => mat.idx)
						activatedMaterialIdx = []
					} else {
						selectedMaterialIdx = []
						selectedItemArr
							.filter(work => work.material_idx != null)
							.forEach(work => {
								work.material_idx.forEach(idx => {
									if (!selectedMaterialIdx.includes(idx)) {
										// do not add same many times
										selectedMaterialIdx.push(idx)
									}
								})
							})
						activatedMaterialIdx = []
						selectedItemArr
							.filter(work => work.used_material_idx != null)
							.forEach(work => {
								work.used_material_idx.forEach(idx => {
									if (!activatedMaterialIdx.includes(idx)) {
										// do not add same many times
										activatedMaterialIdx.push(idx)
									}
								})
							})
					}
					// setSelectedMaterialIdx()
					setSelectedProduct(activatedMaterialIdx)
					setTimeout(() => {
						nc.gridActivateRows(state, 'product_material', activatedMaterialIdx, 'scroll-last', unselectOther)
					}, 0)
				}
			}
			selectedMaterialCount.value = selectedMaterialIdx.length
			selectedWorkCount.value = selectedWorkIdx.length
			nc.gridUpdateFilter(state, 'product_material')
			nc.gridUpdateFilter(state, 'product_work')
		}

		// function gridRowClicked(area, rowIndex, selected, event, deselect) {
		function gridRowClicked(area) {
			const selectedItemArr = nc.gridActivatedRecordArr(state, area)
			setFilterArr(selectedItemArr, area)
		}

		function checkboxClicked(checkboxName) {
			if (checkboxName === 'only_material_phases') {
				const arr = nc.gridActivatedRecordArr(state, 'product_material')
				setFilterArr(arr, 'product_material')
			}
		}

		function doesExternalFilterPass(node) {
			const area = node.gridOptionsWrapper.gridOptions.context.gridName
			let find
			switch (area) {
				case 'product':
					if (state.rec.find_product === '') return true
					find = state.rec.find_product.toLowerCase()
					return (
						node.data.pr.product_id.toLowerCase().includes(find) ||
						node.data.pr.work_number.toLowerCase().includes(find) ||
						node.data.pr.name.toLowerCase().includes(find)
					)
				case 'product_material':
					return selectedMaterialIdx.includes(node.data.idx)
				case 'product_work':
					if (!selectedWorkIdx.includes(node.data.idx)) return false
					if (state.rec.find_work === '') return true
					find = state.rec.find_work.toLowerCase()
					return (
						node.data.prwo.production_lot.toLowerCase().includes(find) ||
						node.data.prwo.resource_id.toLowerCase().includes(find) ||
						node.data.pr.product_id.toLowerCase().includes(find) ||
						node.data.pr.name.toLowerCase().includes(find) ||
						node.data.prwo.work_phase_state.toLowerCase().includes(find) ||
						node.data.prwo.json_data.substate.toLowerCase().includes(find)
					)
				// || node.data.pro.production_order_state.toLowerCase().includes(find)
				default:
					return true // should not come here
			}
		}

		function loadData(ret) {
			productArr = (ret.grid && ret.grid.product && ret.grid.product.data) || []
			materialArr = (ret.grid && ret.grid.product_material && ret.grid.product_material.data) || []
			workArr = (ret.grid && ret.grid.product_work && ret.grid.product_work.data) || []
			productCount.value = productArr.length
			materialCount.value = materialArr.length
			workCount.value = workArr.length
			setFilterArr(productArr, 'all')
		}

		function update() {
			nc.callServer(state, 'query', { name: 'form/nc/nc-storage/init.json', parameter: { save_result: state.rec.save_result } }, loadData)
			// nc.callServer(state, 'query', { name: 'form/nc/nc-storage/grid.json', parameter: { rec: {default_material_phase: state.rec.default_material_phase} } }, callback)
		}

		loadData(state) // calculate and select all after load or page change

		watchEffect(() => {
			if (state.rec.find_product) {
				console.debug(`* find_product: '${state.rec.find_product}'`)
			}
			nc.gridUpdateFilter(state, 'product')
		})

		watchEffect(() => {
			if (state.rec.find_work) {
				console.debug(`* find_work: '${state.rec.find_work}'`)
			}
			nc.gridUpdateFilter(state, 'product_work')
		})

		return {
			productCount,
			materialCount,
			workCount,
			selectedMaterialCount,
			selectedWorkCount,
			update,
			gridRowClicked,
			checkboxClicked,
			doesExternalFilterPass
		}
	}
}
