// extend esprima
/* global esprima */

var info = "javascript to AST parser, use: javascriptToAst(sourceText)"

// eslint-disable-next-line no-undef
javascriptToAst = function (sourceText) {
	var options = {}
	/*
  http://esprima.org/doc/index.html
  Option	When set to true:
  loc	Nodes have line and column-based location info
  range	Nodes have an index-based location range (array)
  raw	Literals have extra property which stores the verbatim source
  tokens	An extra array containing all found tokens
  comment	An extra array containing all line and block comments
  tolerant	An extra array containing all errors found, attempts to continue parsing when an error is encountered
  */
	options.comment = true
	options.range = true
	var syntax = esprima.parse(sourceText, options)
	return JSON.stringify(syntax)
}

// eslint-disable-next-line no-unused-expressions
info
