import { withKeys as _withKeys, createVNode as _createVNode, openBlock as _openBlock, createBlock as _createBlock } from '../../lib.js'

function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createBlock(
			'div',
			{
				class: ['ui input nc-input', { 'left icon': _ctx.isCalendar }],
				style: _ctx.container_style
			},
			[
				_createVNode(
					'input',
					{
						'data-lpignore': 'true',
						required: _ctx.required,
						type: _ctx.type,
						style: _ctx.calculatedStyle,
						class: _ctx.styleClass,
						disabled: _ctx.disabled,
						value: _ctx.recValueFormatted,
						placeholder: _ctx.placeholder,
						autocomplete: _ctx.autocomplete,
						tabindex: _ctx.disabled && -1,
						onKeydown: _cache[1] || (_cache[1] = _withKeys((...args) => _ctx.onEnterKey && _ctx.onEnterKey(...args), ['enter'])),
						onInput: _cache[2] || (_cache[2] = (...args) => _ctx.updateValue && _ctx.updateValue(...args)),
						onFocus: _cache[3] || (_cache[3] = (...args) => _ctx.onFocus && _ctx.onFocus(...args)),
						onBlur: _cache[4] || (_cache[4] = (...args) => _ctx.onBlur && _ctx.onBlur(...args))
					},
					null,
					46 /* CLASS, STYLE, PROPS, HYDRATE_EVENTS */,
					['required', 'type', 'disabled', 'value', 'placeholder', 'autocomplete', 'tabindex']
				)
			],
			6 /* CLASS, STYLE */
		)
	)
}

// /src/components/nc-input/nc-input.vue

//LastPass ignore: data-lpignore='true'
// <style src="../../lib/fomantic-ui/dist/components/label.css"></style>
// <style src="../../lib/fomantic-ui/dist/components/input.css"></style>
/*
LastPass ignore: data-lpignore='true'
*/
// /src/components/nc-input/nc-input.vue
// import '/src/lib/fomantic-ui/dist/components/input.css'
import createComponent from './nc-input-component.js'
// import NcDatePicker from '/src/components/nc-date-picker.vue'
// component.components = { NcDatePicker }
export default {
	render: render,
	...createComponent('NcInput')
}
