// plugin/vue-renderer/index2.js

import { renderPage } from './render.js'

let state = `{
	"rec": {
		"show_bacode": true,
		"logo_path_local": "~/nc/nc-server/preference/report/logo.png",
		"pallet": 1,
		"pallet_count": 6,
		"co": {
			"name": "Tukkukuoma Ky"
		},
		"pr": {
			"product_id": "MA POHJA"
		},
		"ord": {
			"company_reference_number": "101202",
			"json_data": {
				"mark": "Merkki 12"
			},
			"delivery_address": "Alf Sunden\\nTaitoniekantie 9 E 308\\n40740 Jyväskylä\\nSuomi\\nFinland",
			"your_reference": "Juhani Kaltio"
		},
		"ordr": {
			"dispatch_note_id": "110092",
			"order_id": "110334"
		}
	},
	"hdr": {
		"co": {
			"name": "Tilaaja:"
		},
		"pallet_label": {
			"header": "Kollilappu",
			"dispatch_note": "Lähetyslista",
			"show_bacode": "Näytä viivakoodi",
			"update": "Hae"
		},
		"product_label": {
			"date": "20.12.2020",
			"header": "Tuotetarra",
			"label_count": "Määrä",
			"product_id": "Tuotetunnus",
			"production_lot": "Valmistuserä",
			"update": "Hae",
			"option1": "Pinnoittamaton",
			"option2": "(WC) WC-Pinnoitettu",
			"option3": "(EL) Eloksoitu",
			"option4": "(KOVAEL) Kovaeloksoitu"
		}
	}
}`

let html = `<!-- form/nc/report/pallet-label/pallet-label.html -->
<nc-form id='pallet-label'>
	<nc-row v-if='!rec.printing'>
		<nc-header size='medium'>{{hdr.pallet_label.header}}</nc-header>
	</nc-row>
	<nc-row v-if='!rec.printing'>
		<nc-col width='10em'>
			<nc-label model='hdr.pallet_label.dispatch_note'>Dispatch note</nc-label>
		</nc-col>
		<nc-col class='nc-padding-right' width='2/12'>
			<nc-input model='rec.dispatch_note' v-on:blur='update'></nc-input>
		</nc-col>
		<nc-col width='12em'>
			<nc-checkbox model='rec.show_bacode'>
				<nc-translate model='hdr.pallet_label.show_bacode'>Show barcode</nc-translate>
			</nc-checkbox>
		</nc-col>
		<nc-col class='nc-end-h' width='auto'>
			<nc-button primary='primary' v-on:click.native='printPdf'>
				<nc-icon icon='file-pdf'></nc-icon>
				<nc-translate model='hdr.pallet_label.print_pdf'>Print pdf</nc-translate>
			</nc-button>
			<nc-button primary='primary' v-on:click.native='update'>
				<nc-icon icon='sync'></nc-icon>
				<nc-translate model='hdr.pallet_label.update'>Update</nc-translate>
			</nc-button>
		</nc-col>
	</nc-row>
	<nc-row v-if='!rec.printing'>
		<nc-grid height='20vh' id='order_row' model='grid.order_row' v-on:grid-row-clicked='gridRowClicked'></nc-grid>
	</nc-row>
	<nc-row class='nc-margin-top' v-if='!rec.printing'></nc-row>
	<nc-row height='35.29vw' info='141/200mm' print-height='100%' print-width='100%' v-show='rec.show_bacode' width='50vw'>
		<nc-rect class='nc-align-top'>
			<nc-row height='89/141'>
				<nc-col class='nc-align-top' width='138/220'>
					<nc-label-textarea
						class='nc-overflow-auto'
						input_style='line-height:100%; font-size:60px; padding:0.5px; fit-text:grow'
						model='rec.ord.delivery_address'
						rows='5'
						>Toimitusosoite</nc-label-textarea
					>
				</nc-col>
				<nc-line-v></nc-line-v>
				<nc-col height='100%' width='auto'>
					<nc-row class='nc-align-top' height='50%'>
						<nc-label-input input_style='font-size:48px; text-align:center; align-self:center; padding: 0em' model='rec.ordr.order_id'
							>Myyntitilaus</nc-label-input
						>
					</nc-row>
					<nc-line></nc-line>
					<nc-row class='nc-align-top' height='50%'>
						<nc-label-input
							input_style='font-size:48px; text-align:center; align-self:center; padding: 0em'
							model='rec.ordr.dispatch_note_id'
							>Lähetyslista</nc-label-input
						>
					</nc-row>
				</nc-col>
			</nc-row>
			<nc-line></nc-line>
			<nc-row height='52/141'>
				<nc-col class='nc-center-h' style='padding: 4px' width='138/220'>
					<nc-barcode code-width='4' format='CODE128' model='rec.ordr.dispatch_note_id'></nc-barcode>
				</nc-col>
				<nc-line-v></nc-line-v>
				<nc-col height='100%' width='auto'>
					<nc-row class='nc-align-top' height='50%'>
						<nc-col class='nc-center-h nc-center-v' height='100%' width='50%'>
							<nc-span style='line-height: 80px; font-size: 80px'>{{rec.pallet}}</nc-span>
						</nc-col>
						<nc-col class='nc-center-v' height='100%' width='auto'>
							<nc-span style='line-height: 100px; font-size: 50px'>/ {{rec.pallet_count}}</nc-span>
						</nc-col>
					</nc-row>
					<nc-line></nc-line>
					<nc-row class='nc-center-v nc-center-h' height='50%' style='padding: 6px'>
						<nc-image :src='rec.logo_path_local' height='30' image-style='object-fit:contain;' width='190'></nc-image>
					</nc-row>
				</nc-col>
			</nc-row>
		</nc-rect>
	</nc-row>
	<nc-row height='35.29vw' print-height='100%' print-width='100%' v-show='!rec.show_bacode' width='50vw'>
		<nc-rect class='nc-align-top'>
			<nc-row height='115.6/141'>
				<nc-col class='nc-align-top' width='179.4/220'>
					<nc-label-textarea
						class='nc-overflow-auto'
						input_style='line-height:100%; font-size:80px; padding:0.5px; fit-text: grow'
						model='rec.ord.delivery_address'
						rows='5'
						>Toimitusosoite</nc-label-textarea
					>
				</nc-col>
				<nc-line-v></nc-line-v>
				<nc-col height='100%' width='auto'>
					<nc-row class='nc-align-top' height='50%'>
						<nc-label-input
							input_style='font-size:42px; align-self:flex-start; padding: 0em; transform: translateY(2em) rotate(-90deg);'
							model='rec.ordr.order_id'
							>Myyntitilaus</nc-label-input
						>
					</nc-row>
					<nc-line></nc-line>
					<nc-row class='nc-align-top' height='50%'>
						<nc-label-input
							input_style='font-size:42px; align-self:flex-start; padding: 0em; transform: translateY(2em) rotate(-90deg);'
							model='rec.ordr.dispatch_note_id'
							>Lähetyslista</nc-label-input
						>
					</nc-row>
				</nc-col>
			</nc-row>
			<nc-line></nc-line>
			<nc-row height='12.7/141'>
				<nc-col width='1.2/10'>
					<nc-label model='rec.ord.your_reference' style='align-self: center'>Merkki:</nc-label>
				</nc-col>
				<nc-col width='4/10'>
					<nc-input
						input_style='font-weight:bold; font-size:20px; fit-text:fit; padding: 0em'
						model='rec.ord.json_data.mark'
						style='align-self: center'
					></nc-input>
				</nc-col>
				<nc-line-v></nc-line-v>
				<nc-col width='1.2/10'>
					<nc-label model='rec.ord.your_reference' style='align-self: center'>Viite:</nc-label>
				</nc-col>
				<nc-col width='auto'>
					<nc-input
						input_style='font-weight:bold; font-size:20px; fit-text:fit; padding: 0em'
						model='rec.ord.your_reference'
						style='align-self: center'
					></nc-input>
				</nc-col>
			</nc-row>
			<nc-line></nc-line>
			<nc-row height='12.7/141'>
				<nc-col width='1.2/10'>
					<nc-label model='rec.ord.company_reference_number' style='align-self: center'>Til. Nro.:</nc-label>
				</nc-col>
				<nc-col width='4/10'>
					<nc-input
						input_style='font-weight:bold; font-size:20px; fit-text:fit; padding: 0em'
						model='rec.ord.company_reference_number'
						style='align-self: center'
					></nc-input>
				</nc-col>
				<nc-line-v></nc-line-v>
				<nc-col width='1.2/10'>
					<nc-label model='rec.co.name' style='align-self: center'>Tilaaja:</nc-label>
				</nc-col>
				<nc-col width='auto'>
					<nc-input
						input_style='font-weight:bold; font-size:20px; fit-text:fit; padding: 0em'
						model='rec.co.name'
						style='align-self: center'
						>Tilaaja</nc-input
					>
				</nc-col>
			</nc-row>
		</nc-rect>
	</nc-row>
</nc-form>`

let printRet = ''
function print(arg) {
	if (printRet.length === 0) {
		printRet = arg
	} else {
		printRet += '\n' + arg
	}
}
if (typeof console === 'undefined') {
	console = { log: print }
}
if (typeof console.error === 'undefined') {
	console.error = arg => console.log('error: ' + arg)
	console.warn = arg => console.log('warning: ' + arg)
}

function renderPage2() {
	html = html.replaceAll('\t', ' ').replaceAll('\n', ' ')
	let arg = `{ "state": ${state}, "html": "${html}" }`
	let pageData
	let msg, i
	let count = 1
	// pageData = renderPage(arg) // warm-up
	let runTime = Date.now()
	for (i = 1; i <= count; i++) {
		pageData = renderPage(arg)
	}
	runTime = Date.now() - runTime
	msg = `${i - 1}. web page json length: ${pageData.length}`
	msg += `, total time: ` + (runTime / 1000).toFixed(4) + ` seconds, single time: ` + (runTime / count / 1000).toFixed(4) + ` seconds\n`
	console.log(msg)
	return pageData
}
String.moduleCall = renderPage2
printRet
