// plugin/vue-renderer/renderer/rollup.config.js
// run using: npx rollup -c

import { nodeResolve } from '@rollup/plugin-node-resolve'
import { terser } from 'rollup-plugin-terser'
import replace from '@rollup/plugin-replace'

export default {
	input: 'lib-import.js',
	output: {
		file: '../lib.js',
		format: 'es'
	},
	plugins: [
		nodeResolve(),
		replace({
			preventAssignment: true,
			'process.env.NODE_ENV': JSON.stringify('production'),
			__VUE_OPTIONS_API__: false,
			__VUE_PROD_DEVTOOLS__: false
		})
		// terser()
	]
}
