import { mergeProps as _mergeProps, createVNode as _createVNode, openBlock as _openBlock, createBlock as _createBlock } from '../../lib.js'

const _hoisted_1 = {
	class: 'nc-image',
	ref: 'root'
}

function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createBlock(
			'img',
			{
				class: 'nc-image',
				src: _ctx.src,
				style: _ctx.imageStyle
				// alt: _ctx.attrs.alt || ''
			},
			null,
			16 /* FULL_PROPS */,
			['src', 'alt', 'image-style']
		)
	)
}

// /src/components/nc-draw/nc-image.vue
// avif from: https://jakearchibald.com/2020/avif-has-landed/
// code from: https://stegosource.com/create-lazy-loading-image-component-faster-vue-js-apps/
// https://codesandbox.io/s/vue-lazy-load-image-ls9rh?fontsize=14&hidenavigation=1&module=%2Fsrc%2FApp.vue&theme=dark

// change 85 in css and code to change animation speed

// import { ref, computed, onBeforeUnmount, onMounted } from '../lib.js'

export default {
	render: render,
	name: 'NcImage',
	inheritAttrs: false,
	props: {
		src: {
			type: String,
			default: undefined
		},
		placeholder: {
			type: String,
			default: undefined
		},
		background: {
			type: String,
			default: undefined
		},
		imageStyle: {
			type: [String, Object],
			default: undefined,
			requred: false
		}
	}
	/*
	setup(props, ctx) {
		const root = ref() // div ref="root"

		const dataUrl = computed(() => {
			const { width, height } = ctx.attrs
			if (!width || !height) return ''
			// create a tiny png with matching aspect ratio as img
			const w = 100
			const canvas = document.createElement('canvas')
			canvas.width = w
			canvas.height = (height / width) * w
			return canvas.toDataURL()
		})

		let timeOut, observer
		onMounted(function () {
			const { src, srcset } = props
			const $el = root.value // ctx.parent.vnode.el
			observer = new IntersectionObserver(([entry]) => {
				const img = $el.querySelector(`.nc-img__img`)
				const placeholder = $el.querySelector(`.nc-img__placeholder`)
				img.onload = function () {
					delete img.onload
					$el.classList.add(`nc-img--loaded`)
					if (placeholder) {
						timeOut = setTimeout(() => {
							placeholder.remove()
						}, 85)
					}
				}
				if (entry.isIntersecting) {
					// Element is in viewport
					console.debug(
						`* lazy load image src='${src}' ${srcset ? ", srcset='" + srcset + "'" : ''}, width=${ctx.attrs.width}, height=${
							ctx.attrs.height
						}`
					)
					if (srcset) {
						img.srcset = srcset
					}
					img.src = src
					observer.disconnect()
				}
			})
			observer.observe($el)
		})

		onBeforeUnmount(function () {
			// this.$once('hook:beforeUnmount', () => {
			if (observer) observer.disconnect()
			if (timeOut) {
				clearTimeout(timeOut)
			}
			// })
		})

		return { root, dataUrl, attrs: ctx.attrs }
	} */
}
