// plugin/vue-renderer/renderer/compileVueFile.js
import fs from 'fs'
import pug from 'pug'
import sass from 'sass'

import { parse, compileScript, compileTemplate, compileStyle } from '@vue/compiler-sfc' // './lib.js'
import peg from './nc-peg.js' //'../../../../nc-designer/src/core/nc-peg.js'

let id = 10000
export function compileVueFile(srcPath, fileName, newComponentPath) {
	if (!fs.existsSync(newComponentPath + fileName + '.js')) {
		const content = fs.readFileSync(srcPath + fileName + '.vue', 'utf-8')
		const parsed = parse(content, { sourceMap: false, filename: fileName })
		id++
		const script = compileScript(parsed.descriptor, { id: 'nc-script-' + id, filename: fileName })
		let code = script.content // .replace('"vue"', '"./vue.js"')
		if (parsed.descriptor.template) {
			let html = parsed.descriptor.template.content
			if (parsed.descriptor.template.lang === 'pug') {
				const pugOptions = {}
				const fn = pug.compile(html, pugOptions)
				const pugLocals = {}
				html = fn(pugLocals)
			}
			id++
			const render = compileTemplate({ id: 'nc-template-' + id, source: html, filename: fileName }) // ssr: true
			// const name = peg.parseAfterLast(fileName, '/')
			code =
				render.code.replace('export function render', 'function render') +
				'\n' +
				code.replace(/export\s+default\s+\{/g, 'export default {' + `\n\trender: render,`)
			// const render = compile(parsed.descriptor.template.content) // works but gives a function, not code as text
		}
		const styleArr = []
		const scopedStyleArr = []
		for (const item of parsed.descriptor.styles) {
			let css = item.content
			if (item.lang === 'scss' || item.lang === 'sass') {
				const result = sass.renderSync({ data: css })
				css = result.css.toString()
			}
			id++
			const ret = compileStyle({ id: 'nc-style-' + id, source: css, filename: fileName })
			if (item.scoped) {
				scopedStyleArr.push(ret.code)
			} else {
				styleArr.push(ret.code)
			}
		}
		if (scopedStyleArr.length > 0) {
			console.log(`* component '${fileName}' scoped style:\n${scopedStyleArr}`)
			// TODO: add to ../component/nc-component-style.json
		}
		if (styleArr.length > 0) {
			console.log(`* component '${fileName}' style:\n${styleArr}`)
			// TODO: add to ../component/nc-component-style.json
		}
		const path = peg.parseBeforeLast(fileName, '/')
		if (path !== fileName && !fs.existsSync(newComponentPath + path)) {
			fs.mkdirSync(newComponentPath + path)
		}
		fs.writeFileSync(newComponentPath + fileName + '.js', code)
	}
	/*
	// import(dataUri) does needs full path for access to existing files: `import { fn } from 'file:///${process.cwd()}/dyn-import-existing.js'; fn(10);`
	// https://2ality.com/2019/10/eval-via-import.html
	const dataUri = 'data:text/javascript;charset=utf-8,' + encodeURIComponent(code)
	const ret = await import(dataUri)
	*/
	return import(newComponentPath + fileName + '.js')
}
