// plugin/vue-renderer/renderer/lib-import2.js
// optimized build, but compressed size is only 2kb smaller, no point of using this

export { withKeys } from '@vue/runtime-dom/dist/runtime-dom.esm-bundler.js'
export { toDisplayString } from '@vue/shared/dist/shared.esm-bundler.js'
export {
	reactive,
	provide,
	computed,
	inject,
	onMounted,
	ref,
	toRefs,
	defineComponent,
	createRenderer,
	createCommentVNode,
	createTextVNode,
	resolveComponent,
	withCtx,
	createVNode,
	openBlock,
	createBlock,
	renderSlot,
	mergeProps,
	Fragment
} from '@vue/runtime-core/dist/runtime-core.esm-bundler.js'

import * as runtimeDom from '@vue/runtime-dom/dist/runtime-dom.esm-bundler.js'
// import { initCustomFormatter, warn, registerRuntimeCompiler } from '@vue/runtime-dom/dist/runtime-dom.esm-bundler.js'
import { warn, registerRuntimeCompiler } from '@vue/runtime-dom/dist/runtime-dom.esm-bundler.js'
// export * from '@vue/runtime-dom'
import { compile } from '@vue/compiler-dom/dist/compiler-dom.esm-bundler.js'
import { isString, NOOP, extend, generateCodeFrame } from '@vue/shared/dist/shared.esm-bundler.js'

const compileCache = Object.create(null)
function compileToFunction(template, options) {
	if (!isString(template)) {
		if (template.nodeType) {
			template = template.innerHTML
		} else {
			warn(`invalid template option: `, template)
			return NOOP
		}
	}
	const key = template
	const cached = compileCache[key]
	if (cached) {
		return cached
	}
	if (template[0] === '#') {
		const el = document.querySelector(template)
		if (!el) {
			warn(`Template element not found or is empty: ${template}`)
		}
		template = el ? el.innerHTML : ``
	}
	const { code } = compile(
		template,
		extend(
			{
				hoistStatic: true,
				onError(err) {
					const message = `Template compilation error: ${err.message}`
					const codeFrame = err.loc && generateCodeFrame(template, err.loc.start.offset, err.loc.end.offset)
					warn(codeFrame ? `${message}\n${codeFrame}` : message)
				}
			},
			options
		)
	)
	// The wildcard import results in a huge object with every export
	// with keys that cannot be mangled, and can be quite heavy size-wise.
	// In the global build we know `Vue` is available globally so we can avoid
	// the wildcard object.
	const render = new Function('Vue', code)(runtimeDom)
	render._rc = true
	return (compileCache[key] = render)
}
registerRuntimeCompiler(compileToFunction)

export { compileToFunction as compile }
