// form/core/nc-input-form/nc-input-form.js
// import {mainState} from '/src/core/nc-main.js'

export default {
	setup() {
		const rec = state.rec
		const mainState = nc.mainState()
		const changeRecord = ref({})
		const saveEnabled = ref(false)
		let loadedRec = {}
		let listData = []
		let listRec = {}
		let listDataRec = null
		let listRow = ref(0) // not js 0-based but 1-based

		onLoad()
		// first load must be done before activated for rec.input_component to be set correctly and subcomponent to be drawn
		//	- otherwise component(:is='rec.input_component') does not detect change and does not draw subcomponent
		let loadDone = true
		onActivated(() => {
			mainState.rec.in_form = 'input'
			if (loadDone) {
				loadDone = false // for next activated
			} else {
				onLoad()
			}
		})

		onDeactivated(() => {
			mainState.rec.in_form = ''
			onUnload()
		})

		function onUnload() {
			delete mainState.inputValueChanged
			const listTableRec = listDataRec // && listDataRec[rec.table_prefix]
			const tableRec = rec[rec.table_prefix]
			nc.copyDeepRec(tableRec, listTableRec, rec.table_prefix) // copy back to list only values originally in list
			if (listTableRec) {
				listRec.record_id = listTableRec.record_id
			}
		}

		function clearChangeRecord() {
			loadedRec = nc.clone(rec)
			changeRecord.value = {}
			setSaveEnabled(false)
		}

		function serverCallback(ret, callOption) {
			if (callOption && callOption.direct_callback) {
				const listTableRec = listDataRec // && listDataRec[rec.table_prefix]
				const tableRec = ret.rec[rec.table_prefix]
				if (listTableRec && tableRec && listTableRec.record_id !== tableRec.record_id) {
					// console.debug('*** skip input callback ***')
					return false // fast click with arrows over this record, cancel running this callback
				}
				return true // call this again when normal state values has been set
			}
			if (nc.isObject(ret) && ret.rec && rec) {
				if (ret.rec.input_component && ret.rec.html) {
					state.html = ret.rec.html
					state.javascript = ret.rec.javascript
					delete ret.rec.html // do not create component on second call
					delete ret.rec.javascript
					delete rec.html
					delete rec.javascript
					const comp = nc.toComponent(state, state, 'input', ret.rec.input_component) // "input" is path
					delete state.html
					delete state.javascript
					if (comp) {
						nc.addComponent(comp)
						if (!mainState.arr.input_component_arr.includes(comp.name)) {
							mainState.arr.input_component_arr.push(comp.name)
						}
						nc.setArr(mainState, 'input_component_arr', mainState.arr.input_component_arr) // for debug
						rec.input_component = ret.rec.input_component
					} else {
						rec.input_component = ''
					}
				}
				const listTableRec = listDataRec // && listDataRec[rec.table_prefix]
				const tableRec = ret.rec[rec.table_prefix]
				if (listDataRec && listDataRec.changeRecord && !nc.isEmptyObject(listDataRec.changeRecord)) {
					// copy not-saved modified values from list to input, but what if list rec is outdated?
					// todo: copy only modified values by list changeRec
					const keysCopied = []
					nc.copyDeepRec(listTableRec, tableRec, rec.table_prefix, listDataRec.changeRecord, keysCopied)
					clearChangeRecord()
					if (keysCopied.length > 0) {
						// do we need this? - then you can't move to next record
						// setSaveEnabled(true)
					}
				}
			}
		}

		function setRecByRow() {
			if (listData && listRow.value > 0 && listRow.value <= listData.length) {
				listDataRec = listData[listRow.value - 1]
			} else {
				listDataRec = null
			}
			rec[rec.table_prefix] = listDataRec
			/* for (var key in listDataRec) {
				if (nc.isObject(listDataRec[key])) {
					// current state.rec table recs must change to new default from list, it will be updated by input -rest call
					if (rec[key] == null) {
						rec[key] = {} // changeRecord
					}
					nc.copyDeepRec(listDataRec[key], rec[key], rec.table_prefix) // rec[key] = nc.clone(listDataRec[key])
				}
			} */
			clearChangeRecord()
		}

		function getServerRec() {
			setRecByRow()
			if (rec[rec.table_prefix].record_id) {
				// record_id != ""
				if (listDataRec) {
					const param = {
						input_component_arr: mainState.arr.input_component_arr, // array of loaded components
						table: listRec.table,
						page: listRec.page
					}
					// copy table record_id to rest call param[tblPrefix].record_id
					// param[rec.table_prefix] = { record_id: rec.record_id }
					param[rec.table_prefix] = { record_id: rec[rec.table_prefix].record_id }
					nc.callServer(state, 'input', param, serverCallback, { direct_callback: true }) // direct_callback = do not set state variables
				} else {
					message.setWarning(state, `mainState.list row_index data does not exist`)
				}
			}
		}

		function onLoad() {
			mainState.inputValueChanged = inputValueChanged // inputValueChanged is function to be called from state rec change using nc.setRec()
			mainState.input = { save_enabled: saveEnabled.value }
			if (mainState.list) {
				listData = mainState.list.grid && mainState.list.grid.list && mainState.list.grid.list.data
				listRec = mainState.list.rec
				listRow.value = listRec.row_index
				setRecByRow()
				rec.table_prefix = listRec.table_prefix
				rec.table = listRec.table
				if (mainState.list.arr && mainState.list.arr.table) {
					// set table dropdown
					state.arr.table = mainState.list.arr.table
				} else {
					state.arr.table = []
				}
			}
			if (rec.input_component && rec.html) {
				// first load of nc-input-form -component and it's table page -component
				// when loading input form dynamically first time in nc-dynamic-component.js has set these call params, find 'form/core/nc-input-form'
				serverCallback(state)
			} else if (listData && listRow.value > 0) {
				getServerRec()
				// } else {
				// message.setWarning(state, `mainState.list data -array is missing`)
			}
		}

		const previousEnabled = computed(() => {
			return saveEnabled.value === false && listData.length > 1 && listRow.value > 1
		})

		const nextEnabled = computed(() => {
			return saveEnabled.value === false && listData.length > 1 && listRow.value < listData.length
		})

		function newRecord() {
			listRow.value = -1
			listDataRec = null
			nc.setRec(state, rec.table_prefix, nc.clearDeepRec(nc.clone(rec[rec.table_prefix]))) // nc.clone(rec)
			clearChangeRecord()
		}

		function arrow(move) {
			if (move === 'first' && previousEnabled) {
				listRow.value = 1
			} else if (move === 'previous' && previousEnabled) {
				listRow.value--
			} else if (move === 'next' && nextEnabled) {
				listRow.value++
			} else if (move === 'last' && nextEnabled) {
				listRow.value = listData.length
			} else {
				return
			}
			listRec.row_index = listRow.value
			getServerRec()
		}

		function tabClicked() {
			/* if (state.arr.tab) {
					// this should run only when state.arr.tab changes
					state.arr.tab = state.arr.tab.map(item => {
						if (item.query_name) item.icon = 'filter'
						return item
					})
				} */
			/* // updateToolbar(callParam, ret.arr)
				if (rec.table && rec.table !== callParam.rec.table) {
					mainState.rec.table = rec.table
				}
				setCallParamRec(callParam)
				if (!nc.isEqual(callParam.rec, prevCallParamRec)) {
					saveParam()
				} */
		}

		function setSaveEnabled(value) {
			saveEnabled.value = value
			mainState.input.save_enabled = value
		}

		function detectChange(fieldName, newValue) {
			const origValue = nc.recDataGet(loadedRec, fieldName)
			if (origValue !== newValue) {
				nc.recDataSet(changeRecord.value, fieldName, newValue)
			} else {
				const clearEmptySubkeyLevel = 2 // tbl.json_data.xxx
				nc.recDataSet(changeRecord.value, fieldName, undefined, clearEmptySubkeyLevel)
			}
			const tblRec = changeRecord.value[rec.table_prefix]
			setSaveEnabled(tblRec && !nc.isEmptyObject(tblRec))
		}

		function inputValueChanged(fieldName, newValue) {
			detectChange(fieldName, newValue)
			// TODO: call server and/or input form script
			if (fieldName == 'per.first_name') {
				if (newValue && rec.per.last_name) {
					rec.per.full_name = peg.concatWith(' ', newValue, rec.per.last_name)
					detectChange('per.full_name', rec.per.full_name)
				}
			} else if (fieldName == 'per.last_name') {
				if (newValue && rec.per.first_name) {
					rec.per.full_name = peg.concatWith(' ', rec.per.first_name, newValue)
					detectChange('per.full_name', rec.per.full_name)
				}
			}
			/*  	const param = {
				modify_rec: rec, // nc.recToServerRec(rec),
				field_name: fieldName,
				prev_value: previousValue,
				new_value: newValue,
				table: listRec.table || '' // linkRec.table ??
			}
			nc.callServer(state, 'input/script', param, ret => {
				detectChange(fieldName, newValue)
				if (ret.link_grid) {
					if (ret.link_grid.dialog_closed === true) {
						if (ret.link_grid.selected != null) {
							previousValue = rec[ret.link_grid.linking_field]
							newValue = ret.link_grid.selected
							rec[ret.link_grid.linking_field] = newValue
							inputValueChanged(fieldName, newValue, previousValue) // recursive call, run script after succesfull select
						}
						ref = mainScope.changeRecord.value
						for (key in ref) {
							if (key === inputName) {
								func = ref[key]
								if (typeof func === 'from_function') {
									func('change') // call element changed() function to update prev value
								}
							}
						}
						// break
						document.getElementById('rec.' + ret.link_grid.linking_field).focus()
					}
				} else {
					let ref = mainScope.changeRecord.value
					for (key in ref) {
						func = ref[key]
						if (key === inputName) {
							if (typeof func === 'from_function') {
								func('change') // call element changed() function to update prev value
							}
						}
					}
				}
			})*/
		}

		function callServer(action) {
			if (action === 'duplicate' && saveEnabled.value === true) {
				// duplicate button disable is not always fast enough
				return
			}
			let call, callParam
			let callFunction = nc.callServer
			let param = {
				table: listRec.table,
				[rec.table_prefix]: rec[rec.table_prefix]
			}
			if (action) {
				param.action = action
			}
			if (action === 'init') {
				return // table change
			} else if (action === 'save') {
				if (rec.confirm_save) {
					const save = confirm('Tallennetaanko tehdyt muutokset?')
					if (save !== true) {
						return
					}
				}
				call = 'save'
				callFunction = nc.saveArray
				callParam = rec.table
				const tblRec = nc.clone(rec[rec.table_prefix])
				const jsonDataIsString = typeof tblRec.json_data === 'string'
				if (jsonDataIsString) {
					tblRec.json_data = nc.fromJson(tblRec.json_data)
				}
				param = [{ [rec.table_prefix]: tblRec }]
			} else if (action === 'revert') {
				// call = 'input/duplicate'
				let revert = true
				if (rec.confirm_revert) {
					revert = confirm('Perutaanko tehdyt muutokset?')
				}
				if (revert == true) {
					nc.setRec(state, rec.table_prefix, loadedRec[rec.table_prefix])
					clearChangeRecord()
				}
				return
			} else if (action === 'duplicate') {
				call = 'duplicate'
			} else {
				message.setWarning(state, `action '${action} is not valid`)
				return
			}
			let grid = null
			if (call === 'input/revert' || call === 'input/duplicate') {
				// call === 'input/save' ||
				if (grid) {
					param.grid_data = {}
					for (let key in grid) {
						let val = ref[key]
						if (val && val.table != null && val.data != null) {
							param.grid_data[val.table] = val.data
						}
					}
				}
			}
			// param.table = listRec.table
			// param.tab = rec.tab # just return it back - is this needed?
			callParam = callParam || call
			callFunction(state, callParam, param, ret => {
				if (call === 'save') {
					for (const tbl of ret.save) {
						if (!nc.isArray(tbl.data)) {
							return message.setWarning(state, `Tallennuksen tulos ei sisällä 'data' -taulukkoa`)
						}
						for (const item of tbl.data) {
							if (action === 'save') {
								if (item == null) {
									return message.setWarning(state, `Tallennuksen tulos ei sisällä '${rec.table_prefix}' -objektia`)
								}
								rec[rec.table_prefix] = item[rec.table_prefix]
								const listTableRec = listDataRec && listDataRec[rec.table_prefix]
								const tableRec = rec[rec.table_prefix]
								nc.copyDeepRec(tableRec, listTableRec, rec.table_prefix)
							}
						}
					}
				} else if (call === 'input/save' || call === 'input/revert' || call === 'input/duplicate') {
					/* ref = mainScope.recChanged
					for (key in ref) {
						func = ref[key]
						if (typeof func === 'from_function') {
							func('clear') // call element changed() function to update to new initial value
						}
					}
					mainScope.recChanged = {}
					if (call === 'input/duplicate') {
						mainScope.recChanged.duplicate = true // set main rec save + ok to non.disabled
					} */
				}
				if (ret.grid_data && !nc.isEmptyObject(ret.grid_data)) {
					/* 	ref1 = ret.grid_data
					for (tbl in ref1) {
						arr = ref1[tbl]
						ref2 = grid
						for (gridName in ref2) {
							grid = ref2[gridName]
							if (grid.table === table) {
								if (nc.isEmptyObject(arr)) {
									grid.data.splice(0, grid.data.length)
								} else if (arr.length < grid.data.length) {
									toDelete = arr.length - grid.data.length
									grid.data.splice(arr.length, toDelete)
								}
								row = 0
								for (i = 0, len = arr.length; i < len; i++) {
									rec = arr[i]
									if (!grid.data[row]) {
										grid.data[row] = {}
									}
									nc.textRecToRec(rec, grid.data[row], 'js_date')
									row = row + 1
								}
								grid.refreshRows()
								break
							}
						}
					} */
				}
				if (call === 'input/save' || call === 'input/duplicate') {
					// addToSelection(call, ret.rec)
				}
				if (ret.status === 'ok') {
					clearChangeRecord()
				}
			})
		}

		return { rec, saveEnabled, previousEnabled, nextEnabled, newRecord, onLoad, arrow, tabClicked, callServer }
	}
}
