// form/nc/erp-sync/erp-sync.js

export default {
	setup() {
		const loc = reactive({
			selectedRowRecord: null,
			selectedRecord: { local: null, external: null },
			tabIndex: 0, // { local: 0, external: 0 }. tabIndex is same for both, there is only one tab for both areas
			tabPrevLoadTime: 0,
			tabRefreshSeconds: 1.0,
			sort: {},
			columnState: {}
		})

		function tabChanged(value, idx) {
			// tabChanged(value, idx, event, tabArrValue)
			if (idx === loc.tabIndex) {
				let newTime = new Date()
				if (dt.secondsBetween(loc.tabPrevLoadTime, newTime) < loc.tabRefreshSeconds) {
					return
				}
			}
			if (!nc.isNil(idx)) loc.tabIndex = idx
			// loc.tabIndex.external = loc.tabIndex // external tab is not shown, keep tabs in sync
			loc.selectedRecord.local = null // this.$set(loc.selectedRecord, 'local', null)
			loc.selectedRecord.external = null // this.$set(loc.selectedRecord, 'external', null)
			nc.setGrid(state, 'local', Object.assign({}, state.grid.local))
			nc.setGrid(state, 'external', Object.assign({}, state.grid.external))
			state.grid.local.data = []
			state.grid.external.data = [] // clear data from screen
			loadRows('local') // better to have 2 calls, local answer will be faster
			loadRows('external')
			let table = tabValue('local')
			nc.gotoUrl(state, {
				name: 'erp-sync',
				query: { table: table, connection: state.rec.connection } // + '?connection=' + state.rec.connection
			})
			loc.tabPrevLoadTime = new Date()
		}

		function showRows() {
			nc.gridUpdateFilter(state, 'local')
			nc.gridUpdateFilter(state, 'external')
		}

		function tabValue(area) {
			area = 'local' // always use local, external tab does not exist
			let idx = loc.tabIndex
			if (nc.isNil(idx)) return
			return (state.arr && state.arr.tab && state.arr.tab[area] && state.arr.tab[area][idx] && state.arr.tab[area][idx].value) || ''
		}

		function getRowTablePrefix(table) {
			return state.rec.table_prefix[table] + 'r'
		}

		function gridSortChanged(area, columnState) {
			const areaName = tabValue(area)
			loc.columnState[areaName] = columnState
		}

		function gridRowClicked(area, rowIndex, selected, event) {
			// this.$set and loc.selectedRecord[area] must be used in buttonEnabled() to trigger calls to buttonEnabled()
			let arr = selectedRecordArr(area)

			loc.selectedRecord[area] = null // this.$set(loc.selectedRecord, area, null) // loc.selectedRecord[area] = null // force change, if new value is same value as previous then this.$set() does nothing and it does not trigger buttonEnabled() call
			if (event) {
				// nc.gridDeselectRows(state, otherArea(area))
				nc.gridActivateRows(state, otherArea(area), event.data.link_rec_idx, true, true)
			}
			// 0 is not a truthy value, that's why we use rowIndex + 1
			if (selected) {
				// loc.selectedRecord will be set on loadRecordRows() callback
				loadRecordRows(area, arr[0])
			} else {
				// was deselected
			}
		}

		function loadRecordRows(area, rec) {
			console.debug('loadRecordRows', area, rec)
			let grid = state.grid[area]
			let table = tabValue(area)
			let tablePrefix = state.rec.table_prefix[table]
			if (area === 'local' && grid && (table === 'order-salesX' || table === 'order-purchase')) {
				let rowTablePrefix = getRowTablePrefix(table)
				let recordType = state.rec.record_type[table]
				// let rec = grid.data[rowIndex]
				let param = {
					name: `form/nc/erp-sync/${state.rec.connection}/query-${state.rec.main_connection}/order_row-${recordType}.json`,
					parameter: {
						// "tag": tablePrefix,
						// "flat_table": rowTablePrefix,
						record_id: rec[tablePrefix].record_id,
						column: `form/nc/erp-sync/${state.rec.connection}/column/order_row-${recordType}.json`
					}
				}
				nc.callServer(state, 'query/data', param, ret => {
					if (ret.data) {
						rec[tablePrefix][rowTablePrefix] = ret.data
						console.debug(`loadRecordRows callback rec, result: `, rec, ret)
					}
					loc.selectedRecord[area] = rec // this.$set(loc.selectedRecord, area, rec)
					loc.selectedRowRecord = rec && rec[tablePrefix]
				})
			} else {
				loc.selectedRecord[area] = rec // this.$set(loc.selectedRecord, area, rec)
				loc.selectedRowRecord = rec && rec[tablePrefix]
			}
		}

		function loadRows(area, rowIndex, event) {
			let table = tabValue(area)
			let call = {
				// return: { grid: [{ name: 'external', tab: table }] }, // get initial return from rec.json
				// parameter: { table: table } // get initial from rec.json
			}
			let queryTab
			let callback = data => {
				if (data) {
					changeConnection()
					setGridData(area, loc.grid || state.grid)
					if (loc.grid) {
						table = tabValue(area)
						if (state.grid && state.grid.sort) {
							if (loc.columnState[table]) {
								state.grid.sort = loc.columnState[table]
							} else {
								loc.columnState[table] = state.grid.sort
							}
						}
						if (!nc.isNil(rowIndex)) {
							gridRowClicked(otherArea(area), rowIndex, true)
						}
					}
				}
			}
			queryTab = (area, table) => {
				call.name = 'form/nc/erp-sync/' + state.rec.connection + '/grid.json'
				call.return = {
					grid: [
						{
							name: area,
							tab: table
						}
					]
				}
				nc.callServer(state, 'query', call, callback)
			}
			if (event !== 'created' && table !== '') {
				queryTab(area, table)
			} else {
				// first call, set tab index on callback
				call.name = 'form/nc/erp-sync/init.json'
				let connection = nc.searchParameter('connection')
				table = nc.searchParameter('table')
				if (connection || table) {
					call.parameter = {}
					if (connection) {
						// todo: check connection validity
						call.parameter.connection = connection
						state.rec.connection = connection
					}
					if (table) {
						call.parameter.table = table // todo: check table validity
					}
				}
				nc.setGrid(state, 'local', null)
				nc.setGrid(state, 'external', null)
				if (state.rec.connection) {
					call.grid = 'form/nc/erp-sync/' + state.rec.connection + '/grid.json'
				}
				nc.callServer(state, 'query', call, ret => {
					if (ret && ret.rec && ret.rec.tab) {
						// setTimeout(() => {
						// we need setTimeout for tab to change, this.$nextTick is not enough

						for (let area in ret.rec.tab) {
							if (area === 'local') {
								// only local tab is in use
								let idx = nc.recordArrayIndex(state.arr.tab[area], 'value', ret.rec.tab[area])
								if (!nc.isNil(idx) && idx !== loc.tabIndex) {
									if (idx < 0) {
										// ne need for error, we may have changed connection and old table does not exist any more
										// message.setError(state, `tab index default value '${ret.rec.tab[area]}' was not found from tab array`)
										idx = 0
									}
									// we need $nextTick here so that index is set after tab is drawn
									console.debug('+++++ loc.tabIndex', idx, loc.tabIndex)
									loc.tabPrevLoadTime = new Date() // prevent double-load
									loc.tabIndex = idx // this.$set(loc.tabIndex, area, idx)
								}
								loadRows('local') // local load is much faster, better to draw it first
								loadRows('external')
							}
							callback(ret)
						}
						// }, 0)
					}
				})
			}
		}

		function selectedRecordArr(area) {
			return nc.gridActivatedRecordArr(state, area)
		}

		function buttonEnabled(button) {
			if (!state.rec.import_allowed) {
				// not initialized yet
				return false
			}
			if (button === 'export') {
				let area = 'local'
				let table = tabValue(area)
				let allowed = state.rec.export_allowed[state.rec.connection]
				allowed = allowed && allowed[table]
				if (
					loc.selectedRecord[area] &&
					(allowed ||
						table === 'product' ||
						table === 'customer' ||
						(table === 'order-sales' && state.rec.connection !== 'woocommerce') ||
						table === 'order-purchase')
				) {
					let arr = selectedRecordArr(area)
					if (arr.length < 1) return
					if (table === 'order-salesX' || table === 'order-purchase') {
						let prefix = state.rec.table_prefix[table]
						let rowPrefix = getRowTablePrefix(table)
						return arr[0][prefix][rowPrefix] != null
					}
					return true
				}
				return false
			} else if (button === 'import') {
				let area = 'external'
				let table = tabValue(area)
				let allowed = state.rec.import_allowed[state.rec.connection]
				allowed = allowed && allowed[table]
				if (loc.selectedRecord[area] && (allowed || table === 'product' || table === 'order-sales')) {
					let arr = selectedRecordArr(area)
					if (arr.length > 0) {
						// } && state.rec.allow_existing_product_import === true) {
						/* 	if (arr.length > 1 && table === 'order-sales') {
							return false
						} */
						if (table === 'product') {
							return arr.every(() => {
								return state.rec.product_id && (state.rec.change_status === 'new' || state.rec.change_status === 'changed')
							})
						}
						return arr.every(item => {
							return item.change_status === 'new'
						})
					}
				}
				return false
			} else if (button === 'delete') {
				let area = 'external'
				let table = tabValue(area)
				if (loc.selectedRecord[area] && (table === 'product' || table === 'customer')) {
					let arr = selectedRecordArr(area)
					if (arr.length < 1) return false
					if (table === 'product' && arr[0].product_id === '') {
						return false
					}
					return true
				}
				return false
			}
			return false
		}

		function isExternalFilterPresent() {
			if (state.rec.show_new !== true || state.rec.show_changed !== true || state.rec.show_equal !== true) {
				return true
			}
			return false
		}

		function doesExternalFilterPass(node) {
			switch (node.loc.change_status) {
				case 'new':
					return !(state.rec.show_new === false)
				case 'equal':
					return !(state.rec.show_equal === false)
				case 'changed':
					return !(state.rec.show_changed === false)
				default:
					return true
			}
		}

		function setGridData(area, grid) {
			let table = tabValue(area)
			// let grid = state.grid
			let localData = grid && grid.local && grid.local.data
			let externalData = grid && grid.external && grid.external.data
			let otherIdx = -1
			let tablePrefix = state.rec.table_prefix[table]
			let compareField = state.rec.compare_field[table]
			if (localData && localData.length > 0) {
				// init local calculated data
				for (let i = 0; i < localData.length; i++) {
					let rec = localData[i]
					rec.link_rec_idx = -1
					rec.link_rec = null
					rec.change_status = 'new'
				}
			}
			if (externalData && externalData.length > 0) {
				// init external calculated data and set status on both data
				let doNotCompareFields = grid.external.column
					.filter(rec => rec.change_compare === false)
					.reduce((acc, rec) => {
						acc[rec.field || rec.variable] = true
						return acc
					}, {})
				doNotCompareFields.link_rec_idx = true
				doNotCompareFields.link_rec = true
				doNotCompareFields.change_status = true

				let compareRecord = (rec, i) => {
					if (table === 'order-sales' || table === 'order_row-sales' || table === 'order-purchase') {
						if (localData && localData.length > 0 && localData[0][tablePrefix] && externalData[0]) {
							otherIdx = localData.findIndex(rec2 => {
								if (!rec2[tablePrefix] || nc.isNil(rec2[tablePrefix][compareField])) {
									if (rec[tablePrefix] && !nc.isNil(rec[tablePrefix][compareField])) {
										// no warning if both are null
										message.setWarning(state, `tablePrefix '${tablePrefix}' compareField '${compareField}' data is null`)
									}
									return false
								} else if (!rec[tablePrefix] || nc.isNil(rec[tablePrefix][compareField])) {
									message.setWarning(state, `compareField '${compareField}' data is null`)
									return false
								}
								return (
									// 1 and "1" must be true here. so do not use ===, use ==
									// eslint-disable-next-line eqeqeq
									// rec[tablePrefix][compareField].toString().toLowerCase() == rec2[tablePrefix][compareField].toString().toLowerCase()
									rec[tablePrefix][compareField].toString().toLowerCase().trimEnd() ==
									rec2[tablePrefix][compareField].toString().toLowerCase().trimEnd()
								)
							})
						}
					} else {
						if (localData && localData.length > 0 && localData[0][tablePrefix] && externalData[0][tablePrefix]) {
							if (!rec[tablePrefix] || nc.isNil(rec[tablePrefix][compareField])) {
								message.setWarning(state, `tablePrefix '${tablePrefix}' compareField '${compareField}' data is null`)
								return false
							} else {
								otherIdx = localData.findIndex(rec2 => {
									return (
										// 1 and "1" must be true here. so not ===, use ==
										// eslint-disable-next-line eqeqeq
										rec[tablePrefix][compareField].toString().toLowerCase() == rec2[tablePrefix][compareField].toString().toLowerCase()
									)
								})
							}
						}
					}
					if (otherIdx >= 0) {
						rec.link_rec_idx = otherIdx
						rec.link_rec = localData[otherIdx]
						if (table === 'order-sales' || table === 'order-purchase') {
							rec.order_id = rec.link_rec.order_id
							rec.record_id = rec.link_rec.record_id
						} else if (table === 'product') {
							rec.record_id = rec.link_rec.record_id
						}
						const failField = {} // for debugging changes
						rec.change_status = nc.isEqualLoose(rec, localData[otherIdx], doNotCompareFields, state.rec.warning_sign, failField)
							? 'equal'
							: 'changed'
						localData[otherIdx].link_rec_idx = i
						localData[otherIdx].link_rec = rec // link_rec will be circular reference
						localData[otherIdx].change_status = rec.change_status
					} else {
						// console.debug(state, `   local record was not found for rec[tablePrefix][compareField], tablePrefix '${tablePrefix}' compareField '${compareField}', table '${table}'`)
						rec.link_rec = null
						rec.link_rec_idx = -1
						rec.change_status = 'new'
						if (table === 'order-sales' || table === 'order-purchase') {
							rec.order_id = ''
							rec.record_id = ''
						} else if (table === 'product' && rec.pr) {
							rec.record_id = ''
						}
					}
				}
				/* if (changedRec) {
					compareRecord(changedRec, -1)
				} else { */
				for (let i = 0; i < externalData.length; i++) {
					compareRecord(externalData[i], i)
				}
				// }
				// update grids
				nc.setGrid(state, 'local', Object.assign({}, state.grid.local))
				nc.setGrid(state, 'external', Object.assign({}, state.grid.external))
			}
		}

		function changeConnection(updateData) {
			// nc.setArr(state, 'tab', state.arr.tab)
			if (updateData) {
				tabChanged()
			}
			if (state.rec && state.rec.logo_path_external_template)
				nc.setRec(state, 'logo_path_external', state.rec.logo_path_external_template.replace('_connection_', state.rec.connection))
		}

		function otherArea(area) {
			return area === 'local' ? 'external' : 'local'
		}

		function saveRows(area, action) {
			let table = tabValue(area)
			let arrOrig = selectedRecordArr(area)
			let prefix = state.rec.table_prefix[table]
			if (!prefix) {
				alert(`save table '${table}' is not valid`)
				return
			}
			let column = state.grid[area].column
			if (!column || column.length < 1) {
				alert(`save table '${table}' column do not exist`)
				return
			}
			let arr = arrOrig.reduce((acc, item, idx) => {
				delete item.link_item // we MUST delete this object or next functions and toJson will fail with infinite loop
				delete item.idx
				delete item.link_item_idx
				delete item.change_status
				acc[idx] = item
				return acc
			}, [])
			let param = {}
			let preferenceName
			if (action === 'import') {
				preferenceName = 'form/nc/erp-sync/' + state.rec.main_connection + '/save/' + table + '.json'
			} else if (action === 'export') {
				preferenceName = 'form/nc/erp-sync/' + state.rec.connection + '/save/' + table + '.json'
			}
			let callb = ret => {
				// if (action === 'import' || action === 'export') {
				loadRows(otherArea(area))
				// }
				if (ret.result) {
					alert(ret.result)
				}
			}
			if (action === 'import') {
				param.save = [{ table: table, data: arr, save_preference: preferenceName }]
			} else if (action === 'export') {
				param.save = [{ table: table, data: arr, save_preference: preferenceName }]
				param = { save: [param] }
			} else if (action === 'delete') {
				let doDelete
				if (table === 'product') {
					doDelete = confirm(`Are you sure you want to delete ${table} id ${arr[0].product_id} ?`)
				} else if (table === 'company') {
					doDelete = confirm(`Are you sure you want to delete ${table} id ${arr[0].company_id} ?`)
				}
				if (doDelete === false) return
				const arr2 = arr.map(rec => {
					return rec[prefix].json_data.transfer_id
				})
				param.delete = [{ table: table, data: arr2 }]
			} else {
				message.setWarning(state, 'action is not export or delete')
				return
			}
			nc.saveJson(state, param, callb)
		}

		function init() {
			console.debug('nc-erp-sync created')
			loadRows('local', 0, 'created') // first call will be init, it will load both areas at the same call
		}
		init()
		return Object.assign(
			{
				// tabLocal,
				doesExternalFilterPass,
				isExternalFilterPresent,
				gridRowClicked,
				gridSortChanged,
				changeConnection,
				loadRows,
				showRows,
				buttonEnabled,
				saveRows,
				tabChanged
			},
			toRefs(loc)
		)
	}
}
