import {
	renderSlot as _renderSlot,
	resolveComponent as _resolveComponent,
	withCtx as _withCtx,
	createVNode as _createVNode,
	openBlock as _openBlock,
	createBlock as _createBlock
} from '../../lib.js'

function render(_ctx, _cache) {
	const _component_nc_label = _resolveComponent('nc-label')
	const _component_nc_input = _resolveComponent('nc-input')
	const _component_nc_form_field = _resolveComponent('nc-form-field')

	return (
		_openBlock(),
		_createBlock(
			_component_nc_form_field,
			{ class: 'nc-label-input' },
			{
				default: _withCtx(() => [
					_createVNode(
						_component_nc_label,
						{
							model: _ctx.hdrModel,
							hdr: _ctx.hdr,
							'label-style': _ctx.labelStyle
						},
						{
							default: _withCtx(() => [_renderSlot(_ctx.$slots, 'default')]),
							_: 3 /* FORWARDED */
						},
						8 /* PROPS */,
						['model', 'hdr', 'label-style']
					),
					_createVNode(
						_component_nc_input,
						{
							container_style: _ctx.container_style,
							input_style: _ctx.input_style,
							required: _ctx.required,
							disabled: _ctx.disabled,
							model: _ctx.model,
							value: _ctx.value,
							onInput: _cache[1] || (_cache[1] = $event => _ctx.updateValue($event)),
							onFocus: _cache[2] || (_cache[2] = $event => _ctx.onFocus($event)),
							onBlur: _cache[3] || (_cache[3] = $event => _ctx.onBlur($event))
						},
						null,
						8 /* PROPS */,
						['container_style', 'input_style', 'required', 'disabled', 'model', 'value']
					)
				]),
				_: 1 /* STABLE */
			}
		)
	)
}

// /src/components/nc-input/nc-label-input.vue
// test: <input class="ui input"
// import NcInput from '/src/components/nc-input/nc-input.vue'
// import { addComponent } from '/src/core/nc-main.js'
import createComponent from './nc-input-component.js'

// addComponent(NcInput)
export default {
	render: render,
	...createComponent('NcLabelInput')
}
/* .nc-label-input {
	display: flex;
	flex-basis: 100%;
} */
/* semantic todo: nc-label-input */
/* .ui.form .inline.fields {
	margin-bottom: 0.1em;
} */
