// nc-draw/nc-icon.js
import { resolveComponent as _resolveComponent, openBlock as _openBlock, createBlock as _createBlock } from '../../vuelib.js'

export function render(_ctx, _cache) {
  const _component_Icon = _resolveComponent("Icon")

  return (_openBlock(), _createBlock(_component_Icon, {
    class: "nc-icon",
    icon: "fa:" + _ctx.icon,
    "data-icon": _ctx.icon
  }, null, 8 /* PROPS */, ["icon", "data-icon"]))
}
// see: nc-sui-icon

/*
<svg class="svg-inline--fa fa-caret-down fa-w-10" aria-hidden="true" focusable="false" data-prefix="far" data-icon="caret-down" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" data-fa-i2svg=""><path fill="currentColor" d="M272 160H48.1c-42.6 0-64.2 51.7-33.9 81.9l111.9 112c18.7 18.7 49.1 18.7 67.9 0l112-112c30-30.1 8.7-81.9-34-81.9zM160 320L48 208h224L160 320z"></path></svg>
*/
// import Iconify from '@iconify/iconify/dist/iconify.without-api.min.js'
// import icons from '../../lib/font-awesome/nc-regular-icons.json'
// import { Icon, addCollection } from '@iconify/vue'

if (typeof icons !== 'undefined') {
	const icons2 = Object.keys(icons).reduce((acc, key) => {
		acc[key] = {
			body: `<path d="${icons[key][4]}" fill="currentColor"/>`,
			width: icons[key][0],
			height: icons[key][1]
		}
		return acc
	}, {})
	// Iconify.addCollection({ // iconify.without-api
	addCollection({
		prefix: 'fa',
		icons: icons2
	})
}

export default {
	name: 'NcIcon',
	// components: { Icon },
	props: {
		icon: {
			type: String,
			default: '',
			required: false
		}
	},
	setup(props) {
		onMounted(function () {
			let prevIcon = props.icon
			watchEffect(() => {
				if (props.icon !== prevIcon) {
					console.debug(`nc-icon changed from '${prevIcon}' to '${props.icon}'`)
				}
			})
		})
		return {}
	}
}
