// form/nc/report/product-label/product-label.js

export default {
	setup() {
		function setRecord(item) {
			nc.mergeState(state, 'rec', item, 'product-label.js')
		}

		function callback() {
			const arr = state.grid && state.grid.product_label && state.grid.product_label.data
			state.rec.pr = {}
			state.rec.pro = {}
			if (arr && arr.length > 0) {
				setRecord(arr[0])
				nc.gridActivateRows(state, 'product_label', 1)
			}
		}

		function gridRowClicked(area) {
			const arr = nc.gridActivatedRecordArr(state, area)
			if (arr.length > 0) {
				setRecord(arr[0])
			}
		}

		function update() {
			const param = {
				production_lot: state.rec.production_lot
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'form/nc/report/product-label/grid.json',
					return: {
						grid: [
							{
								name: 'product_label'
							}
						]
					},
					parameter: param
				},
				callback
			)
		}

		callback() // first data load
		return { update, gridRowClicked }
	}
}
