// nc-draw/nc-barcode.js
import { openBlock as _openBlock, createElementBlock as _createElementBlock } from '../../vuelib.js'

const _hoisted_1 = ["id"]

export function render(_ctx, _cache) {
  return (_openBlock(), _createElementBlock("img", {
    class: "nc-barcode",
    id: _ctx.id
  }, null, 8 /* PROPS */, _hoisted_1))
}
// src/components/nc-draw/nc-barcode.vue
import nc from '../../core/nc-util.js'
// import JsBarcode from 'jsbarcode'

export default {
	name: 'NcBarcode',
	props: {
		id: {
			type: String,
			default: 'nc-barcode-1',
			required: false
		},
		model: {
			type: String,
			default: undefined,
			required: true
		},
		format: {
			type: String,
			default: 'CODE128',
			required: false
		},
		codeWidth: {
			type: [Number, String],
			default: undefined,
			required: false,
			description: 'Width of a single bar in pixels, default is 2.'
		},
		codeHeight: {
			type: [Number, String],
			default: '60px', // shows also text on the bottom
			required: false
		}
	},
	setup(props) {
		const state = inject('state')
		onMounted(() => {
			watchEffect(() => {
				const value = nc.recData(state, props.model)
				const options = {
					format: props.format
				}
				if (props.codeHeight) {
					options.height = props.codeHeight // setting undefined or null will prevent drawing
				}
				if (props.codeWidth) {
					options.width = props.codeWidth
				}
				if (typeof JsBarcode !== 'undefined') {
					JsBarcode('#' + props.id, value || ' ', options) // '' is not valid input for JsBarcode
				}
			})
		})
	}
}
