// nc-draw/nc-image.js
import { mergeProps as _mergeProps, createElementVNode as _createElementVNode, normalizeStyle as _normalizeStyle, openBlock as _openBlock, createElementBlock as _createElementBlock, createCommentVNode as _createCommentVNode } from '../../vuelib.js'

const _hoisted_1 = {
  class: "nc-image",
  ref: "root"
}
const _hoisted_2 = ["src", "alt"]
const _hoisted_3 = ["src", "alt"]

export function render(_ctx, _cache) {
  return (_openBlock(), _createElementBlock("div", _hoisted_1, [
    (_ctx.dataUrl)
      ? (_openBlock(), _createElementBlock("div", {
          key: 0,
          class: "nc-img__placeholder",
          style: _normalizeStyle({ background: _ctx.background })
        }, [
          _createElementVNode("img", _mergeProps({
            src: _ctx.placeholder || _ctx.dataUrl,
            alt: _ctx.attrs.alt || ""
          }, _ctx.attrs, {
            loading: "lazy",
            decoding: "async"
          }), null, 16 /* FULL_PROPS */, _hoisted_2)
        ], 4 /* STYLE */))
      : _createCommentVNode("v-if", true),
    _createElementVNode("img", _mergeProps({
      class: "nc-img__img",
      src: _ctx.dataUrl,
      alt: _ctx.attrs.alt || ""
    }, _ctx.attrs, {
      style: _ctx.imageStyle,
      loading: "lazy",
      decoding: "async"
    }), null, 16 /* FULL_PROPS */, _hoisted_3)
  ], 512 /* NEED_PATCH */))
}
// /src/components/nc-draw/nc-image.vue
// see: https://dev.to/pfacklam/native-lazy-loading-of-images-with-zero-javascript-3hnf
// see: https://dev.to/jordanfinners/3-attributes-your-images-must-have-3fhj
// avif from: https://jakearchibald.com/2020/avif-has-landed/
// code from: https://stegosource.com/create-lazy-loading-image-component-faster-vue-js-apps/
// https://codesandbox.io/s/vue-lazy-load-image-ls9rh?fontsize=14&hidenavigation=1&module=%2Fsrc%2FApp.vue&theme=dark

// change 85 in css and code to change animation speed

export default {
	name: 'NcImage',
	inheritAttrs: false,
	props: {
		src: {
			type: String,
			default: undefined,
			requred: false
		},
		placeholder: {
			type: String,
			default: undefined,
			requred: false
		},
		background: {
			type: String,
			default: undefined,
			requred: false
		},
		imageStyle: {
			type: [String, Object],
			default: undefined,
			requred: false
		}
	},

	setup(props, ctx) {
		const root = ref() // div ref="root"

		const dataUrl = computed(() => {
			const { width, height } = ctx.attrs
			if (!width || !height) return ''
			// create a tiny png with matching aspect ratio as img
			const w = 100
			const canvas = document.createElement('canvas')
			canvas.width = w
			canvas.height = (height / width) * w
			return canvas.toDataURL()
		})

		let timeOut, observer
		onMounted(function () {
			const { src, srcset } = props
			const $el = root.value // ctx.parent.vnode.el
			observer = new IntersectionObserver(([entry]) => {
				const img = $el.querySelector(`.nc-img__img`)
				const placeholder = $el.querySelector(`.nc-img__placeholder`)
				img.onload = function () {
					delete img.onload
					$el.classList.add(`nc-img--loaded`)
					if (placeholder) {
						timeOut = setTimeout(() => {
							placeholder.remove()
						}, 85)
					}
				}
				if (entry.isIntersecting) {
					// Element is in viewport
					console.debug(
						`* lazy load image src='${src}' ${srcset ? ", srcset='" + srcset + "'" : ''}, width=${ctx.attrs.width}, height=${
							ctx.attrs.height
						}`
					)
					if (srcset) {
						img.srcset = srcset
					}
					img.src = src
					observer.disconnect()
				}
			})
			observer.observe($el)
		})

		onBeforeUnmount(function () {
			// this.$once('hook:beforeUnmount', () => {
			if (observer) observer.disconnect()
			if (timeOut) {
				clearTimeout(timeOut)
			}
			// })
		})

		return { root, dataUrl, attrs: ctx.attrs }
	}
}
