// plugin/vue-renderer/renderer/compileVueFile.js
import fs from 'fs'
import pug from 'pug'
import sass from 'sass'
import { replaceContent } from './replace-content.js'
import { parse, compileScript, compileTemplate, compileStyle } from '../vuelib.js' // '@vue/compiler-sfc' // './vuelib.js'
import peg from './nc-peg.js' //'../../../../nc-designer/src/core/nc-peg.js'

const jsStart = `
import { ref, computed, watchEffect, onBeforeMount, onMounted, onBeforeUpdate, onUpdated, onBeforeUnmount, onUnmounted, onActivated, onDeactivated, provide } from '/src/core/vue.js'
import { dt, message, nc, peg } from '/src/core/nc-dynamic-form.js'

`
let id = 10000
export function compileVueFile(srcPath, fileName, newComponentPath, ssr, sourceMap = false) {
	if (fs.existsSync(newComponentPath + fileName + '.js')) {
		fileName = newComponentPath + fileName + '.js'
	} else {
		console.log(`🚀 compileVueFile.js ~ creating file:`, newComponentPath + fileName + '.js')
		const fileNameVue = fileName + '.vue'
		let vuePath
		let content
		if (fs.existsSync(srcPath + fileName)) {
			vuePath = '/src/core/vue.js'
			const js = jsStart + fs.readFileSync(srcPath + fileName.replace('.html', '2.js'), 'utf-8')
			content =
				'<template>\n' + fs.readFileSync(srcPath + fileName, 'utf-8') + '</template>\n\n' + '<script setup>\n' + js + '\n</script>\n'
		} else {
			content = fs.readFileSync(srcPath + fileName + '.vue', 'utf-8')
		}
		const parsed = parse(content, { sourceMap: sourceMap, filename: fileNameVue })
		id++
		const script = compileScript(parsed.descriptor, { id: 'nc-script-' + id, filename: fileNameVue })
		let code = script.content // .replace('"vue"', '"./vue.js"')
		if (parsed.descriptor.template) {
			let html = parsed.descriptor.template.content
			if (parsed.descriptor.template.lang === 'pug') {
				const pugOptions = {}
				const fn = pug.compile(html, pugOptions)
				const pugLocals = {}
				html = fn(pugLocals)
			}
			id++
			const render = compileTemplate({ sourceMap: sourceMap, id: 'nc-template-' + id, source: html, filename: fileNameVue, ssr: ssr })
			// const name = peg.parseAfterLast(fileName, '/')
			code = replaceContent(fileName, code + '\n\n// render code\n' + render.code, vuePath)
			// const render = compile(parsed.descriptor.template.content) // works but gives a function, not code as text
		}
		const styleArr = []
		const scopedStyleArr = []
		for (const item of parsed.descriptor.styles) {
			let css = item.content
			if (item.lang === 'scss' || item.lang === 'sass') {
				const result = sass.renderSync({ data: css })
				css = result.css.toString()
			}
			id++
			const ret = compileStyle({ id: 'nc-style-' + id, source: css, filename: fileName })
			if (item.scoped) {
				scopedStyleArr.push(ret.code)
			} else {
				styleArr.push(ret.code)
			}
		}
		if (scopedStyleArr.length > 0) {
			console.log(`* component '${fileName}' scoped style:\n${scopedStyleArr}`)
			// TODO: add to ../component/core/nc-component-style.json
		}
		if (styleArr.length > 0) {
			console.log(`* component '${fileName}' style:\n${styleArr}`)
			// TODO: add to ../component/core/nc-component-style.json
		}
		const path = peg.parseBeforeLast(fileName, '/')
		if (path !== fileName && !fs.existsSync(newComponentPath + path)) {
			fs.mkdirSync(newComponentPath + path)
		}
		fileName = newComponentPath + fileName + '.js'
		fs.writeFileSync(fileName, code)
		// console.log(`🚀 compileVueFile.js ~ created file:`, fileName)
	}
	/*
	// import(dataUri) does needs full path for access to existing files: `import { fn } from 'file:///${process.cwd()}/dyn-import-existing.js'; fn(10);`
	// https://2ality.com/2019/10/eval-via-import.html
	const dataUri = 'data:text/javascript;charset=utf-8,' + encodeURIComponent(code)
	const ret = await import(dataUri)
	*/
	const ret = import(fileName)
	console.log(`🚀 compileVueFile.js ~ imported file:`, fileName)
	return ret
}
